/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.QNameTest;

public class UnionQNameTest
implements QNameTest {
    List<QNameTest> tests;

    public UnionQNameTest(List<QNameTest> tests) {
        this.tests = new ArrayList<QNameTest>(tests);
    }

    @Override
    public boolean matches(StructuredQName qname) {
        for (QNameTest test : this.tests) {
            if (!test.matches(qname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesFingerprint(NamePool namePool, int fp) {
        for (QNameTest test : this.tests) {
            if (!test.matchesFingerprint(namePool, fp)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        boolean started = false;
        StringBuilder fsb = new StringBuilder(256);
        for (QNameTest qt : this.tests) {
            if (started) {
                fsb.append("|");
            } else {
                started = true;
            }
            fsb.append(qt.toString());
        }
        return fsb.toString();
    }

    @Override
    public String exportQNameTest() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (QNameTest test : this.tests) {
            if (!first) {
                builder.append(" ");
            } else {
                first = false;
            }
            builder.append(test.exportQNameTest());
        }
        return builder.toString();
    }
}

