/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The "getOwnerElement()" will return the Element node this attribute is attached to or
 * null if this attribute is not in use.
 * Retreive the default attribute defaultAttr and check its owner element.  Verify if the name
 * the nodeName of the returned ownerElement is emp:employee.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Attr-ownerElement">http://www.w3.org/TR/DOM-Level-2-Core/core#Attr-ownerElement</a>
 * @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=259">http://www.w3.org/Bugs/Public/show_bug.cgi?id=259</a>
 */
public class attrgetownerelement01 {

    @Test
    @Disabled
    public void testRun() throws Throwable {
        Document doc = load("staffNS", false);
        NodeList elementList = doc.getElementsByTagNameNS("http://www.nist.gov", "employee");
        Element element = (Element) elementList.item(1);
        NamedNodeMap attributes = element.getAttributes();
        Attr attr = (Attr) attributes.getNamedItemNS(null, "defaultAttr");
        Element ownerElement = attr.getOwnerElement();
        String ownerElementName = ownerElement.getNodeName();
        assertEquals("emp:employee", ownerElementName, "attrgetownerelement01");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/attrgetownerelement01";
    }

}






