
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 

  The "createDocumentType(qualifiedName,publicId,systemId)" method for a 

  DOMImplementation should raise NAMESPACE_ERR DOMException if

  qualifiedName is malformed.

  

  Retrieve the DOMImplementation on the XMLNS Document.

  Invoke method createDocumentType(qualifiedName,publicId,systemId)

  on the retrieved DOMImplementation with qualifiedName being the literal

  string "prefix::local", publicId as "STAFF", and systemId as "staff".

  Method should raise NAMESPACE_ERR DOMException.


* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NAMESPACE_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NAMESPACE_ERR'])</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Level-2-Core-DOM-createDocType">http://www.w3.org/TR/DOM-Level-2-Core/core#Level-2-Core-DOM-createDocType</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('Level-2-Core-DOM-createDocType')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NAMESPACE_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('Level-2-Core-DOM-createDocType')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NAMESPACE_ERR'])</a>
*/

/**
 *
 * @ignore true
*/

public class createDocumentType01 extends DOMTestCase {

public createDocumentType01(String name){super(name);	}

public static Test suite() {	return new TestSuite(createDocumentType01.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public createDocumentType01(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      String publicId = "STAFF";
      String systemId = "staff.xml";
      String malformedName = "prefix::local";
      Document doc;
      DOMImplementation domImpl;
      DocumentType newType;
      doc = (Document) load("staffNS", false);
      domImpl = doc.getImplementation();
      
      {
         boolean success = false;
         try {
            newType = domImpl.createDocumentType(malformedName, publicId, systemId);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NAMESPACE_ERR);
         }
         assertTrue("throw_NAMESPACE_ERR", success);
      }

   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/createDocumentType01";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(createDocumentType01.class, args);
   }
}
