
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.*;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 

    The "setAttributeNS(namespaceURI,qualifiedName,value)" method adds a new attribute.

   If an attribute with the same local name and namespace URI is already present

   on the element, its prefix is changed to be the prefix part of the "qualifiedName",

   and its vale is changed to be the "value" paramter.

   null value if no previously existing Attr node with the

   same name was replaced.

   

   Add a new attribute to the "emp:address" element.

   Check to see if the new attribute has been successfully added to the document

   by getting the attributes value, namespace URI, local Name and prefix.


*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAttrNS</a>
*/
public class setAttributeNS09 extends DOMTestCase {public setAttributeNS09(String name){super(name);	}public static Test suite() {	return new TestSuite(setAttributeNS09.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public setAttributeNS09(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      String localName = "newAttr";
      String namespaceURI = "http://www.newattr.com";
      String qualifiedName = "emp:newAttr";
      Document doc;
      NodeList elementList;
      Node testAddr;
      Attr addrAttr;
      String resultAttr;
      String resultNamespaceURI;
      String resultLocalName;
      String resultPrefix;
      doc = (Document) load("staffNS", true);
      elementList = doc.getElementsByTagName("emp:address");
      testAddr = elementList.item(0);
      ((Element) /*Node */testAddr).setAttributeNS(namespaceURI, qualifiedName, "newValue");
      addrAttr = ((Element) /*Node */testAddr).getAttributeNodeNS(namespaceURI, localName);
      resultAttr = ((Element) /*Node */testAddr).getAttributeNS(namespaceURI, localName);
      assertEquals("attrValue", "newValue", resultAttr);
      resultNamespaceURI = addrAttr.getNamespaceURI();
      assertEquals("nsuri", "http://www.newattr.com", resultNamespaceURI);
      resultLocalName = addrAttr.getLocalName();
      assertEquals("lname", "newAttr", resultLocalName);
      resultPrefix = addrAttr.getPrefix();
      assertEquals("prefix", "emp", resultPrefix);
      
   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setAttributeNS09";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(setAttributeNS09.class, args);
   }
}
