
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 
    The method getPrefix returns the namespace prefix of this node, or null if it is unspecified.
  
     Ceate two new element nodes and atribute nodes, with and without namespace prefixes.
     Retreive the prefix part of their qualified names using getPrefix and verify
     if it is correct.

*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSPrefix">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSPrefix</a>
*/
public class nodegetprefix03 extends DOMTestCase {public nodegetprefix03(String name){super(name);	}public static Test suite() {	return new TestSuite(nodegetprefix03.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodegetprefix03(DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      Element element;
      Element qelement;
      Attr attr;
      Attr qattr;
      String elemNoPrefix;
      String elemPrefix;
      String attrNoPrefix;
      String attrPrefix;
      doc = (Document) load("staff", false);
      element = doc.createElementNS("http://www.w3.org/DOM/Test/elem", "elem");
      qelement = doc.createElementNS("http://www.w3.org/DOM/Test/elem", "qual:qelem");
      attr = doc.createAttributeNS("http://www.w3.org/DOM/Test/attr", "attr");
      qattr = doc.createAttributeNS("http://www.w3.org/DOM/Test/attr", "qual:qattr");
      elemNoPrefix = element.getPrefix();
      elemPrefix = qelement.getPrefix();
      attrNoPrefix = attr.getPrefix();
      attrPrefix = qattr.getPrefix();
      assertNull("nodegetprefix03_1", elemNoPrefix);
      assertEquals("nodegetprefix03_2", "qual", elemPrefix);
      assertNull("nodegetprefix03_3", attrNoPrefix);
      assertEquals("nodegetprefix03_4", "qual", attrPrefix);
      
   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/nodegetprefix03";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(nodegetprefix03.class, args);
   }
}
