
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.*;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 
    The method createElementNS raises a NAMESPACE_ERR if the qualifiedName 
    has a prefix that is "xml" and the namespaceURI is different
    from http://www.w3.org/XML/1998/namespace
    
    Invoke the createElementNS method on this DOMImplementation object with  
    the qualifiedName as xml:root and namespaceURI as http://www.w3.org/xml/1998/namespace
    Check if the NAMESPACE_ERR exception is thrown.

*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrElNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrElNS</a>
*/
public class documentcreateelementNS06 extends DOMTestCase {public documentcreateelementNS06(String name){super(name);	}public static Test suite() {	return new TestSuite(documentcreateelementNS06.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public documentcreateelementNS06(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      Document newDoc;
      DocumentType docType = null;

      DOMImplementation domImpl;
      Element element;
      String namespaceURI = "http://www.w3.org/xml/1998/namespace ";
      String qualifiedName = "xml:root";
      doc = (Document) load("staffNS", false);
      domImpl = doc.getImplementation();
      newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "dom:doc", docType);
      
      {
         boolean success = false;
         try {
            element = newDoc.createElementNS(namespaceURI, qualifiedName);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NAMESPACE_ERR);
         }
         assertTrue("documentcreateelementNS06,xml:root and namespaceURI as http://www.w3.org/xml/1998/namespace ", success);
      }

   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentcreateelementNS06";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(documentcreateelementNS06.class, args);
   }
}
