
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 
    The "createAttribute(name)" method creates an Attribute 
   node of the given name.
   
   Retrieve the entire DOM document and invoke its 
   "createAttribute(name)" method.  It should create a  
   new Attribute node with the given name. The name, value
   and type of the newly created object are retrieved and
   output.
   
  Unlike the DOM 1 Core equivalent, this test can expect the
  attribute name to be upper case for HTML documents.   

*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=236">http://www.w3.org/Bugs/Public/show_bug.cgi?id=236</a>
* @see <a href="http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html">http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html</a>
*/
public class hc_documentcreateattribute extends DOMTestCase {public hc_documentcreateattribute(String name){super(name);	}public static Test suite() {	return new TestSuite(hc_documentcreateattribute.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public hc_documentcreateattribute(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      Attr newAttrNode;
      String attrValue;
      String attrName;
      int attrType;
      doc = (Document) load("hc_staff", true);
      newAttrNode = doc.createAttribute("style");
      attrValue = newAttrNode.getNodeValue();
      assertEquals("value", "", attrValue);
      attrName = newAttrNode.getNodeName();
      assertEquals("name", "style", attrName);
      attrType = (int) newAttrNode.getNodeType();
      assertEquals("type", 2, attrType);
      
   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/hc_documentcreateattribute";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(hc_documentcreateattribute.class, args);
   }
}
