
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 
    The importNode method imports a node from another document to this document. 
    The returned node has no parent; (parentNode is null). The source node is not 
    altered or removed from the original document but a new copy of the source node
    is created.
    
    Using the method importNode with deep=false, import a newly created DocumentFragment node
    with the first address element from this Document appended to it into this document. 
    Since deep=true, a DocumentFragment with its child should be returned 

*
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
*/

/**
   * seems to run infinite loop--TODO--put back in with newstore2
   *
   * @ignore true
 */
public class documentimportnode10 extends DOMTestCase {public documentimportnode10(String name){super(name);	}public static Test suite() {	return new TestSuite(documentimportnode10.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentimportnode10(DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      DocumentFragment docFragment;
      NodeList childList;
      boolean success;
      Node addressNode;
      Node appendedChild;
      Node importedDocFrag;
      doc = (Document) load("staffNS", true);
      docFragment = doc.createDocumentFragment();
      childList = doc.getElementsByTagNameNS("*", "address");
      addressNode = childList.item(0);
     
      appendedChild = docFragment.appendChild(addressNode);
       System.out.println(" PAss 0");
      importedDocFrag = doc.importNode(docFragment, true);
       System.out.println(" PAss 1");
      success = importedDocFrag.hasChildNodes();
      assertTrue("documentimportnode10", success);
      
   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentimportnode10";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(documentimportnode10.class, args);
   }
}
