/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.RegexFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class Replace
extends RegexFunction {
    private boolean replacementChecked = false;

    @Override
    protected boolean allowRegexMatchingEmptyString() {
        return false;
    }

    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        UnicodeString rep;
        boolean maybeQ;
        boolean bl = maybeQ = arguments.length == 4 && (!(arguments[3] instanceof StringLiteral) || ((StringLiteral)arguments[3]).stringify().contains("q"));
        if (arguments[2] instanceof StringLiteral && !maybeQ && Replace.checkReplacement(rep = ((StringLiteral)arguments[2]).getString()) == null) {
            this.replacementChecked = true;
        }
        return super.makeFunctionCall(arguments);
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        String msg;
        StringValue arg0 = (StringValue)arguments[0].head();
        UnicodeString input = arg0 == null ? EmptyUnicodeString.getInstance() : arg0.getUnicodeStringValue();
        UnicodeString replacement = arguments[2].head().getUnicodeStringValue();
        RegularExpression re = this.getRegularExpression(arguments);
        if (!re.getFlags().contains("q") && !this.replacementChecked && (msg = Replace.checkReplacement(replacement)) != null) {
            throw new XPathException(msg, "FORX0004", context);
        }
        return new StringValue(re.replace(input, replacement));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkReplacement(UnicodeString rep) {
        int i = 0;
        while ((long)i < rep.length()) {
            int index;
            int next;
            int c = rep.codePointAt(i);
            if (c == 36) {
                if ((long)(i + 1) >= rep.length()) return "Invalid replacement string in replace(): $ sign at end of string";
                if ((next = rep.codePointAt(index = ++i)) < 48 || next > 57) {
                    return "Invalid replacement string in replace(): $ sign must be followed by digit 0-9";
                }
            } else if (c == 92) {
                if ((long)(i + 1) >= rep.length()) return "Invalid replacement string in replace(): \\ character at end of string";
                if ((next = rep.codePointAt(index = ++i)) != 92 && next != 36) {
                    return "Invalid replacement string in replace(): \\ character must be followed by \\ or $";
                }
            }
            ++i;
        }
        return null;
    }
}

