/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.stress.AbstractFileHandler;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.XLSBUnsupportedException;
import org.apache.poi.xssf.extractor.XSSFBEventBasedExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.jupiter.api.Test;

class XSSFBFileHandler
extends AbstractFileHandler {
    XSSFBFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)stream, (OutputStream)out);
        byte[] bytes = out.toByteArray();
        try (OPCPackage opcPackage = OPCPackage.open((InputStream)new ByteArrayInputStream(bytes));){
            this.testOne(opcPackage);
        }
        this.testNotHandledByWorkbookException(OPCPackage.open((InputStream)new ByteArrayInputStream(bytes)));
    }

    private void testNotHandledByWorkbookException(OPCPackage pkg) throws IOException {
        try {
            new XSSFWorkbook(pkg).close();
        }
        catch (XLSBUnsupportedException xLSBUnsupportedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleExtracting(File file) throws Exception {
        try (OPCPackage pkg = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            this.testOne(pkg);
        }
        pkg = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        try {
            this.testNotHandledByWorkbookException(pkg);
        }
        finally {
            pkg.close();
        }
    }

    private void testOne(OPCPackage pkg) throws Exception {
        XSSFBEventBasedExcelExtractor ex = new XSSFBEventBasedExcelExtractor(pkg);
        String txt = ex.getText();
        if (txt.length() < 1) {
            throw new RuntimeException("Should have gotten some text.");
        }
    }

    @Test
    void testLocal() throws Exception {
        File file = new File("test-data/spreadsheet/Simple.xlsb");
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
    }

    static {
        AbstractFileHandler.EXPECTED_EXTRACTOR_FAILURES.add("spreadsheet/protected_passtika.xlsb");
    }
}

