/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.poi.util.SuppressForbidden;

@SuppressForbidden(value="class only exists for manual tests in XSSFFileHandler")
public class HeapDump {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    public static void dumpHeap(String fileName, boolean live) throws IOException {
        try {
            if (HeapDump.isIbmVm()) {
                HeapDump.dumpHeapJ9(fileName);
            } else {
                HeapDump.initHotspotMBean();
                HeapDump.dumpHeapHotSpot(fileName, live);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() throws IOException {
        if (hotspotMBean != null) return;
        Class<HeapDump> clazz = HeapDump.class;
        synchronized (HeapDump.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = HeapDump.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
    }

    private static boolean isIbmVm() {
        try {
            Class.forName("com.ibm.jvm.Dump");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void dumpHeapJ9(String fileName) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> dump = Class.forName("com.ibm.jvm.Dump");
        Method heapDumpToFile = dump.getMethod("heapDumpToFile", String.class);
        heapDumpToFile.invoke(dump, fileName);
    }

    private static void dumpHeapHotSpot(String fileName, boolean live) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method dumpHeap = hotspotMBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        dumpHeap.invoke((Object)hotspotMBean, fileName, live);
    }
}

