/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.POIDocument;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.hwpf.model.PicturesTable;
import org.apache.poi.stress.POIFSFileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HWPFFileHandler
extends POIFSFileHandler {
    HWPFFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        HWPFDocument doc = new HWPFDocument(stream);
        Assertions.assertNotNull((Object)doc.getBookmarks());
        Assertions.assertNotNull((Object)doc.getCharacterTable());
        Assertions.assertNotNull((Object)doc.getEndnotes());
        PicturesTable picturesTable = doc.getPicturesTable();
        List pictures = picturesTable.getAllPictures();
        Assertions.assertNotNull((Object)pictures);
        this.handlePOIDocument((POIDocument)doc);
    }

    @Override
    @Test
    void test() throws Exception {
        File file = new File("test-data/document/52117.doc");
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
        stream = new FileInputStream(file);
        var3_3 = null;
        try (WordExtractor extractor = new WordExtractor((InputStream)stream);){
            Assertions.assertNotNull((Object)extractor.getText());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var3_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test
    void testExtractingOld() {
        File file = new File("test-data/document/52117.doc");
        Assertions.assertDoesNotThrow(() -> this.handleExtracting(file));
    }
}

