/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.usermodel;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.impl.CTRowImpl;

public class AligningCells {
    public static void main(String[] args) throws IOException {
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            XSSFSheet sheet = wb.createSheet();
            XSSFRow row = sheet.createRow(2);
            row.setHeightInPoints(30.0f);
            for (int i = 0; i < 8; ++i) {
                sheet.setColumnWidth(i, 3840);
            }
            AligningCells.createCell(wb, row, 0, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
            AligningCells.createCell(wb, row, 1, HorizontalAlignment.CENTER_SELECTION, VerticalAlignment.BOTTOM);
            AligningCells.createCell(wb, row, 2, HorizontalAlignment.FILL, VerticalAlignment.CENTER);
            AligningCells.createCell(wb, row, 3, HorizontalAlignment.GENERAL, VerticalAlignment.CENTER);
            AligningCells.createCell(wb, row, 4, HorizontalAlignment.JUSTIFY, VerticalAlignment.JUSTIFY);
            AligningCells.createCell(wb, row, 5, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
            AligningCells.createCell(wb, row, 6, HorizontalAlignment.RIGHT, VerticalAlignment.TOP);
            row = sheet.createRow(3);
            AligningCells.centerAcrossSelection(wb, row, 1, 3, VerticalAlignment.CENTER);
            try (FileOutputStream fileOut = new FileOutputStream("xssf-align.xlsx");){
                wb.write((OutputStream)fileOut);
            }
        }
    }

    private static void createCell(XSSFWorkbook wb, XSSFRow row, int column, HorizontalAlignment halign, VerticalAlignment valign) {
        XSSFCreationHelper ch = wb.getCreationHelper();
        XSSFCell cell = row.createCell(column);
        cell.setCellValue(ch.createRichTextString("Align It"));
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(halign);
        cellStyle.setVerticalAlignment(valign);
        cell.setCellStyle((CellStyle)cellStyle);
    }

    private static void centerAcrossSelection(XSSFWorkbook wb, XSSFRow row, int start_column, int end_column, VerticalAlignment valign) {
        XSSFCreationHelper ch = wb.getCreationHelper();
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        cellStyle.setVerticalAlignment(valign);
        for (int i = start_column; i <= end_column; ++i) {
            XSSFCell cell = row.createCell(i);
            cell.setCellStyle((CellStyle)cellStyle);
        }
        XSSFCell cell = row.getCell(start_column);
        cell.setCellValue(ch.createRichTextString("Align It"));
        CTRowImpl ctRow = (CTRowImpl)row.getCTRow();
        String span = start_column + ":" + end_column;
        ArrayList<String> spanList = new ArrayList<String>();
        spanList.add(span);
        ctRow.setSpans(spanList);
    }
}

