/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.crypt;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class OOXMLPasswordsTry {
    private OOXMLPasswordsTry() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Use:");
            System.err.println("  OOXMLPasswordsTry <file.ooxml> <wordlist>");
            System.exit(1);
        }
        String ooxml = args[0];
        String words = args[1];
        System.out.println("Trying passwords from " + words + " against " + ooxml);
        System.out.println();
        try (POIFSFileSystem fs = new POIFSFileSystem(new File(ooxml), true);){
            EncryptionInfo info = new EncryptionInfo(fs);
            Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
            long start = System.currentTimeMillis();
            int[] count = new int[]{0};
            Predicate<String> counter = s -> {
                count[0] = count[0] + 1;
                if (count[0] % 1000 == 0) {
                    int secs = (int)((System.currentTimeMillis() - start) / 1000L);
                    System.out.println("Done " + count[0] + " passwords, " + secs + " seconds, last password " + s);
                }
                return true;
            };
            try (Stream<String> lines = Files.lines(Paths.get(words, new String[0]));){
                Optional<String> found = lines.filter(counter).filter(w -> OOXMLPasswordsTry.isValid(d, w)).findFirst();
                System.out.println(found.map(s -> "Password found: " + s).orElse("Error - No password matched"));
            }
        }
    }

    private static boolean isValid(Decryptor dec, String password) {
        try {
            return dec.verifyPassword(password);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }
}

