/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xslf;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFDoughnutChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFChart;
import org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;

public final class DoughnutChartFromScratch {
    private static final int COLUMN_LANGUAGES = 0;
    private static final int COLUMN_COUNTRIES = 1;
    private static final int COLUMN_SPEAKERS = 2;

    private DoughnutChartFromScratch() {
    }

    private static void usage() {
        System.out.println("Usage: DoughnutChartFromScratch <bar-chart-data.txt>");
        System.out.println("    bar-chart-data.txt          the model to set. First line is chart title, then go pairs {axis-label value}");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            DoughnutChartFromScratch.usage();
            return;
        }
        try (BufferedReader modelReader = Files.newBufferedReader(Paths.get(args[0], new String[0]), StandardCharsets.UTF_8);){
            Throwable throwable;
            String ln;
            String chartTitle = modelReader.readLine();
            String[] series = modelReader.readLine().split(",");
            ArrayList<String> listLanguages = new ArrayList<String>(10);
            ArrayList<Double> listCountries = new ArrayList<Double>(10);
            ArrayList<Double> listSpeakers = new ArrayList<Double>(10);
            while ((ln = modelReader.readLine()) != null) {
                String[] vals = ln.split(",");
                listCountries.add(Double.valueOf(vals[0]));
                listSpeakers.add(Double.valueOf(vals[1]));
                listLanguages.add(vals[2]);
            }
            String[] categories = listLanguages.toArray(new String[0]);
            Double[] values1 = listCountries.toArray(new Double[0]);
            Double[] values2 = listSpeakers.toArray(new Double[0]);
            try (XMLSlideShow ppt = new XMLSlideShow();){
                DoughnutChartFromScratch.createSlideWithChart(ppt, chartTitle, series, categories, values1, 1);
                DoughnutChartFromScratch.createSlideWithChart(ppt, chartTitle, series, categories, values2, 2);
                throwable = null;
                try (FileOutputStream out = new FileOutputStream("doughnut-chart-from-scratch.pptx");){
                    ppt.write((OutputStream)out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            var13_15 = null;
            try (FileInputStream is = new FileInputStream("doughnut-chart-from-scratch.pptx");){
                throwable = null;
                try (XMLSlideShow ppt = new XMLSlideShow((InputStream)is);){
                    for (XSLFSlide slide : ppt.getSlides()) {
                        for (XSLFShape shape : slide.getShapes()) {
                            XSLFGraphicFrame frame;
                            if (!(shape instanceof XSLFGraphicFrame) || !(frame = (XSLFGraphicFrame)shape).hasChart()) continue;
                            System.out.println(frame.getChart().getTitleShape().getText());
                        }
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var13_15 = throwable4;
                throw throwable4;
            }
        }
        System.out.println("Done");
    }

    private static void createSlideWithChart(XMLSlideShow ppt, String chartTitle, String[] series, String[] categories, Double[] values, int valuesColumn) {
        XSLFSlide slide = ppt.createSlide();
        XSLFChart chart = ppt.createChart();
        Rectangle rect2D = new Rectangle(DoughnutChartFromScratch.fromCM(1.5), DoughnutChartFromScratch.fromCM(4.0), DoughnutChartFromScratch.fromCM(22.0), DoughnutChartFromScratch.fromCM(14.0));
        slide.addChart(chart, (Rectangle2D)rect2D);
        DoughnutChartFromScratch.setDoughnutData(chart, chartTitle, series, categories, values, valuesColumn);
    }

    private static int fromCM(double cm) {
        return (int)Math.rint(cm * 360000.0);
    }

    private static void setDoughnutData(XSLFChart chart, String chartTitle, String[] series, String[] categories, Double[] values, int valuesColumn) {
        int numOfPoints = categories.length;
        String categoryDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 0, 0));
        String valuesDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, valuesColumn, valuesColumn));
        XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange, (int)0);
        XDDFNumericalDataSource valuesData = XDDFDataSourcesFactory.fromArray((Number[])values, (String)valuesDataRange, (int)valuesColumn);
        valuesData.setFormatCode("General");
        XDDFDoughnutChartData data = (XDDFDoughnutChartData)chart.createData(ChartTypes.DOUGHNUT, null, null);
        XDDFDoughnutChartData.Series series1 = (XDDFDoughnutChartData.Series)data.addSeries((XDDFDataSource)categoriesData, valuesData);
        series1.setTitle(series[0], chart.setSheetTitle(series[valuesColumn - 1], valuesColumn));
        data.setVaryColors(Boolean.valueOf(true));
        data.setHoleSize(Integer.valueOf(42));
        data.setFirstSliceAngle(Integer.valueOf(90));
        chart.plot((XDDFChartData)data);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(LegendPosition.LEFT);
        legend.setOverlay(false);
        chart.setTitleText(chartTitle);
        chart.setTitleOverlay(false);
        chart.setAutoTitleDeleted(false);
    }
}

