/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.usermodel;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.PresetColor;
import org.apache.poi.xddf.usermodel.XDDFColor;
import org.apache.poi.xddf.usermodel.XDDFFillProperties;
import org.apache.poi.xddf.usermodel.XDDFLineProperties;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.XDDFSolidFillProperties;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.MarkerStyle;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class LineChart {
    private LineChart() {
    }

    public static void main(String[] args) throws IOException {
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            XSSFSheet sheet = wb.createSheet("linechart");
            int NUM_OF_ROWS = 3;
            int NUM_OF_COLUMNS = 10;
            for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
                XSSFRow row = sheet.createRow((int)((short)rowIndex));
                for (int colIndex = 0; colIndex < 10; ++colIndex) {
                    Cell cell = row.createCell((int)((short)colIndex));
                    cell.setCellValue((double)colIndex * ((double)rowIndex + 1.0));
                }
            }
            XSSFDrawing drawing = sheet.createDrawingPatriarch();
            XSSFClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 0, 5, 10, 15);
            XSSFChart chart = drawing.createChart(anchor);
            XDDFChartLegend legend = chart.getOrAddLegend();
            legend.setPosition(LegendPosition.TOP_RIGHT);
            XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
            bottomAxis.setTitle("x");
            XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
            leftAxis.setTitle("f(x)");
            leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
            XDDFNumericalDataSource xs = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(0, 0, 0, 9));
            XDDFNumericalDataSource ys1 = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(1, 1, 0, 9));
            XDDFNumericalDataSource ys2 = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(2, 2, 0, 9));
            XDDFLineChartData data = (XDDFLineChartData)chart.createData(ChartTypes.LINE, (XDDFChartAxis)bottomAxis, leftAxis);
            XDDFLineChartData.Series series1 = (XDDFLineChartData.Series)data.addSeries((XDDFDataSource)xs, ys1);
            series1.setTitle("2x", null);
            series1.setSmooth(Boolean.valueOf(false));
            series1.setMarkerStyle(MarkerStyle.STAR);
            XDDFLineChartData.Series series2 = (XDDFLineChartData.Series)data.addSeries((XDDFDataSource)xs, ys2);
            series2.setTitle("3x", null);
            series2.setSmooth(Boolean.valueOf(true));
            series2.setMarkerSize((short)6);
            series2.setMarkerStyle(MarkerStyle.TRIANGLE);
            chart.plot((XDDFChartData)data);
            LineChart.solidLineSeries((XDDFChartData)data, 0, PresetColor.CHARTREUSE);
            LineChart.solidLineSeries((XDDFChartData)data, 1, PresetColor.TURQUOISE);
            try (FileOutputStream fileOut = new FileOutputStream("ooxml-line-chart.xlsx");){
                wb.write((OutputStream)fileOut);
            }
        }
    }

    private static void solidLineSeries(XDDFChartData data, int index, PresetColor color) {
        XDDFSolidFillProperties fill = new XDDFSolidFillProperties(XDDFColor.from((PresetColor)color));
        XDDFLineProperties line = new XDDFLineProperties();
        line.setFillProperties((XDDFFillProperties)fill);
        XDDFChartData.Series series = data.getSeries(index);
        XDDFShapeProperties properties = series.getShapeProperties();
        if (properties == null) {
            properties = new XDDFShapeProperties();
        }
        properties.setLineProperties(line);
        series.setShapeProperties(properties);
    }
}

