/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xslf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFPieChartData;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFChart;
import org.apache.poi.xslf.usermodel.XSLFSlide;

public final class PieChartDemo {
    private PieChartDemo() {
    }

    private static void usage() {
        System.out.println("Usage: PieChartDemo <pie-chart-template.pptx> <pie-chart-data.txt>");
        System.out.println("    pie-chart-template.pptx     template with a pie chart");
        System.out.println("    pie-chart-data.txt          the model to set. First line is chart title, then go pairs {axis-label value}");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            PieChartDemo.usage();
            return;
        }
        try (FileInputStream argIS = new FileInputStream(args[0]);
             BufferedReader modelReader = Files.newBufferedReader(Paths.get(args[1], new String[0]), StandardCharsets.UTF_8);){
            String chartTitle = modelReader.readLine();
            try (XMLSlideShow pptx = new XMLSlideShow((InputStream)argIS);){
                String ln;
                XSLFSlide slide = (XSLFSlide)pptx.getSlides().get(0);
                XSLFChart chart = null;
                for (POIXMLDocumentPart part : slide.getRelations()) {
                    if (!(part instanceof XSLFChart)) continue;
                    chart = (XSLFChart)part;
                    break;
                }
                if (chart == null) {
                    throw new IllegalStateException("chart not found in the template");
                }
                List series = chart.getChartSeries();
                XDDFPieChartData pie = (XDDFPieChartData)series.get(0);
                ArrayList<String> listCategories = new ArrayList<String>(3);
                ArrayList<Double> listValues = new ArrayList<Double>(3);
                while ((ln = modelReader.readLine()) != null) {
                    String[] vals = ln.split("\\s+");
                    listCategories.add(vals[0]);
                    listValues.add(Double.valueOf(vals[1]));
                }
                String[] categories = listCategories.toArray(new String[0]);
                Number[] values = listValues.toArray(new Double[0]);
                int numOfPoints = categories.length;
                String categoryDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 0, 0));
                String valuesDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 1, 1));
                XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange);
                XDDFNumericalDataSource valuesData = XDDFDataSourcesFactory.fromArray((Number[])values, (String)valuesDataRange);
                XDDFPieChartData.Series firstSeries = (XDDFPieChartData.Series)pie.getSeries(0);
                firstSeries.replaceData((XDDFDataSource)categoriesData, valuesData);
                firstSeries.setTitle(chartTitle, chart.setSheetTitle(chartTitle, 0));
                firstSeries.setExplosion(Long.valueOf(25L));
                firstSeries.getDataPoint(1L).setExplosion(Long.valueOf(35L));
                chart.plot((XDDFChartData)pie);
                try (FileOutputStream out = new FileOutputStream("pie-chart-demo-output.pptx");){
                    pptx.write((OutputStream)out);
                }
            }
        }
    }
}

