/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.sample;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class ModifyDocumentSummaryInformation {
    private ModifyDocumentSummaryInformation() {
    }

    public static void main(String[] args) throws Exception {
        File summaryFile = new File(args[0]);
        try (POIFSFileSystem poifs = new POIFSFileSystem(summaryFile, false);){
            DocumentSummaryInformation dsi;
            SummaryInformation si;
            DirectoryNode dir = poifs.getRoot();
            try {
                si = (SummaryInformation)PropertySetFactory.create((DirectoryEntry)dir, (String)"\u0005SummaryInformation");
            }
            catch (FileNotFoundException ex) {
                si = PropertySetFactory.newSummaryInformation();
            }
            assert (si != null);
            System.out.println("Author is " + si.getAuthor());
            si.setAuthor("Rainer Klute");
            System.out.println("Author changed to " + si.getAuthor() + ".");
            try {
                dsi = (DocumentSummaryInformation)PropertySetFactory.create((DirectoryEntry)dir, (String)"\u0005DocumentSummaryInformation");
            }
            catch (FileNotFoundException ex) {
                dsi = PropertySetFactory.newDocumentSummaryInformation();
            }
            assert (dsi != null);
            System.out.println("Category is " + dsi.getCategory());
            dsi.setCategory("POI example");
            System.out.println("Category changed to " + dsi.getCategory() + ".");
            CustomProperties customProperties = dsi.getCustomProperties();
            if (customProperties == null) {
                customProperties = new CustomProperties();
            }
            customProperties.put("Key 1", (Object)"Value 1");
            customProperties.put("Schl\u00fcssel 2", (Object)"Wert 2");
            customProperties.put("Sample Number", (Object)12345);
            customProperties.put("Sample Boolean", (Object)Boolean.TRUE);
            customProperties.put("Sample Date", (Object)new Date());
            Object value = customProperties.get((Object)"Sample Number");
            System.out.println("Custom Sample Number is now " + value);
            dsi.setCustomProperties(customProperties);
            si.write((DirectoryEntry)dir, "\u0005SummaryInformation");
            dsi.write((DirectoryEntry)dir, "\u0005DocumentSummaryInformation");
            poifs.writeFilesystem();
        }
    }
}

