/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type State struct {
	SIG_8 bool
	SIG_7 bool
	SIG_6 bool
	SIG_5 bool
	SIG_4 bool
	SIG_3 bool
	SIG_2 bool
	SIG_1 bool
}

// The corresponding interface
type IState interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

func NewState(SIG_8 bool, SIG_7 bool, SIG_6 bool, SIG_5 bool, SIG_4 bool, SIG_3 bool, SIG_2 bool, SIG_1 bool) *State {
	return &State{SIG_8: SIG_8, SIG_7: SIG_7, SIG_6: SIG_6, SIG_5: SIG_5, SIG_4: SIG_4, SIG_3: SIG_3, SIG_2: SIG_2, SIG_1: SIG_1}
}

func CastState(structType interface{}) *State {
	castFunc := func(typ interface{}) *State {
		if casted, ok := typ.(State); ok {
			return &casted
		}
		if casted, ok := typ.(*State); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *State) GetTypeName() string {
	return "State"
}

func (m *State) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *State) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	// Simple field (SIG_8)
	lengthInBits += 1

	// Simple field (SIG_7)
	lengthInBits += 1

	// Simple field (SIG_6)
	lengthInBits += 1

	// Simple field (SIG_5)
	lengthInBits += 1

	// Simple field (SIG_4)
	lengthInBits += 1

	// Simple field (SIG_3)
	lengthInBits += 1

	// Simple field (SIG_2)
	lengthInBits += 1

	// Simple field (SIG_1)
	lengthInBits += 1

	return lengthInBits
}

func (m *State) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func StateParse(readBuffer utils.ReadBuffer) (*State, error) {
	if pullErr := readBuffer.PullContext("State"); pullErr != nil {
		return nil, pullErr
	}

	// Simple Field (SIG_8)
	SIG_8, _SIG_8Err := readBuffer.ReadBit("SIG_8")
	if _SIG_8Err != nil {
		return nil, errors.Wrap(_SIG_8Err, "Error parsing 'SIG_8' field")
	}

	// Simple Field (SIG_7)
	SIG_7, _SIG_7Err := readBuffer.ReadBit("SIG_7")
	if _SIG_7Err != nil {
		return nil, errors.Wrap(_SIG_7Err, "Error parsing 'SIG_7' field")
	}

	// Simple Field (SIG_6)
	SIG_6, _SIG_6Err := readBuffer.ReadBit("SIG_6")
	if _SIG_6Err != nil {
		return nil, errors.Wrap(_SIG_6Err, "Error parsing 'SIG_6' field")
	}

	// Simple Field (SIG_5)
	SIG_5, _SIG_5Err := readBuffer.ReadBit("SIG_5")
	if _SIG_5Err != nil {
		return nil, errors.Wrap(_SIG_5Err, "Error parsing 'SIG_5' field")
	}

	// Simple Field (SIG_4)
	SIG_4, _SIG_4Err := readBuffer.ReadBit("SIG_4")
	if _SIG_4Err != nil {
		return nil, errors.Wrap(_SIG_4Err, "Error parsing 'SIG_4' field")
	}

	// Simple Field (SIG_3)
	SIG_3, _SIG_3Err := readBuffer.ReadBit("SIG_3")
	if _SIG_3Err != nil {
		return nil, errors.Wrap(_SIG_3Err, "Error parsing 'SIG_3' field")
	}

	// Simple Field (SIG_2)
	SIG_2, _SIG_2Err := readBuffer.ReadBit("SIG_2")
	if _SIG_2Err != nil {
		return nil, errors.Wrap(_SIG_2Err, "Error parsing 'SIG_2' field")
	}

	// Simple Field (SIG_1)
	SIG_1, _SIG_1Err := readBuffer.ReadBit("SIG_1")
	if _SIG_1Err != nil {
		return nil, errors.Wrap(_SIG_1Err, "Error parsing 'SIG_1' field")
	}

	if closeErr := readBuffer.CloseContext("State"); closeErr != nil {
		return nil, closeErr
	}

	// Create the instance
	return NewState(SIG_8, SIG_7, SIG_6, SIG_5, SIG_4, SIG_3, SIG_2, SIG_1), nil
}

func (m *State) Serialize(writeBuffer utils.WriteBuffer) error {
	if pushErr := writeBuffer.PushContext("State"); pushErr != nil {
		return pushErr
	}

	// Simple Field (SIG_8)
	SIG_8 := bool(m.SIG_8)
	_SIG_8Err := writeBuffer.WriteBit("SIG_8", (SIG_8))
	if _SIG_8Err != nil {
		return errors.Wrap(_SIG_8Err, "Error serializing 'SIG_8' field")
	}

	// Simple Field (SIG_7)
	SIG_7 := bool(m.SIG_7)
	_SIG_7Err := writeBuffer.WriteBit("SIG_7", (SIG_7))
	if _SIG_7Err != nil {
		return errors.Wrap(_SIG_7Err, "Error serializing 'SIG_7' field")
	}

	// Simple Field (SIG_6)
	SIG_6 := bool(m.SIG_6)
	_SIG_6Err := writeBuffer.WriteBit("SIG_6", (SIG_6))
	if _SIG_6Err != nil {
		return errors.Wrap(_SIG_6Err, "Error serializing 'SIG_6' field")
	}

	// Simple Field (SIG_5)
	SIG_5 := bool(m.SIG_5)
	_SIG_5Err := writeBuffer.WriteBit("SIG_5", (SIG_5))
	if _SIG_5Err != nil {
		return errors.Wrap(_SIG_5Err, "Error serializing 'SIG_5' field")
	}

	// Simple Field (SIG_4)
	SIG_4 := bool(m.SIG_4)
	_SIG_4Err := writeBuffer.WriteBit("SIG_4", (SIG_4))
	if _SIG_4Err != nil {
		return errors.Wrap(_SIG_4Err, "Error serializing 'SIG_4' field")
	}

	// Simple Field (SIG_3)
	SIG_3 := bool(m.SIG_3)
	_SIG_3Err := writeBuffer.WriteBit("SIG_3", (SIG_3))
	if _SIG_3Err != nil {
		return errors.Wrap(_SIG_3Err, "Error serializing 'SIG_3' field")
	}

	// Simple Field (SIG_2)
	SIG_2 := bool(m.SIG_2)
	_SIG_2Err := writeBuffer.WriteBit("SIG_2", (SIG_2))
	if _SIG_2Err != nil {
		return errors.Wrap(_SIG_2Err, "Error serializing 'SIG_2' field")
	}

	// Simple Field (SIG_1)
	SIG_1 := bool(m.SIG_1)
	_SIG_1Err := writeBuffer.WriteBit("SIG_1", (SIG_1))
	if _SIG_1Err != nil {
		return errors.Wrap(_SIG_1Err, "Error serializing 'SIG_1' field")
	}

	if popErr := writeBuffer.PopContext("State"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *State) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
