/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog/log"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type S7ParameterSetupCommunication struct {
	MaxAmqCaller uint16
	MaxAmqCallee uint16
	PduLength    uint16
	Parent       *S7Parameter
}

// The corresponding interface
type IS7ParameterSetupCommunication interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *S7ParameterSetupCommunication) ParameterType() uint8 {
	return 0xF0
}

func (m *S7ParameterSetupCommunication) MessageType() uint8 {
	return 0
}

func (m *S7ParameterSetupCommunication) InitializeParent(parent *S7Parameter) {
}

func NewS7ParameterSetupCommunication(maxAmqCaller uint16, maxAmqCallee uint16, pduLength uint16) *S7Parameter {
	child := &S7ParameterSetupCommunication{
		MaxAmqCaller: maxAmqCaller,
		MaxAmqCallee: maxAmqCallee,
		PduLength:    pduLength,
		Parent:       NewS7Parameter(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastS7ParameterSetupCommunication(structType interface{}) *S7ParameterSetupCommunication {
	castFunc := func(typ interface{}) *S7ParameterSetupCommunication {
		if casted, ok := typ.(S7ParameterSetupCommunication); ok {
			return &casted
		}
		if casted, ok := typ.(*S7ParameterSetupCommunication); ok {
			return casted
		}
		if casted, ok := typ.(S7Parameter); ok {
			return CastS7ParameterSetupCommunication(casted.Child)
		}
		if casted, ok := typ.(*S7Parameter); ok {
			return CastS7ParameterSetupCommunication(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *S7ParameterSetupCommunication) GetTypeName() string {
	return "S7ParameterSetupCommunication"
}

func (m *S7ParameterSetupCommunication) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *S7ParameterSetupCommunication) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Reserved Field (reserved)
	lengthInBits += 8

	// Simple field (maxAmqCaller)
	lengthInBits += 16

	// Simple field (maxAmqCallee)
	lengthInBits += 16

	// Simple field (pduLength)
	lengthInBits += 16

	return lengthInBits
}

func (m *S7ParameterSetupCommunication) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func S7ParameterSetupCommunicationParse(readBuffer utils.ReadBuffer) (*S7Parameter, error) {
	if pullErr := readBuffer.PullContext("S7ParameterSetupCommunication"); pullErr != nil {
		return nil, pullErr
	}

	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]interface{}{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response.")
		}
	}

	// Simple Field (maxAmqCaller)
	maxAmqCaller, _maxAmqCallerErr := readBuffer.ReadUint16("maxAmqCaller", 16)
	if _maxAmqCallerErr != nil {
		return nil, errors.Wrap(_maxAmqCallerErr, "Error parsing 'maxAmqCaller' field")
	}

	// Simple Field (maxAmqCallee)
	maxAmqCallee, _maxAmqCalleeErr := readBuffer.ReadUint16("maxAmqCallee", 16)
	if _maxAmqCalleeErr != nil {
		return nil, errors.Wrap(_maxAmqCalleeErr, "Error parsing 'maxAmqCallee' field")
	}

	// Simple Field (pduLength)
	pduLength, _pduLengthErr := readBuffer.ReadUint16("pduLength", 16)
	if _pduLengthErr != nil {
		return nil, errors.Wrap(_pduLengthErr, "Error parsing 'pduLength' field")
	}

	if closeErr := readBuffer.CloseContext("S7ParameterSetupCommunication"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &S7ParameterSetupCommunication{
		MaxAmqCaller: maxAmqCaller,
		MaxAmqCallee: maxAmqCallee,
		PduLength:    pduLength,
		Parent:       &S7Parameter{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *S7ParameterSetupCommunication) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7ParameterSetupCommunication"); pushErr != nil {
			return pushErr
		}

		// Reserved Field (reserved)
		{
			_err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00))
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (maxAmqCaller)
		maxAmqCaller := uint16(m.MaxAmqCaller)
		_maxAmqCallerErr := writeBuffer.WriteUint16("maxAmqCaller", 16, (maxAmqCaller))
		if _maxAmqCallerErr != nil {
			return errors.Wrap(_maxAmqCallerErr, "Error serializing 'maxAmqCaller' field")
		}

		// Simple Field (maxAmqCallee)
		maxAmqCallee := uint16(m.MaxAmqCallee)
		_maxAmqCalleeErr := writeBuffer.WriteUint16("maxAmqCallee", 16, (maxAmqCallee))
		if _maxAmqCalleeErr != nil {
			return errors.Wrap(_maxAmqCalleeErr, "Error serializing 'maxAmqCallee' field")
		}

		// Simple Field (pduLength)
		pduLength := uint16(m.PduLength)
		_pduLengthErr := writeBuffer.WriteUint16("pduLength", 16, (pduLength))
		if _pduLengthErr != nil {
			return errors.Wrap(_pduLengthErr, "Error serializing 'pduLength' field")
		}

		if popErr := writeBuffer.PopContext("S7ParameterSetupCommunication"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *S7ParameterSetupCommunication) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
