/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog/log"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type S7AddressAny struct {
	TransportSize    TransportSize
	NumberOfElements uint16
	DbNumber         uint16
	Area             MemoryArea
	ByteAddress      uint16
	BitAddress       uint8
	Parent           *S7Address
}

// The corresponding interface
type IS7AddressAny interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *S7AddressAny) AddressType() uint8 {
	return 0x10
}

func (m *S7AddressAny) InitializeParent(parent *S7Address) {
}

func NewS7AddressAny(transportSize TransportSize, numberOfElements uint16, dbNumber uint16, area MemoryArea, byteAddress uint16, bitAddress uint8) *S7Address {
	child := &S7AddressAny{
		TransportSize:    transportSize,
		NumberOfElements: numberOfElements,
		DbNumber:         dbNumber,
		Area:             area,
		ByteAddress:      byteAddress,
		BitAddress:       bitAddress,
		Parent:           NewS7Address(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastS7AddressAny(structType interface{}) *S7AddressAny {
	castFunc := func(typ interface{}) *S7AddressAny {
		if casted, ok := typ.(S7AddressAny); ok {
			return &casted
		}
		if casted, ok := typ.(*S7AddressAny); ok {
			return casted
		}
		if casted, ok := typ.(S7Address); ok {
			return CastS7AddressAny(casted.Child)
		}
		if casted, ok := typ.(*S7Address); ok {
			return CastS7AddressAny(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *S7AddressAny) GetTypeName() string {
	return "S7AddressAny"
}

func (m *S7AddressAny) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *S7AddressAny) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Enum Field (transportSize)
	lengthInBits += 8

	// Simple field (numberOfElements)
	lengthInBits += 16

	// Simple field (dbNumber)
	lengthInBits += 16

	// Simple field (area)
	lengthInBits += 8

	// Reserved Field (reserved)
	lengthInBits += 5

	// Simple field (byteAddress)
	lengthInBits += 16

	// Simple field (bitAddress)
	lengthInBits += 3

	return lengthInBits
}

func (m *S7AddressAny) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func S7AddressAnyParse(readBuffer utils.ReadBuffer) (*S7Address, error) {
	if pullErr := readBuffer.PullContext("S7AddressAny"); pullErr != nil {
		return nil, pullErr
	}

	if pullErr := readBuffer.PullContext("transportSize"); pullErr != nil {
		return nil, pullErr
	}
	// Enum field (transportSize)
	transportSizeCode, _transportSizeCodeErr := readBuffer.ReadUint8("TransportSize", 8)
	if _transportSizeCodeErr != nil {
		return nil, errors.Wrap(_transportSizeCodeErr, "Error serializing 'transportSize' field")
	}
	transportSize, _transportSizeErr := TransportSizeFirstEnumForFieldCode(transportSizeCode)
	if _transportSizeErr != nil {
		return nil, errors.Wrap(_transportSizeErr, "Error serializing 'transportSize' field")
	}
	if closeErr := readBuffer.CloseContext("transportSize"); closeErr != nil {
		return nil, closeErr
	}

	// Simple Field (numberOfElements)
	numberOfElements, _numberOfElementsErr := readBuffer.ReadUint16("numberOfElements", 16)
	if _numberOfElementsErr != nil {
		return nil, errors.Wrap(_numberOfElementsErr, "Error parsing 'numberOfElements' field")
	}

	// Simple Field (dbNumber)
	dbNumber, _dbNumberErr := readBuffer.ReadUint16("dbNumber", 16)
	if _dbNumberErr != nil {
		return nil, errors.Wrap(_dbNumberErr, "Error parsing 'dbNumber' field")
	}

	// Simple Field (area)
	if pullErr := readBuffer.PullContext("area"); pullErr != nil {
		return nil, pullErr
	}
	area, _areaErr := MemoryAreaParse(readBuffer)
	if _areaErr != nil {
		return nil, errors.Wrap(_areaErr, "Error parsing 'area' field")
	}
	if closeErr := readBuffer.CloseContext("area"); closeErr != nil {
		return nil, closeErr
	}

	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 5)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]interface{}{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response.")
		}
	}

	// Simple Field (byteAddress)
	byteAddress, _byteAddressErr := readBuffer.ReadUint16("byteAddress", 16)
	if _byteAddressErr != nil {
		return nil, errors.Wrap(_byteAddressErr, "Error parsing 'byteAddress' field")
	}

	// Simple Field (bitAddress)
	bitAddress, _bitAddressErr := readBuffer.ReadUint8("bitAddress", 3)
	if _bitAddressErr != nil {
		return nil, errors.Wrap(_bitAddressErr, "Error parsing 'bitAddress' field")
	}

	if closeErr := readBuffer.CloseContext("S7AddressAny"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &S7AddressAny{
		TransportSize:    transportSize,
		NumberOfElements: numberOfElements,
		DbNumber:         dbNumber,
		Area:             area,
		ByteAddress:      byteAddress,
		BitAddress:       bitAddress,
		Parent:           &S7Address{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *S7AddressAny) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7AddressAny"); pushErr != nil {
			return pushErr
		}

		if pushErr := writeBuffer.PushContext("transportSize"); pushErr != nil {
			return pushErr
		}
		// Enum field (transportSize)
		_transportSizeErr := writeBuffer.WriteUint8("TransportSize", 8, m.TransportSize.Code(), utils.WithAdditionalStringRepresentation(m.TransportSize.name()))
		if _transportSizeErr != nil {
			return errors.Wrap(_transportSizeErr, "Error serializing 'transportSize' field")
		}
		if popErr := writeBuffer.PopContext("transportSize"); popErr != nil {
			return popErr
		}

		// Simple Field (numberOfElements)
		numberOfElements := uint16(m.NumberOfElements)
		_numberOfElementsErr := writeBuffer.WriteUint16("numberOfElements", 16, (numberOfElements))
		if _numberOfElementsErr != nil {
			return errors.Wrap(_numberOfElementsErr, "Error serializing 'numberOfElements' field")
		}

		// Simple Field (dbNumber)
		dbNumber := uint16(m.DbNumber)
		_dbNumberErr := writeBuffer.WriteUint16("dbNumber", 16, (dbNumber))
		if _dbNumberErr != nil {
			return errors.Wrap(_dbNumberErr, "Error serializing 'dbNumber' field")
		}

		// Simple Field (area)
		if pushErr := writeBuffer.PushContext("area"); pushErr != nil {
			return pushErr
		}
		_areaErr := m.Area.Serialize(writeBuffer)
		if popErr := writeBuffer.PopContext("area"); popErr != nil {
			return popErr
		}
		if _areaErr != nil {
			return errors.Wrap(_areaErr, "Error serializing 'area' field")
		}

		// Reserved Field (reserved)
		{
			_err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00))
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (byteAddress)
		byteAddress := uint16(m.ByteAddress)
		_byteAddressErr := writeBuffer.WriteUint16("byteAddress", 16, (byteAddress))
		if _byteAddressErr != nil {
			return errors.Wrap(_byteAddressErr, "Error serializing 'byteAddress' field")
		}

		// Simple Field (bitAddress)
		bitAddress := uint8(m.BitAddress)
		_bitAddressErr := writeBuffer.WriteUint8("bitAddress", 3, (bitAddress))
		if _bitAddressErr != nil {
			return errors.Wrap(_bitAddressErr, "Error serializing 'bitAddress' field")
		}

		if popErr := writeBuffer.PopContext("S7AddressAny"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *S7AddressAny) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
