/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

type EventType uint8

type IEventType interface {
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	EventType_MODE EventType = 0x01
	EventType_SYS  EventType = 0x02
	EventType_USR  EventType = 0x04
	EventType_ALM  EventType = 0x80
)

var EventTypeValues []EventType

func init() {
	_ = errors.New
	EventTypeValues = []EventType{
		EventType_MODE,
		EventType_SYS,
		EventType_USR,
		EventType_ALM,
	}
}

func EventTypeByValue(value uint8) EventType {
	switch value {
	case 0x01:
		return EventType_MODE
	case 0x02:
		return EventType_SYS
	case 0x04:
		return EventType_USR
	case 0x80:
		return EventType_ALM
	}
	return 0
}

func EventTypeByName(value string) EventType {
	switch value {
	case "MODE":
		return EventType_MODE
	case "SYS":
		return EventType_SYS
	case "USR":
		return EventType_USR
	case "ALM":
		return EventType_ALM
	}
	return 0
}

func CastEventType(structType interface{}) EventType {
	castFunc := func(typ interface{}) EventType {
		if sEventType, ok := typ.(EventType); ok {
			return sEventType
		}
		return 0
	}
	return castFunc(structType)
}

func (m EventType) LengthInBits() uint16 {
	return 8
}

func (m EventType) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func EventTypeParse(readBuffer utils.ReadBuffer) (EventType, error) {
	val, err := readBuffer.ReadUint8("EventType", 8)
	if err != nil {
		return 0, nil
	}
	return EventTypeByValue(val), nil
}

func (e EventType) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint8("EventType", 8, uint8(e), utils.WithAdditionalStringRepresentation(e.name()))
}

func (e EventType) name() string {
	switch e {
	case EventType_MODE:
		return "MODE"
	case EventType_SYS:
		return "SYS"
	case EventType_USR:
		return "USR"
	case EventType_ALM:
		return "ALM"
	}
	return ""
}

func (e EventType) String() string {
	return e.name()
}
