/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type COTPPacketTpduError struct {
	DestinationReference uint16
	RejectCause          uint8
	Parent               *COTPPacket
}

// The corresponding interface
type ICOTPPacketTpduError interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *COTPPacketTpduError) TpduCode() uint8 {
	return 0x70
}

func (m *COTPPacketTpduError) InitializeParent(parent *COTPPacket, parameters []*COTPParameter, payload *S7Message) {
	m.Parent.Parameters = parameters
	m.Parent.Payload = payload
}

func NewCOTPPacketTpduError(destinationReference uint16, rejectCause uint8, parameters []*COTPParameter, payload *S7Message) *COTPPacket {
	child := &COTPPacketTpduError{
		DestinationReference: destinationReference,
		RejectCause:          rejectCause,
		Parent:               NewCOTPPacket(parameters, payload),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastCOTPPacketTpduError(structType interface{}) *COTPPacketTpduError {
	castFunc := func(typ interface{}) *COTPPacketTpduError {
		if casted, ok := typ.(COTPPacketTpduError); ok {
			return &casted
		}
		if casted, ok := typ.(*COTPPacketTpduError); ok {
			return casted
		}
		if casted, ok := typ.(COTPPacket); ok {
			return CastCOTPPacketTpduError(casted.Child)
		}
		if casted, ok := typ.(*COTPPacket); ok {
			return CastCOTPPacketTpduError(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *COTPPacketTpduError) GetTypeName() string {
	return "COTPPacketTpduError"
}

func (m *COTPPacketTpduError) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *COTPPacketTpduError) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Simple field (destinationReference)
	lengthInBits += 16

	// Simple field (rejectCause)
	lengthInBits += 8

	return lengthInBits
}

func (m *COTPPacketTpduError) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func COTPPacketTpduErrorParse(readBuffer utils.ReadBuffer) (*COTPPacket, error) {
	if pullErr := readBuffer.PullContext("COTPPacketTpduError"); pullErr != nil {
		return nil, pullErr
	}

	// Simple Field (destinationReference)
	destinationReference, _destinationReferenceErr := readBuffer.ReadUint16("destinationReference", 16)
	if _destinationReferenceErr != nil {
		return nil, errors.Wrap(_destinationReferenceErr, "Error parsing 'destinationReference' field")
	}

	// Simple Field (rejectCause)
	rejectCause, _rejectCauseErr := readBuffer.ReadUint8("rejectCause", 8)
	if _rejectCauseErr != nil {
		return nil, errors.Wrap(_rejectCauseErr, "Error parsing 'rejectCause' field")
	}

	if closeErr := readBuffer.CloseContext("COTPPacketTpduError"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &COTPPacketTpduError{
		DestinationReference: destinationReference,
		RejectCause:          rejectCause,
		Parent:               &COTPPacket{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *COTPPacketTpduError) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("COTPPacketTpduError"); pushErr != nil {
			return pushErr
		}

		// Simple Field (destinationReference)
		destinationReference := uint16(m.DestinationReference)
		_destinationReferenceErr := writeBuffer.WriteUint16("destinationReference", 16, (destinationReference))
		if _destinationReferenceErr != nil {
			return errors.Wrap(_destinationReferenceErr, "Error serializing 'destinationReference' field")
		}

		// Simple Field (rejectCause)
		rejectCause := uint8(m.RejectCause)
		_rejectCauseErr := writeBuffer.WriteUint8("rejectCause", 8, (rejectCause))
		if _rejectCauseErr != nil {
			return errors.Wrap(_rejectCauseErr, "Error serializing 'rejectCause' field")
		}

		if popErr := writeBuffer.PopContext("COTPPacketTpduError"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *COTPPacketTpduError) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
