/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type ModbusPDUError struct {
	ExceptionCode ModbusErrorCode
	Parent        *ModbusPDU
}

// The corresponding interface
type IModbusPDUError interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *ModbusPDUError) ErrorFlag() bool {
	return true
}

func (m *ModbusPDUError) FunctionFlag() uint8 {
	return 0
}

func (m *ModbusPDUError) Response() bool {
	return false
}

func (m *ModbusPDUError) InitializeParent(parent *ModbusPDU) {
}

func NewModbusPDUError(exceptionCode ModbusErrorCode) *ModbusPDU {
	child := &ModbusPDUError{
		ExceptionCode: exceptionCode,
		Parent:        NewModbusPDU(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastModbusPDUError(structType interface{}) *ModbusPDUError {
	castFunc := func(typ interface{}) *ModbusPDUError {
		if casted, ok := typ.(ModbusPDUError); ok {
			return &casted
		}
		if casted, ok := typ.(*ModbusPDUError); ok {
			return casted
		}
		if casted, ok := typ.(ModbusPDU); ok {
			return CastModbusPDUError(casted.Child)
		}
		if casted, ok := typ.(*ModbusPDU); ok {
			return CastModbusPDUError(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *ModbusPDUError) GetTypeName() string {
	return "ModbusPDUError"
}

func (m *ModbusPDUError) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *ModbusPDUError) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Enum Field (exceptionCode)
	lengthInBits += 8

	return lengthInBits
}

func (m *ModbusPDUError) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func ModbusPDUErrorParse(readBuffer utils.ReadBuffer) (*ModbusPDU, error) {
	if pullErr := readBuffer.PullContext("ModbusPDUError"); pullErr != nil {
		return nil, pullErr
	}

	if pullErr := readBuffer.PullContext("exceptionCode"); pullErr != nil {
		return nil, pullErr
	}
	// Enum field (exceptionCode)
	exceptionCode, _exceptionCodeErr := ModbusErrorCodeParse(readBuffer)
	if _exceptionCodeErr != nil {
		return nil, errors.Wrap(_exceptionCodeErr, "Error parsing 'exceptionCode' field")
	}
	if closeErr := readBuffer.CloseContext("exceptionCode"); closeErr != nil {
		return nil, closeErr
	}

	if closeErr := readBuffer.CloseContext("ModbusPDUError"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &ModbusPDUError{
		ExceptionCode: exceptionCode,
		Parent:        &ModbusPDU{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *ModbusPDUError) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ModbusPDUError"); pushErr != nil {
			return pushErr
		}

		if pushErr := writeBuffer.PushContext("exceptionCode"); pushErr != nil {
			return pushErr
		}
		// Enum field (exceptionCode)
		exceptionCode := CastModbusErrorCode(m.ExceptionCode)
		_exceptionCodeErr := exceptionCode.Serialize(writeBuffer)
		if _exceptionCodeErr != nil {
			return errors.Wrap(_exceptionCodeErr, "Error serializing 'exceptionCode' field")
		}
		if popErr := writeBuffer.PopContext("exceptionCode"); popErr != nil {
			return popErr
		}

		if popErr := writeBuffer.PopContext("ModbusPDUError"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *ModbusPDUError) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
