/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

type Status uint8

type IStatus interface {
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	Status_NO_ERROR                        Status = 0x00
	Status_PROTOCOL_TYPE_NOT_SUPPORTED     Status = 0x01
	Status_UNSUPPORTED_PROTOCOL_VERSION    Status = 0x02
	Status_OUT_OF_ORDER_SEQUENCE_NUMBER    Status = 0x04
	Status_INVALID_CONNECTION_ID           Status = 0x21
	Status_CONNECTION_TYPE_NOT_SUPPORTED   Status = 0x22
	Status_CONNECTION_OPTION_NOT_SUPPORTED Status = 0x23
	Status_NO_MORE_CONNECTIONS             Status = 0x24
	Status_NO_MORE_UNIQUE_CONNECTIONS      Status = 0x25
	Status_DATA_CONNECTION                 Status = 0x26
	Status_KNX_CONNECTION                  Status = 0x27
	Status_TUNNELLING_LAYER_NOT_SUPPORTED  Status = 0x29
)

var StatusValues []Status

func init() {
	_ = errors.New
	StatusValues = []Status{
		Status_NO_ERROR,
		Status_PROTOCOL_TYPE_NOT_SUPPORTED,
		Status_UNSUPPORTED_PROTOCOL_VERSION,
		Status_OUT_OF_ORDER_SEQUENCE_NUMBER,
		Status_INVALID_CONNECTION_ID,
		Status_CONNECTION_TYPE_NOT_SUPPORTED,
		Status_CONNECTION_OPTION_NOT_SUPPORTED,
		Status_NO_MORE_CONNECTIONS,
		Status_NO_MORE_UNIQUE_CONNECTIONS,
		Status_DATA_CONNECTION,
		Status_KNX_CONNECTION,
		Status_TUNNELLING_LAYER_NOT_SUPPORTED,
	}
}

func StatusByValue(value uint8) Status {
	switch value {
	case 0x00:
		return Status_NO_ERROR
	case 0x01:
		return Status_PROTOCOL_TYPE_NOT_SUPPORTED
	case 0x02:
		return Status_UNSUPPORTED_PROTOCOL_VERSION
	case 0x04:
		return Status_OUT_OF_ORDER_SEQUENCE_NUMBER
	case 0x21:
		return Status_INVALID_CONNECTION_ID
	case 0x22:
		return Status_CONNECTION_TYPE_NOT_SUPPORTED
	case 0x23:
		return Status_CONNECTION_OPTION_NOT_SUPPORTED
	case 0x24:
		return Status_NO_MORE_CONNECTIONS
	case 0x25:
		return Status_NO_MORE_UNIQUE_CONNECTIONS
	case 0x26:
		return Status_DATA_CONNECTION
	case 0x27:
		return Status_KNX_CONNECTION
	case 0x29:
		return Status_TUNNELLING_LAYER_NOT_SUPPORTED
	}
	return 0
}

func StatusByName(value string) Status {
	switch value {
	case "NO_ERROR":
		return Status_NO_ERROR
	case "PROTOCOL_TYPE_NOT_SUPPORTED":
		return Status_PROTOCOL_TYPE_NOT_SUPPORTED
	case "UNSUPPORTED_PROTOCOL_VERSION":
		return Status_UNSUPPORTED_PROTOCOL_VERSION
	case "OUT_OF_ORDER_SEQUENCE_NUMBER":
		return Status_OUT_OF_ORDER_SEQUENCE_NUMBER
	case "INVALID_CONNECTION_ID":
		return Status_INVALID_CONNECTION_ID
	case "CONNECTION_TYPE_NOT_SUPPORTED":
		return Status_CONNECTION_TYPE_NOT_SUPPORTED
	case "CONNECTION_OPTION_NOT_SUPPORTED":
		return Status_CONNECTION_OPTION_NOT_SUPPORTED
	case "NO_MORE_CONNECTIONS":
		return Status_NO_MORE_CONNECTIONS
	case "NO_MORE_UNIQUE_CONNECTIONS":
		return Status_NO_MORE_UNIQUE_CONNECTIONS
	case "DATA_CONNECTION":
		return Status_DATA_CONNECTION
	case "KNX_CONNECTION":
		return Status_KNX_CONNECTION
	case "TUNNELLING_LAYER_NOT_SUPPORTED":
		return Status_TUNNELLING_LAYER_NOT_SUPPORTED
	}
	return 0
}

func CastStatus(structType interface{}) Status {
	castFunc := func(typ interface{}) Status {
		if sStatus, ok := typ.(Status); ok {
			return sStatus
		}
		return 0
	}
	return castFunc(structType)
}

func (m Status) LengthInBits() uint16 {
	return 8
}

func (m Status) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func StatusParse(readBuffer utils.ReadBuffer) (Status, error) {
	val, err := readBuffer.ReadUint8("Status", 8)
	if err != nil {
		return 0, nil
	}
	return StatusByValue(val), nil
}

func (e Status) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint8("Status", 8, uint8(e), utils.WithAdditionalStringRepresentation(e.name()))
}

func (e Status) name() string {
	switch e {
	case Status_NO_ERROR:
		return "NO_ERROR"
	case Status_PROTOCOL_TYPE_NOT_SUPPORTED:
		return "PROTOCOL_TYPE_NOT_SUPPORTED"
	case Status_UNSUPPORTED_PROTOCOL_VERSION:
		return "UNSUPPORTED_PROTOCOL_VERSION"
	case Status_OUT_OF_ORDER_SEQUENCE_NUMBER:
		return "OUT_OF_ORDER_SEQUENCE_NUMBER"
	case Status_INVALID_CONNECTION_ID:
		return "INVALID_CONNECTION_ID"
	case Status_CONNECTION_TYPE_NOT_SUPPORTED:
		return "CONNECTION_TYPE_NOT_SUPPORTED"
	case Status_CONNECTION_OPTION_NOT_SUPPORTED:
		return "CONNECTION_OPTION_NOT_SUPPORTED"
	case Status_NO_MORE_CONNECTIONS:
		return "NO_MORE_CONNECTIONS"
	case Status_NO_MORE_UNIQUE_CONNECTIONS:
		return "NO_MORE_UNIQUE_CONNECTIONS"
	case Status_DATA_CONNECTION:
		return "DATA_CONNECTION"
	case Status_KNX_CONNECTION:
		return "KNX_CONNECTION"
	case Status_TUNNELLING_LAYER_NOT_SUPPORTED:
		return "TUNNELLING_LAYER_NOT_SUPPORTED"
	}
	return ""
}

func (e Status) String() string {
	return e.name()
}
