/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type LDataFrame struct {
	FrameType            bool
	NotRepeated          bool
	Priority             CEMIPriority
	AcknowledgeRequested bool
	ErrorFlag            bool
	Child                ILDataFrameChild
}

// The corresponding interface
type ILDataFrame interface {
	NotAckFrame() bool
	Polling() bool
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

type ILDataFrameParent interface {
	SerializeParent(writeBuffer utils.WriteBuffer, child ILDataFrame, serializeChildFunction func() error) error
	GetTypeName() string
}

type ILDataFrameChild interface {
	Serialize(writeBuffer utils.WriteBuffer) error
	InitializeParent(parent *LDataFrame, frameType bool, notRepeated bool, priority CEMIPriority, acknowledgeRequested bool, errorFlag bool)
	GetTypeName() string
	ILDataFrame
}

func NewLDataFrame(frameType bool, notRepeated bool, priority CEMIPriority, acknowledgeRequested bool, errorFlag bool) *LDataFrame {
	return &LDataFrame{FrameType: frameType, NotRepeated: notRepeated, Priority: priority, AcknowledgeRequested: acknowledgeRequested, ErrorFlag: errorFlag}
}

func CastLDataFrame(structType interface{}) *LDataFrame {
	castFunc := func(typ interface{}) *LDataFrame {
		if casted, ok := typ.(LDataFrame); ok {
			return &casted
		}
		if casted, ok := typ.(*LDataFrame); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *LDataFrame) GetTypeName() string {
	return "LDataFrame"
}

func (m *LDataFrame) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *LDataFrame) LengthInBitsConditional(lastItem bool) uint16 {
	return m.Child.LengthInBits()
}

func (m *LDataFrame) ParentLengthInBits() uint16 {
	lengthInBits := uint16(0)

	// Simple field (frameType)
	lengthInBits += 1
	// Discriminator Field (polling)
	lengthInBits += 1

	// Simple field (notRepeated)
	lengthInBits += 1
	// Discriminator Field (notAckFrame)
	lengthInBits += 1

	// Enum Field (priority)
	lengthInBits += 2

	// Simple field (acknowledgeRequested)
	lengthInBits += 1

	// Simple field (errorFlag)
	lengthInBits += 1

	return lengthInBits
}

func (m *LDataFrame) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func LDataFrameParse(readBuffer utils.ReadBuffer) (*LDataFrame, error) {
	if pullErr := readBuffer.PullContext("LDataFrame"); pullErr != nil {
		return nil, pullErr
	}

	// Simple Field (frameType)
	frameType, _frameTypeErr := readBuffer.ReadBit("frameType")
	if _frameTypeErr != nil {
		return nil, errors.Wrap(_frameTypeErr, "Error parsing 'frameType' field")
	}

	// Discriminator Field (polling) (Used as input to a switch field)
	polling, _pollingErr := readBuffer.ReadBit("polling")
	if _pollingErr != nil {
		return nil, errors.Wrap(_pollingErr, "Error parsing 'polling' field")
	}

	// Simple Field (notRepeated)
	notRepeated, _notRepeatedErr := readBuffer.ReadBit("notRepeated")
	if _notRepeatedErr != nil {
		return nil, errors.Wrap(_notRepeatedErr, "Error parsing 'notRepeated' field")
	}

	// Discriminator Field (notAckFrame) (Used as input to a switch field)
	notAckFrame, _notAckFrameErr := readBuffer.ReadBit("notAckFrame")
	if _notAckFrameErr != nil {
		return nil, errors.Wrap(_notAckFrameErr, "Error parsing 'notAckFrame' field")
	}

	if pullErr := readBuffer.PullContext("priority"); pullErr != nil {
		return nil, pullErr
	}
	// Enum field (priority)
	priority, _priorityErr := CEMIPriorityParse(readBuffer)
	if _priorityErr != nil {
		return nil, errors.Wrap(_priorityErr, "Error parsing 'priority' field")
	}
	if closeErr := readBuffer.CloseContext("priority"); closeErr != nil {
		return nil, closeErr
	}

	// Simple Field (acknowledgeRequested)
	acknowledgeRequested, _acknowledgeRequestedErr := readBuffer.ReadBit("acknowledgeRequested")
	if _acknowledgeRequestedErr != nil {
		return nil, errors.Wrap(_acknowledgeRequestedErr, "Error parsing 'acknowledgeRequested' field")
	}

	// Simple Field (errorFlag)
	errorFlag, _errorFlagErr := readBuffer.ReadBit("errorFlag")
	if _errorFlagErr != nil {
		return nil, errors.Wrap(_errorFlagErr, "Error parsing 'errorFlag' field")
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _parent *LDataFrame
	var typeSwitchError error
	switch {
	case notAckFrame == true && polling == false: // LDataExtended
		_parent, typeSwitchError = LDataExtendedParse(readBuffer)
	case notAckFrame == true && polling == true: // LPollData
		_parent, typeSwitchError = LPollDataParse(readBuffer)
	case notAckFrame == false: // LDataFrameACK
		_parent, typeSwitchError = LDataFrameACKParse(readBuffer)
	default:
		// TODO: return actual type
		typeSwitchError = errors.New("Unmapped type")
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch.")
	}

	if closeErr := readBuffer.CloseContext("LDataFrame"); closeErr != nil {
		return nil, closeErr
	}

	// Finish initializing
	_parent.Child.InitializeParent(_parent, frameType, notRepeated, priority, acknowledgeRequested, errorFlag)
	return _parent, nil
}

func (m *LDataFrame) Serialize(writeBuffer utils.WriteBuffer) error {
	return m.Child.Serialize(writeBuffer)
}

func (m *LDataFrame) SerializeParent(writeBuffer utils.WriteBuffer, child ILDataFrame, serializeChildFunction func() error) error {
	if pushErr := writeBuffer.PushContext("LDataFrame"); pushErr != nil {
		return pushErr
	}

	// Simple Field (frameType)
	frameType := bool(m.FrameType)
	_frameTypeErr := writeBuffer.WriteBit("frameType", (frameType))
	if _frameTypeErr != nil {
		return errors.Wrap(_frameTypeErr, "Error serializing 'frameType' field")
	}

	// Discriminator Field (polling) (Used as input to a switch field)
	polling := bool(child.Polling())
	_pollingErr := writeBuffer.WriteBit("polling", (polling))

	if _pollingErr != nil {
		return errors.Wrap(_pollingErr, "Error serializing 'polling' field")
	}

	// Simple Field (notRepeated)
	notRepeated := bool(m.NotRepeated)
	_notRepeatedErr := writeBuffer.WriteBit("notRepeated", (notRepeated))
	if _notRepeatedErr != nil {
		return errors.Wrap(_notRepeatedErr, "Error serializing 'notRepeated' field")
	}

	// Discriminator Field (notAckFrame) (Used as input to a switch field)
	notAckFrame := bool(child.NotAckFrame())
	_notAckFrameErr := writeBuffer.WriteBit("notAckFrame", (notAckFrame))

	if _notAckFrameErr != nil {
		return errors.Wrap(_notAckFrameErr, "Error serializing 'notAckFrame' field")
	}

	if pushErr := writeBuffer.PushContext("priority"); pushErr != nil {
		return pushErr
	}
	// Enum field (priority)
	priority := CastCEMIPriority(m.Priority)
	_priorityErr := priority.Serialize(writeBuffer)
	if _priorityErr != nil {
		return errors.Wrap(_priorityErr, "Error serializing 'priority' field")
	}
	if popErr := writeBuffer.PopContext("priority"); popErr != nil {
		return popErr
	}

	// Simple Field (acknowledgeRequested)
	acknowledgeRequested := bool(m.AcknowledgeRequested)
	_acknowledgeRequestedErr := writeBuffer.WriteBit("acknowledgeRequested", (acknowledgeRequested))
	if _acknowledgeRequestedErr != nil {
		return errors.Wrap(_acknowledgeRequestedErr, "Error serializing 'acknowledgeRequested' field")
	}

	// Simple Field (errorFlag)
	errorFlag := bool(m.ErrorFlag)
	_errorFlagErr := writeBuffer.WriteBit("errorFlag", (errorFlag))
	if _errorFlagErr != nil {
		return errors.Wrap(_errorFlagErr, "Error serializing 'errorFlag' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	_typeSwitchErr := serializeChildFunction()
	if _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("LDataFrame"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *LDataFrame) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
