/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type GroupObjectDescriptorRealisationType6 struct {
}

// The corresponding interface
type IGroupObjectDescriptorRealisationType6 interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

func NewGroupObjectDescriptorRealisationType6() *GroupObjectDescriptorRealisationType6 {
	return &GroupObjectDescriptorRealisationType6{}
}

func CastGroupObjectDescriptorRealisationType6(structType interface{}) *GroupObjectDescriptorRealisationType6 {
	castFunc := func(typ interface{}) *GroupObjectDescriptorRealisationType6 {
		if casted, ok := typ.(GroupObjectDescriptorRealisationType6); ok {
			return &casted
		}
		if casted, ok := typ.(*GroupObjectDescriptorRealisationType6); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *GroupObjectDescriptorRealisationType6) GetTypeName() string {
	return "GroupObjectDescriptorRealisationType6"
}

func (m *GroupObjectDescriptorRealisationType6) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *GroupObjectDescriptorRealisationType6) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *GroupObjectDescriptorRealisationType6) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func GroupObjectDescriptorRealisationType6Parse(readBuffer utils.ReadBuffer) (*GroupObjectDescriptorRealisationType6, error) {
	if pullErr := readBuffer.PullContext("GroupObjectDescriptorRealisationType6"); pullErr != nil {
		return nil, pullErr
	}

	if closeErr := readBuffer.CloseContext("GroupObjectDescriptorRealisationType6"); closeErr != nil {
		return nil, closeErr
	}

	// Create the instance
	return NewGroupObjectDescriptorRealisationType6(), nil
}

func (m *GroupObjectDescriptorRealisationType6) Serialize(writeBuffer utils.WriteBuffer) error {
	if pushErr := writeBuffer.PushContext("GroupObjectDescriptorRealisationType6"); pushErr != nil {
		return pushErr
	}

	if popErr := writeBuffer.PopContext("GroupObjectDescriptorRealisationType6"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *GroupObjectDescriptorRealisationType6) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
