/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type Apdu struct {
	Numbered bool
	Counter  uint8
	Child    IApduChild
}

// The corresponding interface
type IApdu interface {
	Control() uint8
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

type IApduParent interface {
	SerializeParent(writeBuffer utils.WriteBuffer, child IApdu, serializeChildFunction func() error) error
	GetTypeName() string
}

type IApduChild interface {
	Serialize(writeBuffer utils.WriteBuffer) error
	InitializeParent(parent *Apdu, numbered bool, counter uint8)
	GetTypeName() string
	IApdu
}

func NewApdu(numbered bool, counter uint8) *Apdu {
	return &Apdu{Numbered: numbered, Counter: counter}
}

func CastApdu(structType interface{}) *Apdu {
	castFunc := func(typ interface{}) *Apdu {
		if casted, ok := typ.(Apdu); ok {
			return &casted
		}
		if casted, ok := typ.(*Apdu); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *Apdu) GetTypeName() string {
	return "Apdu"
}

func (m *Apdu) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *Apdu) LengthInBitsConditional(lastItem bool) uint16 {
	return m.Child.LengthInBits()
}

func (m *Apdu) ParentLengthInBits() uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (control)
	lengthInBits += 1

	// Simple field (numbered)
	lengthInBits += 1

	// Simple field (counter)
	lengthInBits += 4

	return lengthInBits
}

func (m *Apdu) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func ApduParse(readBuffer utils.ReadBuffer, dataLength uint8) (*Apdu, error) {
	if pullErr := readBuffer.PullContext("Apdu"); pullErr != nil {
		return nil, pullErr
	}

	// Discriminator Field (control) (Used as input to a switch field)
	control, _controlErr := readBuffer.ReadUint8("control", 1)
	if _controlErr != nil {
		return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
	}

	// Simple Field (numbered)
	numbered, _numberedErr := readBuffer.ReadBit("numbered")
	if _numberedErr != nil {
		return nil, errors.Wrap(_numberedErr, "Error parsing 'numbered' field")
	}

	// Simple Field (counter)
	counter, _counterErr := readBuffer.ReadUint8("counter", 4)
	if _counterErr != nil {
		return nil, errors.Wrap(_counterErr, "Error parsing 'counter' field")
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _parent *Apdu
	var typeSwitchError error
	switch {
	case control == 1: // ApduControlContainer
		_parent, typeSwitchError = ApduControlContainerParse(readBuffer)
	case control == 0: // ApduDataContainer
		_parent, typeSwitchError = ApduDataContainerParse(readBuffer, dataLength)
	default:
		// TODO: return actual type
		typeSwitchError = errors.New("Unmapped type")
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch.")
	}

	if closeErr := readBuffer.CloseContext("Apdu"); closeErr != nil {
		return nil, closeErr
	}

	// Finish initializing
	_parent.Child.InitializeParent(_parent, numbered, counter)
	return _parent, nil
}

func (m *Apdu) Serialize(writeBuffer utils.WriteBuffer) error {
	return m.Child.Serialize(writeBuffer)
}

func (m *Apdu) SerializeParent(writeBuffer utils.WriteBuffer, child IApdu, serializeChildFunction func() error) error {
	if pushErr := writeBuffer.PushContext("Apdu"); pushErr != nil {
		return pushErr
	}

	// Discriminator Field (control) (Used as input to a switch field)
	control := uint8(child.Control())
	_controlErr := writeBuffer.WriteUint8("control", 1, (control))

	if _controlErr != nil {
		return errors.Wrap(_controlErr, "Error serializing 'control' field")
	}

	// Simple Field (numbered)
	numbered := bool(m.Numbered)
	_numberedErr := writeBuffer.WriteBit("numbered", (numbered))
	if _numberedErr != nil {
		return errors.Wrap(_numberedErr, "Error serializing 'numbered' field")
	}

	// Simple Field (counter)
	counter := uint8(m.Counter)
	_counterErr := writeBuffer.WriteUint8("counter", 4, (counter))
	if _counterErr != nil {
		return errors.Wrap(_counterErr, "Error serializing 'counter' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	_typeSwitchErr := serializeChildFunction()
	if _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("Apdu"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *Apdu) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
