/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type SysexCommandCapabilityQuery struct {
	Parent *SysexCommand
}

// The corresponding interface
type ISysexCommandCapabilityQuery interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *SysexCommandCapabilityQuery) CommandType() uint8 {
	return 0x6B
}

func (m *SysexCommandCapabilityQuery) Response() bool {
	return false
}

func (m *SysexCommandCapabilityQuery) InitializeParent(parent *SysexCommand) {
}

func NewSysexCommandCapabilityQuery() *SysexCommand {
	child := &SysexCommandCapabilityQuery{
		Parent: NewSysexCommand(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastSysexCommandCapabilityQuery(structType interface{}) *SysexCommandCapabilityQuery {
	castFunc := func(typ interface{}) *SysexCommandCapabilityQuery {
		if casted, ok := typ.(SysexCommandCapabilityQuery); ok {
			return &casted
		}
		if casted, ok := typ.(*SysexCommandCapabilityQuery); ok {
			return casted
		}
		if casted, ok := typ.(SysexCommand); ok {
			return CastSysexCommandCapabilityQuery(casted.Child)
		}
		if casted, ok := typ.(*SysexCommand); ok {
			return CastSysexCommandCapabilityQuery(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *SysexCommandCapabilityQuery) GetTypeName() string {
	return "SysexCommandCapabilityQuery"
}

func (m *SysexCommandCapabilityQuery) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *SysexCommandCapabilityQuery) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	return lengthInBits
}

func (m *SysexCommandCapabilityQuery) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func SysexCommandCapabilityQueryParse(readBuffer utils.ReadBuffer) (*SysexCommand, error) {
	if pullErr := readBuffer.PullContext("SysexCommandCapabilityQuery"); pullErr != nil {
		return nil, pullErr
	}

	if closeErr := readBuffer.CloseContext("SysexCommandCapabilityQuery"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &SysexCommandCapabilityQuery{
		Parent: &SysexCommand{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *SysexCommandCapabilityQuery) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SysexCommandCapabilityQuery"); pushErr != nil {
			return pushErr
		}

		if popErr := writeBuffer.PopContext("SysexCommandCapabilityQuery"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *SysexCommandCapabilityQuery) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
