/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"fmt"
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const MultipleServiceRequest_REQUESTPATHSIZE int8 = 0x02
const MultipleServiceRequest_REQUESTPATH uint32 = 0x01240220

// The data-structure of this message
type MultipleServiceRequest struct {
	Data   *Services
	Parent *CipService
}

// The corresponding interface
type IMultipleServiceRequest interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *MultipleServiceRequest) Service() uint8 {
	return 0x0A
}

func (m *MultipleServiceRequest) InitializeParent(parent *CipService) {
}

func NewMultipleServiceRequest(data *Services) *CipService {
	child := &MultipleServiceRequest{
		Data:   data,
		Parent: NewCipService(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastMultipleServiceRequest(structType interface{}) *MultipleServiceRequest {
	castFunc := func(typ interface{}) *MultipleServiceRequest {
		if casted, ok := typ.(MultipleServiceRequest); ok {
			return &casted
		}
		if casted, ok := typ.(*MultipleServiceRequest); ok {
			return casted
		}
		if casted, ok := typ.(CipService); ok {
			return CastMultipleServiceRequest(casted.Child)
		}
		if casted, ok := typ.(*CipService); ok {
			return CastMultipleServiceRequest(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *MultipleServiceRequest) GetTypeName() string {
	return "MultipleServiceRequest"
}

func (m *MultipleServiceRequest) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *MultipleServiceRequest) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Const Field (RequestPathSize)
	lengthInBits += 8

	// Const Field (RequestPath)
	lengthInBits += 32

	// Simple field (data)
	lengthInBits += m.Data.LengthInBits()

	return lengthInBits
}

func (m *MultipleServiceRequest) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func MultipleServiceRequestParse(readBuffer utils.ReadBuffer, serviceLen uint16) (*CipService, error) {
	if pullErr := readBuffer.PullContext("MultipleServiceRequest"); pullErr != nil {
		return nil, pullErr
	}

	// Const Field (RequestPathSize)
	RequestPathSize, _RequestPathSizeErr := readBuffer.ReadInt8("RequestPathSize", 8)
	if _RequestPathSizeErr != nil {
		return nil, errors.Wrap(_RequestPathSizeErr, "Error parsing 'RequestPathSize' field")
	}
	if RequestPathSize != MultipleServiceRequest_REQUESTPATHSIZE {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", MultipleServiceRequest_REQUESTPATHSIZE) + " but got " + fmt.Sprintf("%d", RequestPathSize))
	}

	// Const Field (RequestPath)
	RequestPath, _RequestPathErr := readBuffer.ReadUint32("RequestPath", 32)
	if _RequestPathErr != nil {
		return nil, errors.Wrap(_RequestPathErr, "Error parsing 'RequestPath' field")
	}
	if RequestPath != MultipleServiceRequest_REQUESTPATH {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", MultipleServiceRequest_REQUESTPATH) + " but got " + fmt.Sprintf("%d", RequestPath))
	}

	// Simple Field (data)
	if pullErr := readBuffer.PullContext("data"); pullErr != nil {
		return nil, pullErr
	}
	data, _dataErr := ServicesParse(readBuffer, uint16(serviceLen)-uint16(uint16(6)))
	if _dataErr != nil {
		return nil, errors.Wrap(_dataErr, "Error parsing 'data' field")
	}
	if closeErr := readBuffer.CloseContext("data"); closeErr != nil {
		return nil, closeErr
	}

	if closeErr := readBuffer.CloseContext("MultipleServiceRequest"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &MultipleServiceRequest{
		Data:   data,
		Parent: &CipService{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *MultipleServiceRequest) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MultipleServiceRequest"); pushErr != nil {
			return pushErr
		}

		// Const Field (RequestPathSize)
		_RequestPathSizeErr := writeBuffer.WriteInt8("RequestPathSize", 8, 0x02)
		if _RequestPathSizeErr != nil {
			return errors.Wrap(_RequestPathSizeErr, "Error serializing 'RequestPathSize' field")
		}

		// Const Field (RequestPath)
		_RequestPathErr := writeBuffer.WriteUint32("RequestPath", 32, 0x01240220)
		if _RequestPathErr != nil {
			return errors.Wrap(_RequestPathErr, "Error serializing 'RequestPath' field")
		}

		// Simple Field (data)
		if pushErr := writeBuffer.PushContext("data"); pushErr != nil {
			return pushErr
		}
		_dataErr := m.Data.Serialize(writeBuffer)
		if popErr := writeBuffer.PopContext("data"); popErr != nil {
			return popErr
		}
		if _dataErr != nil {
			return errors.Wrap(_dataErr, "Error serializing 'data' field")
		}

		if popErr := writeBuffer.PopContext("MultipleServiceRequest"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *MultipleServiceRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
