/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog/log"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type CipReadResponse struct {
	Status    uint8
	ExtStatus uint8
	DataType  CIPDataTypeCode
	Data      []int8
	Parent    *CipService
}

// The corresponding interface
type ICipReadResponse interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *CipReadResponse) Service() uint8 {
	return 0xCC
}

func (m *CipReadResponse) InitializeParent(parent *CipService) {
}

func NewCipReadResponse(status uint8, extStatus uint8, dataType CIPDataTypeCode, data []int8) *CipService {
	child := &CipReadResponse{
		Status:    status,
		ExtStatus: extStatus,
		DataType:  dataType,
		Data:      data,
		Parent:    NewCipService(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastCipReadResponse(structType interface{}) *CipReadResponse {
	castFunc := func(typ interface{}) *CipReadResponse {
		if casted, ok := typ.(CipReadResponse); ok {
			return &casted
		}
		if casted, ok := typ.(*CipReadResponse); ok {
			return casted
		}
		if casted, ok := typ.(CipService); ok {
			return CastCipReadResponse(casted.Child)
		}
		if casted, ok := typ.(*CipService); ok {
			return CastCipReadResponse(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *CipReadResponse) GetTypeName() string {
	return "CipReadResponse"
}

func (m *CipReadResponse) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *CipReadResponse) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Reserved Field (reserved)
	lengthInBits += 8

	// Simple field (status)
	lengthInBits += 8

	// Simple field (extStatus)
	lengthInBits += 8

	// Enum Field (dataType)
	lengthInBits += 16

	// Array field
	if len(m.Data) > 0 {
		lengthInBits += 8 * uint16(len(m.Data))
	}

	return lengthInBits
}

func (m *CipReadResponse) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func CipReadResponseParse(readBuffer utils.ReadBuffer, serviceLen uint16) (*CipService, error) {
	if pullErr := readBuffer.PullContext("CipReadResponse"); pullErr != nil {
		return nil, pullErr
	}

	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]interface{}{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response.")
		}
	}

	// Simple Field (status)
	status, _statusErr := readBuffer.ReadUint8("status", 8)
	if _statusErr != nil {
		return nil, errors.Wrap(_statusErr, "Error parsing 'status' field")
	}

	// Simple Field (extStatus)
	extStatus, _extStatusErr := readBuffer.ReadUint8("extStatus", 8)
	if _extStatusErr != nil {
		return nil, errors.Wrap(_extStatusErr, "Error parsing 'extStatus' field")
	}

	if pullErr := readBuffer.PullContext("dataType"); pullErr != nil {
		return nil, pullErr
	}
	// Enum field (dataType)
	dataType, _dataTypeErr := CIPDataTypeCodeParse(readBuffer)
	if _dataTypeErr != nil {
		return nil, errors.Wrap(_dataTypeErr, "Error parsing 'dataType' field")
	}
	if closeErr := readBuffer.CloseContext("dataType"); closeErr != nil {
		return nil, closeErr
	}

	// Array field (data)
	if pullErr := readBuffer.PullContext("data", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, pullErr
	}
	// Count array
	data := make([]int8, uint16(serviceLen)-uint16(uint16(6)))
	for curItem := uint16(0); curItem < uint16(uint16(serviceLen)-uint16(uint16(6))); curItem++ {
		_item, _err := readBuffer.ReadInt8("", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'data' field")
		}
		data[curItem] = _item
	}
	if closeErr := readBuffer.CloseContext("data", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, closeErr
	}

	if closeErr := readBuffer.CloseContext("CipReadResponse"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &CipReadResponse{
		Status:    status,
		ExtStatus: extStatus,
		DataType:  dataType,
		Data:      data,
		Parent:    &CipService{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *CipReadResponse) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CipReadResponse"); pushErr != nil {
			return pushErr
		}

		// Reserved Field (reserved)
		{
			_err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00))
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (status)
		status := uint8(m.Status)
		_statusErr := writeBuffer.WriteUint8("status", 8, (status))
		if _statusErr != nil {
			return errors.Wrap(_statusErr, "Error serializing 'status' field")
		}

		// Simple Field (extStatus)
		extStatus := uint8(m.ExtStatus)
		_extStatusErr := writeBuffer.WriteUint8("extStatus", 8, (extStatus))
		if _extStatusErr != nil {
			return errors.Wrap(_extStatusErr, "Error serializing 'extStatus' field")
		}

		if pushErr := writeBuffer.PushContext("dataType"); pushErr != nil {
			return pushErr
		}
		// Enum field (dataType)
		dataType := CastCIPDataTypeCode(m.DataType)
		_dataTypeErr := dataType.Serialize(writeBuffer)
		if _dataTypeErr != nil {
			return errors.Wrap(_dataTypeErr, "Error serializing 'dataType' field")
		}
		if popErr := writeBuffer.PopContext("dataType"); popErr != nil {
			return popErr
		}

		// Array Field (data)
		if m.Data != nil {
			if pushErr := writeBuffer.PushContext("data", utils.WithRenderAsList(true)); pushErr != nil {
				return pushErr
			}
			for _, _element := range m.Data {
				_elementErr := writeBuffer.WriteInt8("", 8, _element)
				if _elementErr != nil {
					return errors.Wrap(_elementErr, "Error serializing 'data' field")
				}
			}
			if popErr := writeBuffer.PopContext("data", utils.WithRenderAsList(true)); popErr != nil {
				return popErr
			}
		}

		if popErr := writeBuffer.PopContext("CipReadResponse"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *CipReadResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
