/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"fmt"
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const CipExchange_ITEMCOUNT uint16 = 0x02
const CipExchange_NULLPTR uint32 = 0x0
const CipExchange_UNCONNECTEDDATA uint16 = 0x00B2

// The data-structure of this message
type CipExchange struct {
	Service *CipService
}

// The corresponding interface
type ICipExchange interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

func NewCipExchange(service *CipService) *CipExchange {
	return &CipExchange{Service: service}
}

func CastCipExchange(structType interface{}) *CipExchange {
	castFunc := func(typ interface{}) *CipExchange {
		if casted, ok := typ.(CipExchange); ok {
			return &casted
		}
		if casted, ok := typ.(*CipExchange); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *CipExchange) GetTypeName() string {
	return "CipExchange"
}

func (m *CipExchange) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *CipExchange) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	// Const Field (itemCount)
	lengthInBits += 16

	// Const Field (nullPtr)
	lengthInBits += 32

	// Const Field (UnconnectedData)
	lengthInBits += 16

	// Implicit Field (size)
	lengthInBits += 16

	// Simple field (service)
	lengthInBits += m.Service.LengthInBits()

	return lengthInBits
}

func (m *CipExchange) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func CipExchangeParse(readBuffer utils.ReadBuffer, exchangeLen uint16) (*CipExchange, error) {
	if pullErr := readBuffer.PullContext("CipExchange"); pullErr != nil {
		return nil, pullErr
	}

	// Const Field (itemCount)
	itemCount, _itemCountErr := readBuffer.ReadUint16("itemCount", 16)
	if _itemCountErr != nil {
		return nil, errors.Wrap(_itemCountErr, "Error parsing 'itemCount' field")
	}
	if itemCount != CipExchange_ITEMCOUNT {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", CipExchange_ITEMCOUNT) + " but got " + fmt.Sprintf("%d", itemCount))
	}

	// Const Field (nullPtr)
	nullPtr, _nullPtrErr := readBuffer.ReadUint32("nullPtr", 32)
	if _nullPtrErr != nil {
		return nil, errors.Wrap(_nullPtrErr, "Error parsing 'nullPtr' field")
	}
	if nullPtr != CipExchange_NULLPTR {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", CipExchange_NULLPTR) + " but got " + fmt.Sprintf("%d", nullPtr))
	}

	// Const Field (UnconnectedData)
	UnconnectedData, _UnconnectedDataErr := readBuffer.ReadUint16("UnconnectedData", 16)
	if _UnconnectedDataErr != nil {
		return nil, errors.Wrap(_UnconnectedDataErr, "Error parsing 'UnconnectedData' field")
	}
	if UnconnectedData != CipExchange_UNCONNECTEDDATA {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", CipExchange_UNCONNECTEDDATA) + " but got " + fmt.Sprintf("%d", UnconnectedData))
	}

	// Implicit Field (size) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
	size, _sizeErr := readBuffer.ReadUint16("size", 16)
	_ = size
	if _sizeErr != nil {
		return nil, errors.Wrap(_sizeErr, "Error parsing 'size' field")
	}

	// Simple Field (service)
	if pullErr := readBuffer.PullContext("service"); pullErr != nil {
		return nil, pullErr
	}
	service, _serviceErr := CipServiceParse(readBuffer, uint16(exchangeLen)-uint16(uint16(10)))
	if _serviceErr != nil {
		return nil, errors.Wrap(_serviceErr, "Error parsing 'service' field")
	}
	if closeErr := readBuffer.CloseContext("service"); closeErr != nil {
		return nil, closeErr
	}

	if closeErr := readBuffer.CloseContext("CipExchange"); closeErr != nil {
		return nil, closeErr
	}

	// Create the instance
	return NewCipExchange(service), nil
}

func (m *CipExchange) Serialize(writeBuffer utils.WriteBuffer) error {
	if pushErr := writeBuffer.PushContext("CipExchange"); pushErr != nil {
		return pushErr
	}

	// Const Field (itemCount)
	_itemCountErr := writeBuffer.WriteUint16("itemCount", 16, 0x02)
	if _itemCountErr != nil {
		return errors.Wrap(_itemCountErr, "Error serializing 'itemCount' field")
	}

	// Const Field (nullPtr)
	_nullPtrErr := writeBuffer.WriteUint32("nullPtr", 32, 0x0)
	if _nullPtrErr != nil {
		return errors.Wrap(_nullPtrErr, "Error serializing 'nullPtr' field")
	}

	// Const Field (UnconnectedData)
	_UnconnectedDataErr := writeBuffer.WriteUint16("UnconnectedData", 16, 0x00B2)
	if _UnconnectedDataErr != nil {
		return errors.Wrap(_UnconnectedDataErr, "Error serializing 'UnconnectedData' field")
	}

	// Implicit Field (size) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
	size := uint16(uint16(uint16(uint16(m.LengthInBytes()))-uint16(uint16(8))) - uint16(uint16(2)))
	_sizeErr := writeBuffer.WriteUint16("size", 16, (size))
	if _sizeErr != nil {
		return errors.Wrap(_sizeErr, "Error serializing 'size' field")
	}

	// Simple Field (service)
	if pushErr := writeBuffer.PushContext("service"); pushErr != nil {
		return pushErr
	}
	_serviceErr := m.Service.Serialize(writeBuffer)
	if popErr := writeBuffer.PopContext("service"); popErr != nil {
		return popErr
	}
	if _serviceErr != nil {
		return errors.Wrap(_serviceErr, "Error serializing 'service' field")
	}

	if popErr := writeBuffer.PopContext("CipExchange"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *CipExchange) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
