/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type DF1UnprotectedReadRequest struct {
	Address uint16
	Size    uint8
	Parent  *DF1Command
}

// The corresponding interface
type IDF1UnprotectedReadRequest interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *DF1UnprotectedReadRequest) CommandCode() uint8 {
	return 0x01
}

func (m *DF1UnprotectedReadRequest) InitializeParent(parent *DF1Command, status uint8, transactionCounter uint16) {
	m.Parent.Status = status
	m.Parent.TransactionCounter = transactionCounter
}

func NewDF1UnprotectedReadRequest(address uint16, size uint8, status uint8, transactionCounter uint16) *DF1Command {
	child := &DF1UnprotectedReadRequest{
		Address: address,
		Size:    size,
		Parent:  NewDF1Command(status, transactionCounter),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastDF1UnprotectedReadRequest(structType interface{}) *DF1UnprotectedReadRequest {
	castFunc := func(typ interface{}) *DF1UnprotectedReadRequest {
		if casted, ok := typ.(DF1UnprotectedReadRequest); ok {
			return &casted
		}
		if casted, ok := typ.(*DF1UnprotectedReadRequest); ok {
			return casted
		}
		if casted, ok := typ.(DF1Command); ok {
			return CastDF1UnprotectedReadRequest(casted.Child)
		}
		if casted, ok := typ.(*DF1Command); ok {
			return CastDF1UnprotectedReadRequest(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *DF1UnprotectedReadRequest) GetTypeName() string {
	return "DF1UnprotectedReadRequest"
}

func (m *DF1UnprotectedReadRequest) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *DF1UnprotectedReadRequest) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Simple field (address)
	lengthInBits += 16

	// Simple field (size)
	lengthInBits += 8

	return lengthInBits
}

func (m *DF1UnprotectedReadRequest) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func DF1UnprotectedReadRequestParse(readBuffer utils.ReadBuffer) (*DF1Command, error) {
	if pullErr := readBuffer.PullContext("DF1UnprotectedReadRequest"); pullErr != nil {
		return nil, pullErr
	}

	// Simple Field (address)
	address, _addressErr := readBuffer.ReadUint16("address", 16)
	if _addressErr != nil {
		return nil, errors.Wrap(_addressErr, "Error parsing 'address' field")
	}

	// Simple Field (size)
	size, _sizeErr := readBuffer.ReadUint8("size", 8)
	if _sizeErr != nil {
		return nil, errors.Wrap(_sizeErr, "Error parsing 'size' field")
	}

	if closeErr := readBuffer.CloseContext("DF1UnprotectedReadRequest"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &DF1UnprotectedReadRequest{
		Address: address,
		Size:    size,
		Parent:  &DF1Command{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *DF1UnprotectedReadRequest) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DF1UnprotectedReadRequest"); pushErr != nil {
			return pushErr
		}

		// Simple Field (address)
		address := uint16(m.Address)
		_addressErr := writeBuffer.WriteUint16("address", 16, (address))
		if _addressErr != nil {
			return errors.Wrap(_addressErr, "Error serializing 'address' field")
		}

		// Simple Field (size)
		size := uint8(m.Size)
		_sizeErr := writeBuffer.WriteUint8("size", 8, (size))
		if _sizeErr != nil {
			return errors.Wrap(_sizeErr, "Error serializing 'size' field")
		}

		if popErr := writeBuffer.PopContext("DF1UnprotectedReadRequest"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *DF1UnprotectedReadRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
