/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type NLM struct {
	VendorId *uint16
	Child    INLMChild
}

// The corresponding interface
type INLM interface {
	MessageType() uint8
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

type INLMParent interface {
	SerializeParent(writeBuffer utils.WriteBuffer, child INLM, serializeChildFunction func() error) error
	GetTypeName() string
}

type INLMChild interface {
	Serialize(writeBuffer utils.WriteBuffer) error
	InitializeParent(parent *NLM, vendorId *uint16)
	GetTypeName() string
	INLM
}

func NewNLM(vendorId *uint16) *NLM {
	return &NLM{VendorId: vendorId}
}

func CastNLM(structType interface{}) *NLM {
	castFunc := func(typ interface{}) *NLM {
		if casted, ok := typ.(NLM); ok {
			return &casted
		}
		if casted, ok := typ.(*NLM); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *NLM) GetTypeName() string {
	return "NLM"
}

func (m *NLM) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *NLM) LengthInBitsConditional(lastItem bool) uint16 {
	return m.Child.LengthInBits()
}

func (m *NLM) ParentLengthInBits() uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (messageType)
	lengthInBits += 8

	// Optional Field (vendorId)
	if m.VendorId != nil {
		lengthInBits += 16
	}

	return lengthInBits
}

func (m *NLM) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func NLMParse(readBuffer utils.ReadBuffer, apduLength uint16) (*NLM, error) {
	if pullErr := readBuffer.PullContext("NLM"); pullErr != nil {
		return nil, pullErr
	}

	// Discriminator Field (messageType) (Used as input to a switch field)
	messageType, _messageTypeErr := readBuffer.ReadUint8("messageType", 8)
	if _messageTypeErr != nil {
		return nil, errors.Wrap(_messageTypeErr, "Error parsing 'messageType' field")
	}

	// Optional Field (vendorId) (Can be skipped, if a given expression evaluates to false)
	var vendorId *uint16 = nil
	if bool(bool(bool((messageType) >= (128)))) && bool(bool(bool((messageType) <= (255)))) {
		_val, _err := readBuffer.ReadUint16("vendorId", 16)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'vendorId' field")
		}
		vendorId = &_val
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _parent *NLM
	var typeSwitchError error
	switch {
	case messageType == 0x0: // NLMWhoIsRouterToNetwork
		_parent, typeSwitchError = NLMWhoIsRouterToNetworkParse(readBuffer, apduLength, messageType)
	case messageType == 0x1: // NLMIAmRouterToNetwork
		_parent, typeSwitchError = NLMIAmRouterToNetworkParse(readBuffer, apduLength, messageType)
	default:
		// TODO: return actual type
		typeSwitchError = errors.New("Unmapped type")
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch.")
	}

	if closeErr := readBuffer.CloseContext("NLM"); closeErr != nil {
		return nil, closeErr
	}

	// Finish initializing
	_parent.Child.InitializeParent(_parent, vendorId)
	return _parent, nil
}

func (m *NLM) Serialize(writeBuffer utils.WriteBuffer) error {
	return m.Child.Serialize(writeBuffer)
}

func (m *NLM) SerializeParent(writeBuffer utils.WriteBuffer, child INLM, serializeChildFunction func() error) error {
	if pushErr := writeBuffer.PushContext("NLM"); pushErr != nil {
		return pushErr
	}

	// Discriminator Field (messageType) (Used as input to a switch field)
	messageType := uint8(child.MessageType())
	_messageTypeErr := writeBuffer.WriteUint8("messageType", 8, (messageType))

	if _messageTypeErr != nil {
		return errors.Wrap(_messageTypeErr, "Error serializing 'messageType' field")
	}

	// Optional Field (vendorId) (Can be skipped, if the value is null)
	var vendorId *uint16 = nil
	if m.VendorId != nil {
		vendorId = m.VendorId
		_vendorIdErr := writeBuffer.WriteUint16("vendorId", 16, *(vendorId))
		if _vendorIdErr != nil {
			return errors.Wrap(_vendorIdErr, "Error serializing 'vendorId' field")
		}
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	_typeSwitchErr := serializeChildFunction()
	if _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("NLM"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *NLM) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
