/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"fmt"
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const BACnetUnconfirmedServiceRequestWhoIs_DEVICEINSTANCERANGELOWLIMITHEADER uint8 = 0x01
const BACnetUnconfirmedServiceRequestWhoIs_DEVICEINSTANCERANGEHIGHLIMITHEADER uint8 = 0x03

// The data-structure of this message
type BACnetUnconfirmedServiceRequestWhoIs struct {
	DeviceInstanceRangeLowLimitLength  uint8
	DeviceInstanceRangeLowLimit        []int8
	DeviceInstanceRangeHighLimitLength uint8
	DeviceInstanceRangeHighLimit       []int8
	Parent                             *BACnetUnconfirmedServiceRequest
}

// The corresponding interface
type IBACnetUnconfirmedServiceRequestWhoIs interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *BACnetUnconfirmedServiceRequestWhoIs) ServiceChoice() uint8 {
	return 0x08
}

func (m *BACnetUnconfirmedServiceRequestWhoIs) InitializeParent(parent *BACnetUnconfirmedServiceRequest) {
}

func NewBACnetUnconfirmedServiceRequestWhoIs(deviceInstanceRangeLowLimitLength uint8, deviceInstanceRangeLowLimit []int8, deviceInstanceRangeHighLimitLength uint8, deviceInstanceRangeHighLimit []int8) *BACnetUnconfirmedServiceRequest {
	child := &BACnetUnconfirmedServiceRequestWhoIs{
		DeviceInstanceRangeLowLimitLength:  deviceInstanceRangeLowLimitLength,
		DeviceInstanceRangeLowLimit:        deviceInstanceRangeLowLimit,
		DeviceInstanceRangeHighLimitLength: deviceInstanceRangeHighLimitLength,
		DeviceInstanceRangeHighLimit:       deviceInstanceRangeHighLimit,
		Parent:                             NewBACnetUnconfirmedServiceRequest(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastBACnetUnconfirmedServiceRequestWhoIs(structType interface{}) *BACnetUnconfirmedServiceRequestWhoIs {
	castFunc := func(typ interface{}) *BACnetUnconfirmedServiceRequestWhoIs {
		if casted, ok := typ.(BACnetUnconfirmedServiceRequestWhoIs); ok {
			return &casted
		}
		if casted, ok := typ.(*BACnetUnconfirmedServiceRequestWhoIs); ok {
			return casted
		}
		if casted, ok := typ.(BACnetUnconfirmedServiceRequest); ok {
			return CastBACnetUnconfirmedServiceRequestWhoIs(casted.Child)
		}
		if casted, ok := typ.(*BACnetUnconfirmedServiceRequest); ok {
			return CastBACnetUnconfirmedServiceRequestWhoIs(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *BACnetUnconfirmedServiceRequestWhoIs) GetTypeName() string {
	return "BACnetUnconfirmedServiceRequestWhoIs"
}

func (m *BACnetUnconfirmedServiceRequestWhoIs) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *BACnetUnconfirmedServiceRequestWhoIs) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Const Field (deviceInstanceRangeLowLimitHeader)
	lengthInBits += 5

	// Simple field (deviceInstanceRangeLowLimitLength)
	lengthInBits += 3

	// Array field
	if len(m.DeviceInstanceRangeLowLimit) > 0 {
		lengthInBits += 8 * uint16(len(m.DeviceInstanceRangeLowLimit))
	}

	// Const Field (deviceInstanceRangeHighLimitHeader)
	lengthInBits += 5

	// Simple field (deviceInstanceRangeHighLimitLength)
	lengthInBits += 3

	// Array field
	if len(m.DeviceInstanceRangeHighLimit) > 0 {
		lengthInBits += 8 * uint16(len(m.DeviceInstanceRangeHighLimit))
	}

	return lengthInBits
}

func (m *BACnetUnconfirmedServiceRequestWhoIs) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func BACnetUnconfirmedServiceRequestWhoIsParse(readBuffer utils.ReadBuffer) (*BACnetUnconfirmedServiceRequest, error) {
	if pullErr := readBuffer.PullContext("BACnetUnconfirmedServiceRequestWhoIs"); pullErr != nil {
		return nil, pullErr
	}

	// Const Field (deviceInstanceRangeLowLimitHeader)
	deviceInstanceRangeLowLimitHeader, _deviceInstanceRangeLowLimitHeaderErr := readBuffer.ReadUint8("deviceInstanceRangeLowLimitHeader", 5)
	if _deviceInstanceRangeLowLimitHeaderErr != nil {
		return nil, errors.Wrap(_deviceInstanceRangeLowLimitHeaderErr, "Error parsing 'deviceInstanceRangeLowLimitHeader' field")
	}
	if deviceInstanceRangeLowLimitHeader != BACnetUnconfirmedServiceRequestWhoIs_DEVICEINSTANCERANGELOWLIMITHEADER {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", BACnetUnconfirmedServiceRequestWhoIs_DEVICEINSTANCERANGELOWLIMITHEADER) + " but got " + fmt.Sprintf("%d", deviceInstanceRangeLowLimitHeader))
	}

	// Simple Field (deviceInstanceRangeLowLimitLength)
	deviceInstanceRangeLowLimitLength, _deviceInstanceRangeLowLimitLengthErr := readBuffer.ReadUint8("deviceInstanceRangeLowLimitLength", 3)
	if _deviceInstanceRangeLowLimitLengthErr != nil {
		return nil, errors.Wrap(_deviceInstanceRangeLowLimitLengthErr, "Error parsing 'deviceInstanceRangeLowLimitLength' field")
	}

	// Array field (deviceInstanceRangeLowLimit)
	if pullErr := readBuffer.PullContext("deviceInstanceRangeLowLimit", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, pullErr
	}
	// Count array
	deviceInstanceRangeLowLimit := make([]int8, deviceInstanceRangeLowLimitLength)
	for curItem := uint16(0); curItem < uint16(deviceInstanceRangeLowLimitLength); curItem++ {
		_item, _err := readBuffer.ReadInt8("", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'deviceInstanceRangeLowLimit' field")
		}
		deviceInstanceRangeLowLimit[curItem] = _item
	}
	if closeErr := readBuffer.CloseContext("deviceInstanceRangeLowLimit", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, closeErr
	}

	// Const Field (deviceInstanceRangeHighLimitHeader)
	deviceInstanceRangeHighLimitHeader, _deviceInstanceRangeHighLimitHeaderErr := readBuffer.ReadUint8("deviceInstanceRangeHighLimitHeader", 5)
	if _deviceInstanceRangeHighLimitHeaderErr != nil {
		return nil, errors.Wrap(_deviceInstanceRangeHighLimitHeaderErr, "Error parsing 'deviceInstanceRangeHighLimitHeader' field")
	}
	if deviceInstanceRangeHighLimitHeader != BACnetUnconfirmedServiceRequestWhoIs_DEVICEINSTANCERANGEHIGHLIMITHEADER {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", BACnetUnconfirmedServiceRequestWhoIs_DEVICEINSTANCERANGEHIGHLIMITHEADER) + " but got " + fmt.Sprintf("%d", deviceInstanceRangeHighLimitHeader))
	}

	// Simple Field (deviceInstanceRangeHighLimitLength)
	deviceInstanceRangeHighLimitLength, _deviceInstanceRangeHighLimitLengthErr := readBuffer.ReadUint8("deviceInstanceRangeHighLimitLength", 3)
	if _deviceInstanceRangeHighLimitLengthErr != nil {
		return nil, errors.Wrap(_deviceInstanceRangeHighLimitLengthErr, "Error parsing 'deviceInstanceRangeHighLimitLength' field")
	}

	// Array field (deviceInstanceRangeHighLimit)
	if pullErr := readBuffer.PullContext("deviceInstanceRangeHighLimit", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, pullErr
	}
	// Count array
	deviceInstanceRangeHighLimit := make([]int8, deviceInstanceRangeHighLimitLength)
	for curItem := uint16(0); curItem < uint16(deviceInstanceRangeHighLimitLength); curItem++ {
		_item, _err := readBuffer.ReadInt8("", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'deviceInstanceRangeHighLimit' field")
		}
		deviceInstanceRangeHighLimit[curItem] = _item
	}
	if closeErr := readBuffer.CloseContext("deviceInstanceRangeHighLimit", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, closeErr
	}

	if closeErr := readBuffer.CloseContext("BACnetUnconfirmedServiceRequestWhoIs"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &BACnetUnconfirmedServiceRequestWhoIs{
		DeviceInstanceRangeLowLimitLength:  deviceInstanceRangeLowLimitLength,
		DeviceInstanceRangeLowLimit:        deviceInstanceRangeLowLimit,
		DeviceInstanceRangeHighLimitLength: deviceInstanceRangeHighLimitLength,
		DeviceInstanceRangeHighLimit:       deviceInstanceRangeHighLimit,
		Parent:                             &BACnetUnconfirmedServiceRequest{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *BACnetUnconfirmedServiceRequestWhoIs) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetUnconfirmedServiceRequestWhoIs"); pushErr != nil {
			return pushErr
		}

		// Const Field (deviceInstanceRangeLowLimitHeader)
		_deviceInstanceRangeLowLimitHeaderErr := writeBuffer.WriteUint8("deviceInstanceRangeLowLimitHeader", 5, 0x01)
		if _deviceInstanceRangeLowLimitHeaderErr != nil {
			return errors.Wrap(_deviceInstanceRangeLowLimitHeaderErr, "Error serializing 'deviceInstanceRangeLowLimitHeader' field")
		}

		// Simple Field (deviceInstanceRangeLowLimitLength)
		deviceInstanceRangeLowLimitLength := uint8(m.DeviceInstanceRangeLowLimitLength)
		_deviceInstanceRangeLowLimitLengthErr := writeBuffer.WriteUint8("deviceInstanceRangeLowLimitLength", 3, (deviceInstanceRangeLowLimitLength))
		if _deviceInstanceRangeLowLimitLengthErr != nil {
			return errors.Wrap(_deviceInstanceRangeLowLimitLengthErr, "Error serializing 'deviceInstanceRangeLowLimitLength' field")
		}

		// Array Field (deviceInstanceRangeLowLimit)
		if m.DeviceInstanceRangeLowLimit != nil {
			if pushErr := writeBuffer.PushContext("deviceInstanceRangeLowLimit", utils.WithRenderAsList(true)); pushErr != nil {
				return pushErr
			}
			for _, _element := range m.DeviceInstanceRangeLowLimit {
				_elementErr := writeBuffer.WriteInt8("", 8, _element)
				if _elementErr != nil {
					return errors.Wrap(_elementErr, "Error serializing 'deviceInstanceRangeLowLimit' field")
				}
			}
			if popErr := writeBuffer.PopContext("deviceInstanceRangeLowLimit", utils.WithRenderAsList(true)); popErr != nil {
				return popErr
			}
		}

		// Const Field (deviceInstanceRangeHighLimitHeader)
		_deviceInstanceRangeHighLimitHeaderErr := writeBuffer.WriteUint8("deviceInstanceRangeHighLimitHeader", 5, 0x03)
		if _deviceInstanceRangeHighLimitHeaderErr != nil {
			return errors.Wrap(_deviceInstanceRangeHighLimitHeaderErr, "Error serializing 'deviceInstanceRangeHighLimitHeader' field")
		}

		// Simple Field (deviceInstanceRangeHighLimitLength)
		deviceInstanceRangeHighLimitLength := uint8(m.DeviceInstanceRangeHighLimitLength)
		_deviceInstanceRangeHighLimitLengthErr := writeBuffer.WriteUint8("deviceInstanceRangeHighLimitLength", 3, (deviceInstanceRangeHighLimitLength))
		if _deviceInstanceRangeHighLimitLengthErr != nil {
			return errors.Wrap(_deviceInstanceRangeHighLimitLengthErr, "Error serializing 'deviceInstanceRangeHighLimitLength' field")
		}

		// Array Field (deviceInstanceRangeHighLimit)
		if m.DeviceInstanceRangeHighLimit != nil {
			if pushErr := writeBuffer.PushContext("deviceInstanceRangeHighLimit", utils.WithRenderAsList(true)); pushErr != nil {
				return pushErr
			}
			for _, _element := range m.DeviceInstanceRangeHighLimit {
				_elementErr := writeBuffer.WriteInt8("", 8, _element)
				if _elementErr != nil {
					return errors.Wrap(_elementErr, "Error serializing 'deviceInstanceRangeHighLimit' field")
				}
			}
			if popErr := writeBuffer.PopContext("deviceInstanceRangeHighLimit", utils.WithRenderAsList(true)); popErr != nil {
				return popErr
			}
		}

		if popErr := writeBuffer.PopContext("BACnetUnconfirmedServiceRequestWhoIs"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *BACnetUnconfirmedServiceRequestWhoIs) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
