/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"fmt"
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const BACnetErrorReadProperty_ERRORCLASSHEADER uint8 = 0x12
const BACnetErrorReadProperty_ERRORCODEHEADER uint8 = 0x12

// The data-structure of this message
type BACnetErrorReadProperty struct {
	ErrorClassLength uint8
	ErrorClass       []int8
	ErrorCodeLength  uint8
	ErrorCode        []int8
	Parent           *BACnetError
}

// The corresponding interface
type IBACnetErrorReadProperty interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *BACnetErrorReadProperty) ServiceChoice() uint8 {
	return 0x0C
}

func (m *BACnetErrorReadProperty) InitializeParent(parent *BACnetError) {
}

func NewBACnetErrorReadProperty(errorClassLength uint8, errorClass []int8, errorCodeLength uint8, errorCode []int8) *BACnetError {
	child := &BACnetErrorReadProperty{
		ErrorClassLength: errorClassLength,
		ErrorClass:       errorClass,
		ErrorCodeLength:  errorCodeLength,
		ErrorCode:        errorCode,
		Parent:           NewBACnetError(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastBACnetErrorReadProperty(structType interface{}) *BACnetErrorReadProperty {
	castFunc := func(typ interface{}) *BACnetErrorReadProperty {
		if casted, ok := typ.(BACnetErrorReadProperty); ok {
			return &casted
		}
		if casted, ok := typ.(*BACnetErrorReadProperty); ok {
			return casted
		}
		if casted, ok := typ.(BACnetError); ok {
			return CastBACnetErrorReadProperty(casted.Child)
		}
		if casted, ok := typ.(*BACnetError); ok {
			return CastBACnetErrorReadProperty(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *BACnetErrorReadProperty) GetTypeName() string {
	return "BACnetErrorReadProperty"
}

func (m *BACnetErrorReadProperty) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *BACnetErrorReadProperty) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Const Field (errorClassHeader)
	lengthInBits += 5

	// Simple field (errorClassLength)
	lengthInBits += 3

	// Array field
	if len(m.ErrorClass) > 0 {
		lengthInBits += 8 * uint16(len(m.ErrorClass))
	}

	// Const Field (errorCodeHeader)
	lengthInBits += 5

	// Simple field (errorCodeLength)
	lengthInBits += 3

	// Array field
	if len(m.ErrorCode) > 0 {
		lengthInBits += 8 * uint16(len(m.ErrorCode))
	}

	return lengthInBits
}

func (m *BACnetErrorReadProperty) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func BACnetErrorReadPropertyParse(readBuffer utils.ReadBuffer) (*BACnetError, error) {
	if pullErr := readBuffer.PullContext("BACnetErrorReadProperty"); pullErr != nil {
		return nil, pullErr
	}

	// Const Field (errorClassHeader)
	errorClassHeader, _errorClassHeaderErr := readBuffer.ReadUint8("errorClassHeader", 5)
	if _errorClassHeaderErr != nil {
		return nil, errors.Wrap(_errorClassHeaderErr, "Error parsing 'errorClassHeader' field")
	}
	if errorClassHeader != BACnetErrorReadProperty_ERRORCLASSHEADER {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", BACnetErrorReadProperty_ERRORCLASSHEADER) + " but got " + fmt.Sprintf("%d", errorClassHeader))
	}

	// Simple Field (errorClassLength)
	errorClassLength, _errorClassLengthErr := readBuffer.ReadUint8("errorClassLength", 3)
	if _errorClassLengthErr != nil {
		return nil, errors.Wrap(_errorClassLengthErr, "Error parsing 'errorClassLength' field")
	}

	// Array field (errorClass)
	if pullErr := readBuffer.PullContext("errorClass", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, pullErr
	}
	// Count array
	errorClass := make([]int8, errorClassLength)
	for curItem := uint16(0); curItem < uint16(errorClassLength); curItem++ {
		_item, _err := readBuffer.ReadInt8("", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'errorClass' field")
		}
		errorClass[curItem] = _item
	}
	if closeErr := readBuffer.CloseContext("errorClass", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, closeErr
	}

	// Const Field (errorCodeHeader)
	errorCodeHeader, _errorCodeHeaderErr := readBuffer.ReadUint8("errorCodeHeader", 5)
	if _errorCodeHeaderErr != nil {
		return nil, errors.Wrap(_errorCodeHeaderErr, "Error parsing 'errorCodeHeader' field")
	}
	if errorCodeHeader != BACnetErrorReadProperty_ERRORCODEHEADER {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", BACnetErrorReadProperty_ERRORCODEHEADER) + " but got " + fmt.Sprintf("%d", errorCodeHeader))
	}

	// Simple Field (errorCodeLength)
	errorCodeLength, _errorCodeLengthErr := readBuffer.ReadUint8("errorCodeLength", 3)
	if _errorCodeLengthErr != nil {
		return nil, errors.Wrap(_errorCodeLengthErr, "Error parsing 'errorCodeLength' field")
	}

	// Array field (errorCode)
	if pullErr := readBuffer.PullContext("errorCode", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, pullErr
	}
	// Count array
	errorCode := make([]int8, errorCodeLength)
	for curItem := uint16(0); curItem < uint16(errorCodeLength); curItem++ {
		_item, _err := readBuffer.ReadInt8("", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'errorCode' field")
		}
		errorCode[curItem] = _item
	}
	if closeErr := readBuffer.CloseContext("errorCode", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, closeErr
	}

	if closeErr := readBuffer.CloseContext("BACnetErrorReadProperty"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &BACnetErrorReadProperty{
		ErrorClassLength: errorClassLength,
		ErrorClass:       errorClass,
		ErrorCodeLength:  errorCodeLength,
		ErrorCode:        errorCode,
		Parent:           &BACnetError{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *BACnetErrorReadProperty) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetErrorReadProperty"); pushErr != nil {
			return pushErr
		}

		// Const Field (errorClassHeader)
		_errorClassHeaderErr := writeBuffer.WriteUint8("errorClassHeader", 5, 0x12)
		if _errorClassHeaderErr != nil {
			return errors.Wrap(_errorClassHeaderErr, "Error serializing 'errorClassHeader' field")
		}

		// Simple Field (errorClassLength)
		errorClassLength := uint8(m.ErrorClassLength)
		_errorClassLengthErr := writeBuffer.WriteUint8("errorClassLength", 3, (errorClassLength))
		if _errorClassLengthErr != nil {
			return errors.Wrap(_errorClassLengthErr, "Error serializing 'errorClassLength' field")
		}

		// Array Field (errorClass)
		if m.ErrorClass != nil {
			if pushErr := writeBuffer.PushContext("errorClass", utils.WithRenderAsList(true)); pushErr != nil {
				return pushErr
			}
			for _, _element := range m.ErrorClass {
				_elementErr := writeBuffer.WriteInt8("", 8, _element)
				if _elementErr != nil {
					return errors.Wrap(_elementErr, "Error serializing 'errorClass' field")
				}
			}
			if popErr := writeBuffer.PopContext("errorClass", utils.WithRenderAsList(true)); popErr != nil {
				return popErr
			}
		}

		// Const Field (errorCodeHeader)
		_errorCodeHeaderErr := writeBuffer.WriteUint8("errorCodeHeader", 5, 0x12)
		if _errorCodeHeaderErr != nil {
			return errors.Wrap(_errorCodeHeaderErr, "Error serializing 'errorCodeHeader' field")
		}

		// Simple Field (errorCodeLength)
		errorCodeLength := uint8(m.ErrorCodeLength)
		_errorCodeLengthErr := writeBuffer.WriteUint8("errorCodeLength", 3, (errorCodeLength))
		if _errorCodeLengthErr != nil {
			return errors.Wrap(_errorCodeLengthErr, "Error serializing 'errorCodeLength' field")
		}

		// Array Field (errorCode)
		if m.ErrorCode != nil {
			if pushErr := writeBuffer.PushContext("errorCode", utils.WithRenderAsList(true)); pushErr != nil {
				return pushErr
			}
			for _, _element := range m.ErrorCode {
				_elementErr := writeBuffer.WriteInt8("", 8, _element)
				if _elementErr != nil {
					return errors.Wrap(_elementErr, "Error serializing 'errorCode' field")
				}
			}
			if popErr := writeBuffer.PopContext("errorCode", utils.WithRenderAsList(true)); popErr != nil {
				return popErr
			}
		}

		if popErr := writeBuffer.PopContext("BACnetErrorReadProperty"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *BACnetErrorReadProperty) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
