/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <plc4c/spi/evaluation_helper.h>
#include "s7_payload_user_data_item.h"

// Code generated by code-generation. DO NOT EDIT.

// Array of discriminator values that match the enum type constants.
// (The order is identical to the enum constants so we can use the
// enum constant to directly access a given types discriminator values)
const plc4c_s7_read_write_s7_payload_user_data_item_discriminator plc4c_s7_read_write_s7_payload_user_data_item_discriminators[] = {
  {/* plc4c_s7_read_write_s7_payload_diagnostic_message */
   .cpuFunctionType = 0x00, .cpuSubfunction = 0x03, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_alarm8 */
   .cpuFunctionType = 0x00, .cpuSubfunction = 0x05, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_notify */
   .cpuFunctionType = 0x00, .cpuSubfunction = 0x06, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_alarm_ack_ind */
   .cpuFunctionType = 0x00, .cpuSubfunction = 0x0c, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_alarm_sq */
   .cpuFunctionType = 0x00, .cpuSubfunction = 0x11, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_alarm_s */
   .cpuFunctionType = 0x00, .cpuSubfunction = 0x12, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_alarm_sc */
   .cpuFunctionType = 0x00, .cpuSubfunction = 0x13, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_notify8 */
   .cpuFunctionType = 0x00, .cpuSubfunction = 0x16, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request */
   .cpuFunctionType = 0x04, .cpuSubfunction = 0x01, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response */
   .cpuFunctionType = 0x08, .cpuSubfunction = 0x01, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription */
   .cpuFunctionType = 0x04, .cpuSubfunction = 0x02, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response */
   .cpuFunctionType = 0x08, .cpuSubfunction = 0x02, .dataLength = 0x00},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response */
   .cpuFunctionType = 0x08, .cpuSubfunction = 0x02, .dataLength = 0x02},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response */
   .cpuFunctionType = 0x08, .cpuSubfunction = 0x02, .dataLength = 0x05},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack */
   .cpuFunctionType = 0x04, .cpuSubfunction = 0x0b, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response */
   .cpuFunctionType = 0x08, .cpuSubfunction = 0x0b, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query */
   .cpuFunctionType = 0x04, .cpuSubfunction = 0x13, .dataLength = -1},
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response */
   .cpuFunctionType = 0x08, .cpuSubfunction = 0x13, .dataLength = -1}

};

// Function returning the discriminator values for a given type constant.
plc4c_s7_read_write_s7_payload_user_data_item_discriminator plc4c_s7_read_write_s7_payload_user_data_item_get_discriminator(plc4c_s7_read_write_s7_payload_user_data_item_type type) {
  return plc4c_s7_read_write_s7_payload_user_data_item_discriminators[type];
}

// Create an empty NULL-struct
static const plc4c_s7_read_write_s7_payload_user_data_item plc4c_s7_read_write_s7_payload_user_data_item_null_const;

plc4c_s7_read_write_s7_payload_user_data_item plc4c_s7_read_write_s7_payload_user_data_item_null() {
  return plc4c_s7_read_write_s7_payload_user_data_item_null_const;
}


// Constant values.
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_LENGTH_const = 0x08;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_LENGTH() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_LENGTH_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_NUMBER_MESSAGE_OBJ_const = 0x01;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_NUMBER_MESSAGE_OBJ() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_NUMBER_MESSAGE_OBJ_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_VARIABLE_SPEC_const = 0x12;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_VARIABLE_SPEC() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_VARIABLE_SPEC_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_FUNCTION_ID_const = 0x00;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_FUNCTION_ID() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_FUNCTION_ID_const;
}
static const uint16_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_READ_SZL_RESPONSE_SZL_ITEM_LENGTH_const = 28;
uint16_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_READ_SZL_RESPONSE_SZL_ITEM_LENGTH() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_READ_SZL_RESPONSE_SZL_ITEM_LENGTH_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_FUNCTION_ID_const = 0x00;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_FUNCTION_ID() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_FUNCTION_ID_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_NUMBER_MESSAGE_OBJ_const = 0x01;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_NUMBER_MESSAGE_OBJ() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_NUMBER_MESSAGE_OBJ_const;
}

// Parse function.
plc4c_return_code plc4c_s7_read_write_s7_payload_user_data_item_parse(plc4c_spi_read_buffer* readBuffer, uint8_t cpuFunctionType, uint8_t cpuSubfunction, plc4c_s7_read_write_s7_payload_user_data_item** _message) {
  uint16_t startPos = plc4c_spi_read_get_pos(readBuffer);
  uint16_t curPos;
  plc4c_return_code _res = OK;

  // Allocate enough memory to contain this data structure.
  (*_message) = malloc(sizeof(plc4c_s7_read_write_s7_payload_user_data_item));
  if(*_message == NULL) {
    return NO_MEMORY;
  }

  // Simple Field (returnCode)
  plc4c_s7_read_write_data_transport_error_code* returnCode;
  _res = plc4c_s7_read_write_data_transport_error_code_parse(readBuffer, (void*) &returnCode);
  if(_res != OK) {
    return _res;
  }
  (*_message)->return_code = *returnCode;

  // Simple Field (transportSize)
  plc4c_s7_read_write_data_transport_size* transportSize;
  _res = plc4c_s7_read_write_data_transport_size_parse(readBuffer, (void*) &transportSize);
  if(_res != OK) {
    return _res;
  }
  (*_message)->transport_size = *transportSize;

  // Implicit Field (dataLength) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
  uint16_t dataLength = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &dataLength);
  if(_res != OK) {
    return _res;
  }

  // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
  if((cpuFunctionType == 0x00) && (cpuSubfunction == 0x03)) { /* S7PayloadDiagnosticMessage */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_diagnostic_message;
                    
    // Simple Field (EventId)
    uint16_t EventId = 0;
    _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &EventId);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_diagnostic_message_event_id = EventId;


                    
    // Simple Field (PriorityClass)
    uint8_t PriorityClass = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &PriorityClass);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_diagnostic_message_priority_class = PriorityClass;


                    
    // Simple Field (ObNumber)
    uint8_t ObNumber = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &ObNumber);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_diagnostic_message_ob_number = ObNumber;


                    
    // Simple Field (DatId)
    uint16_t DatId = 0;
    _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &DatId);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_diagnostic_message_dat_id = DatId;


                    
    // Simple Field (Info1)
    uint16_t Info1 = 0;
    _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &Info1);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_diagnostic_message_info1 = Info1;


                    
    // Simple Field (Info2)
    uint32_t Info2 = 0;
    _res = plc4c_spi_read_unsigned_int(readBuffer, 32, (uint32_t*) &Info2);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_diagnostic_message_info2 = Info2;


                    
    // Simple Field (TimeStamp)
    plc4c_s7_read_write_date_and_time* TimeStamp;
    _res = plc4c_s7_read_write_date_and_time_parse(readBuffer, (void*) &TimeStamp);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_diagnostic_message_time_stamp = TimeStamp;

  } else 
  if((cpuFunctionType == 0x00) && (cpuSubfunction == 0x05)) { /* S7PayloadAlarm8 */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm8;
                    
    // Simple Field (alarmMessage)
    plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
    _res = plc4c_s7_read_write_alarm_message_push_type_parse(readBuffer, (void*) &alarmMessage);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_alarm8_alarm_message = alarmMessage;

  } else 
  if((cpuFunctionType == 0x00) && (cpuSubfunction == 0x06)) { /* S7PayloadNotify */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify;
                    
    // Simple Field (alarmMessage)
    plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
    _res = plc4c_s7_read_write_alarm_message_push_type_parse(readBuffer, (void*) &alarmMessage);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_notify_alarm_message = alarmMessage;

  } else 
  if((cpuFunctionType == 0x00) && (cpuSubfunction == 0x0c)) { /* S7PayloadAlarmAckInd */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_ack_ind;
                    
    // Simple Field (alarmMessage)
    plc4c_s7_read_write_alarm_message_ack_push_type* alarmMessage;
    _res = plc4c_s7_read_write_alarm_message_ack_push_type_parse(readBuffer, (void*) &alarmMessage);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_alarm_ack_ind_alarm_message = alarmMessage;

  } else 
  if((cpuFunctionType == 0x00) && (cpuSubfunction == 0x11)) { /* S7PayloadAlarmSQ */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sq;
                    
    // Simple Field (alarmMessage)
    plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
    _res = plc4c_s7_read_write_alarm_message_push_type_parse(readBuffer, (void*) &alarmMessage);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_alarm_sq_alarm_message = alarmMessage;

  } else 
  if((cpuFunctionType == 0x00) && (cpuSubfunction == 0x12)) { /* S7PayloadAlarmS */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_s;
                    
    // Simple Field (alarmMessage)
    plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
    _res = plc4c_s7_read_write_alarm_message_push_type_parse(readBuffer, (void*) &alarmMessage);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_alarm_s_alarm_message = alarmMessage;

  } else 
  if((cpuFunctionType == 0x00) && (cpuSubfunction == 0x13)) { /* S7PayloadAlarmSC */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sc;
                    
    // Simple Field (alarmMessage)
    plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
    _res = plc4c_s7_read_write_alarm_message_push_type_parse(readBuffer, (void*) &alarmMessage);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_alarm_sc_alarm_message = alarmMessage;

  } else 
  if((cpuFunctionType == 0x00) && (cpuSubfunction == 0x16)) { /* S7PayloadNotify8 */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify8;
                    
    // Simple Field (alarmMessage)
    plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
    _res = plc4c_s7_read_write_alarm_message_push_type_parse(readBuffer, (void*) &alarmMessage);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_notify8_alarm_message = alarmMessage;

  } else 
  if((cpuFunctionType == 0x04) && (cpuSubfunction == 0x01)) { /* S7PayloadUserDataItemCpuFunctionReadSzlRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request;
                    
    // Simple Field (szlId)
    plc4c_s7_read_write_szl_id* szlId;
    _res = plc4c_s7_read_write_szl_id_parse(readBuffer, (void*) &szlId);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_read_szl_request_szl_id = szlId;


                    
    // Simple Field (szlIndex)
    uint16_t szlIndex = 0;
    _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &szlIndex);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_read_szl_request_szl_index = szlIndex;

  } else 
  if((cpuFunctionType == 0x08) && (cpuSubfunction == 0x01)) { /* S7PayloadUserDataItemCpuFunctionReadSzlResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response;
                    
    // Simple Field (szlId)
    plc4c_s7_read_write_szl_id* szlId;
    _res = plc4c_s7_read_write_szl_id_parse(readBuffer, (void*) &szlId);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_read_szl_response_szl_id = szlId;


                    
    // Simple Field (szlIndex)
    uint16_t szlIndex = 0;
    _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &szlIndex);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_read_szl_response_szl_index = szlIndex;


                    
    // Const Field (szlItemLength)
    uint16_t szlItemLength = 0;
    _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &szlItemLength);
    if(_res != OK) {
      return _res;
    }
    if(szlItemLength != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_READ_SZL_RESPONSE_SZL_ITEM_LENGTH()) {
      return PARSE_ERROR;
      // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_READ_SZL_RESPONSE_SZL_ITEM_LENGTH + " but got " + szlItemLength);
    }


                    
    // Implicit Field (szlItemCount) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
    uint16_t szlItemCount = 0;
    _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &szlItemCount);
    if(_res != OK) {
      return _res;
    }


                    
    // Array field (items)
    plc4c_list* items = NULL;
    plc4c_utils_list_create(&items);
    if(items == NULL) {
      return NO_MEMORY;
    }
    {
      // Count array
      uint16_t itemCount = (uint16_t) szlItemCount;
      for(int curItem = 0; curItem < itemCount; curItem++) {
        bool lastItem = curItem == (itemCount - 1);
        plc4c_s7_read_write_szl_data_tree_item* _value = NULL;
        _res = plc4c_s7_read_write_szl_data_tree_item_parse(readBuffer, (void*) &_value);
        if(_res != OK) {
          return _res;
        }
        plc4c_utils_list_insert_head_value(items, _value);
      }
    }
    (*_message)->s7_payload_user_data_item_cpu_function_read_szl_response_items = items;

  } else 
  if((cpuFunctionType == 0x04) && (cpuSubfunction == 0x02)) { /* S7PayloadUserDataItemCpuFunctionMsgSubscription */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription;
                    
    // Simple Field (Subscription)
    uint8_t Subscription = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &Subscription);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_subscription = Subscription;


                    
    // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
    {
      uint8_t _reserved = 0;
      _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
      if(_res != OK) {
        return _res;
      }
      if(_reserved != 0x00) {
        printf("Expected constant value '%d' but got '%d' for reserved field.", 0x00, _reserved);
      }
    }


                    
    // Simple Field (magicKey)
    char* magicKey = "";
    _res = plc4c_spi_read_string(readBuffer, 64, "'UTF-8'", (char**) &magicKey);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_magic_key = magicKey;


                    
    // Optional Field (Alarmtype) (Can be skipped, if a given expression evaluates to false)
    plc4c_s7_read_write_alarm_state_type* Alarmtype = NULL;
    if((Subscription) >= (128)) {
      _res = plc4c_s7_read_write_alarm_state_type_parse(readBuffer, &Alarmtype);
      if(_res != OK) {
        return _res;
      }
      (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarmtype = Alarmtype;
    } else {
      (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarmtype = NULL;
    }


                    
    // Optional Field (Reserve) (Can be skipped, if a given expression evaluates to false)
    uint8_t* Reserve = NULL;
    if((Subscription) >= (128)) {
      Reserve = malloc(sizeof(uint8_t));
      if(Reserve == NULL) {
        return NO_MEMORY;
      }
      *Reserve = 0;
      _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) Reserve);
      if(_res != OK) {
        return _res;
      }
      (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_reserve = Reserve;
    } else {
      (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_reserve = NULL;
    }

  } else 
  if((cpuFunctionType == 0x08) && (cpuSubfunction == 0x02) && (dataLength == 0x00)) { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response;
  } else 
  if((cpuFunctionType == 0x08) && (cpuSubfunction == 0x02) && (dataLength == 0x02)) { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response;
                    
    // Simple Field (result)
    uint8_t result = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &result);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_result = result;


                    
    // Simple Field (reserved01)
    uint8_t reserved01 = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &reserved01);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_reserved01 = reserved01;

  } else 
  if((cpuFunctionType == 0x08) && (cpuSubfunction == 0x02) && (dataLength == 0x05)) { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response;
                    
    // Simple Field (result)
    uint8_t result = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &result);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_result = result;


                    
    // Simple Field (reserved01)
    uint8_t reserved01 = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &reserved01);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved01 = reserved01;


                    
    // Simple Field (alarmType)
    plc4c_s7_read_write_alarm_type* alarmType;
    _res = plc4c_s7_read_write_alarm_type_parse(readBuffer, (void*) &alarmType);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_alarm_type = *alarmType;


                    
    // Simple Field (reserved02)
    uint8_t reserved02 = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &reserved02);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved02 = reserved02;


                    
    // Simple Field (reserved03)
    uint8_t reserved03 = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &reserved03);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved03 = reserved03;

  } else 
  if((cpuFunctionType == 0x04) && (cpuSubfunction == 0x0b)) { /* S7PayloadUserDataItemCpuFunctionAlarmAck */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack;
                    
    // Simple Field (functionId)
    uint8_t functionId = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &functionId);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_ack_function_id = functionId;


                    
    // Implicit Field (numberOfObjects) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
    uint8_t numberOfObjects = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberOfObjects);
    if(_res != OK) {
      return _res;
    }


                    
    // Array field (messageObjects)
    plc4c_list* messageObjects = NULL;
    plc4c_utils_list_create(&messageObjects);
    if(messageObjects == NULL) {
      return NO_MEMORY;
    }
    {
      // Count array
      uint16_t itemCount = (uint16_t) numberOfObjects;
      for(int curItem = 0; curItem < itemCount; curItem++) {
        bool lastItem = curItem == (itemCount - 1);
        plc4c_s7_read_write_alarm_message_object_ack_type* _value = NULL;
        _res = plc4c_s7_read_write_alarm_message_object_ack_type_parse(readBuffer, (void*) &_value);
        if(_res != OK) {
          return _res;
        }
        plc4c_utils_list_insert_head_value(messageObjects, _value);
      }
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_ack_message_objects = messageObjects;

  } else 
  if((cpuFunctionType == 0x08) && (cpuSubfunction == 0x0b)) { /* S7PayloadUserDataItemCpuFunctionAlarmAckResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response;
                    
    // Simple Field (functionId)
    uint8_t functionId = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &functionId);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_ack_response_function_id = functionId;


                    
    // Implicit Field (numberOfObjects) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
    uint8_t numberOfObjects = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberOfObjects);
    if(_res != OK) {
      return _res;
    }


                    
    // Array field (messageObjects)
    plc4c_list* messageObjects = NULL;
    plc4c_utils_list_create(&messageObjects);
    if(messageObjects == NULL) {
      return NO_MEMORY;
    }
    {
      // Count array
      uint16_t itemCount = (uint16_t) numberOfObjects;
      for(int curItem = 0; curItem < itemCount; curItem++) {
        
        uint8_t* _value = malloc(sizeof(uint8_t));
        _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) _value);
        if(_res != OK) {
          return _res;
        }
        plc4c_utils_list_insert_head_value(messageObjects, _value);
      }
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects = messageObjects;

  } else 
  if((cpuFunctionType == 0x04) && (cpuSubfunction == 0x13)) { /* S7PayloadUserDataItemCpuFunctionAlarmQuery */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query;
                    
    // Const Field (functionId)
    uint8_t functionId = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &functionId);
    if(_res != OK) {
      return _res;
    }
    if(functionId != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_FUNCTION_ID()) {
      return PARSE_ERROR;
      // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_FUNCTION_ID + " but got " + functionId);
    }


                    
    // Const Field (numberMessageObj)
    uint8_t numberMessageObj = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberMessageObj);
    if(_res != OK) {
      return _res;
    }
    if(numberMessageObj != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_NUMBER_MESSAGE_OBJ()) {
      return PARSE_ERROR;
      // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_NUMBER_MESSAGE_OBJ + " but got " + numberMessageObj);
    }


                    
    // Const Field (variableSpec)
    uint8_t variableSpec = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &variableSpec);
    if(_res != OK) {
      return _res;
    }
    if(variableSpec != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_VARIABLE_SPEC()) {
      return PARSE_ERROR;
      // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_VARIABLE_SPEC + " but got " + variableSpec);
    }


                    
    // Const Field (length)
    uint8_t length = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &length);
    if(_res != OK) {
      return _res;
    }
    if(length != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_LENGTH()) {
      return PARSE_ERROR;
      // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_LENGTH + " but got " + length);
    }


                    
    // Simple Field (syntaxId)
    plc4c_s7_read_write_syntax_id_type* syntaxId;
    _res = plc4c_s7_read_write_syntax_id_type_parse(readBuffer, (void*) &syntaxId);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_syntax_id = *syntaxId;


                    
    // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
    {
      uint8_t _reserved = 0;
      _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
      if(_res != OK) {
        return _res;
      }
      if(_reserved != 0x00) {
        printf("Expected constant value '%d' but got '%d' for reserved field.", 0x00, _reserved);
      }
    }


                    
    // Simple Field (queryType)
    plc4c_s7_read_write_query_type* queryType;
    _res = plc4c_s7_read_write_query_type_parse(readBuffer, (void*) &queryType);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_query_type = *queryType;


                    
    // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
    {
      uint8_t _reserved = 0;
      _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
      if(_res != OK) {
        return _res;
      }
      if(_reserved != 0x34) {
        printf("Expected constant value '%d' but got '%d' for reserved field.", 0x34, _reserved);
      }
    }


                    
    // Simple Field (alarmType)
    plc4c_s7_read_write_alarm_type* alarmType;
    _res = plc4c_s7_read_write_alarm_type_parse(readBuffer, (void*) &alarmType);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_alarm_type = *alarmType;

  } else 
  if((cpuFunctionType == 0x08) && (cpuSubfunction == 0x13)) { /* S7PayloadUserDataItemCpuFunctionAlarmQueryResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response;
                    
    // Const Field (functionId)
    uint8_t functionId = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &functionId);
    if(_res != OK) {
      return _res;
    }
    if(functionId != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_FUNCTION_ID()) {
      return PARSE_ERROR;
      // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_FUNCTION_ID + " but got " + functionId);
    }


                    
    // Const Field (numberMessageObj)
    uint8_t numberMessageObj = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberMessageObj);
    if(_res != OK) {
      return _res;
    }
    if(numberMessageObj != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_NUMBER_MESSAGE_OBJ()) {
      return PARSE_ERROR;
      // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_NUMBER_MESSAGE_OBJ + " but got " + numberMessageObj);
    }


                    
    // Simple Field (pudicfReturnCode)
    plc4c_s7_read_write_data_transport_error_code* pudicfReturnCode;
    _res = plc4c_s7_read_write_data_transport_error_code_parse(readBuffer, (void*) &pudicfReturnCode);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_response_pudicf_return_code = *pudicfReturnCode;


                    
    // Simple Field (pudicftransportSize)
    plc4c_s7_read_write_data_transport_size* pudicftransportSize;
    _res = plc4c_s7_read_write_data_transport_size_parse(readBuffer, (void*) &pudicftransportSize);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_response_pudicftransport_size = *pudicftransportSize;


                    
    // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
    {
      uint8_t _reserved = 0;
      _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
      if(_res != OK) {
        return _res;
      }
      if(_reserved != 0x00) {
        printf("Expected constant value '%d' but got '%d' for reserved field.", 0x00, _reserved);
      }
    }

  }

  return OK;
}

plc4c_return_code plc4c_s7_read_write_s7_payload_user_data_item_serialize(plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_s7_payload_user_data_item* _message) {
  plc4c_return_code _res = OK;

  // Simple Field (returnCode)
  _res = plc4c_s7_read_write_data_transport_error_code_serialize(writeBuffer, &_message->return_code);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (transportSize)
  _res = plc4c_s7_read_write_data_transport_size_serialize(writeBuffer, &_message->transport_size);
  if(_res != OK) {
    return _res;
  }

  // Implicit Field (dataLength) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, (plc4c_s7_read_write_s7_payload_user_data_item_length_in_bytes(_message)) - (4));
  if(_res != OK) {
    return _res;
  }

  // Switch Field (Depending of the current type, serialize the sub-type elements)
  switch(_message->_type) {
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_diagnostic_message: {

      // Simple Field (EventId)
      _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_diagnostic_message_event_id);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (PriorityClass)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_diagnostic_message_priority_class);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (ObNumber)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_diagnostic_message_ob_number);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (DatId)
      _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_diagnostic_message_dat_id);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (Info1)
      _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_diagnostic_message_info1);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (Info2)
      _res = plc4c_spi_write_unsigned_int(writeBuffer, 32, _message->s7_payload_diagnostic_message_info2);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (TimeStamp)
      _res = plc4c_s7_read_write_date_and_time_serialize(writeBuffer, _message->s7_payload_diagnostic_message_time_stamp);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm8: {

      // Simple Field (alarmMessage)
      _res = plc4c_s7_read_write_alarm_message_push_type_serialize(writeBuffer, _message->s7_payload_alarm8_alarm_message);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify: {

      // Simple Field (alarmMessage)
      _res = plc4c_s7_read_write_alarm_message_push_type_serialize(writeBuffer, _message->s7_payload_notify_alarm_message);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_ack_ind: {

      // Simple Field (alarmMessage)
      _res = plc4c_s7_read_write_alarm_message_ack_push_type_serialize(writeBuffer, _message->s7_payload_alarm_ack_ind_alarm_message);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sq: {

      // Simple Field (alarmMessage)
      _res = plc4c_s7_read_write_alarm_message_push_type_serialize(writeBuffer, _message->s7_payload_alarm_sq_alarm_message);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_s: {

      // Simple Field (alarmMessage)
      _res = plc4c_s7_read_write_alarm_message_push_type_serialize(writeBuffer, _message->s7_payload_alarm_s_alarm_message);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sc: {

      // Simple Field (alarmMessage)
      _res = plc4c_s7_read_write_alarm_message_push_type_serialize(writeBuffer, _message->s7_payload_alarm_sc_alarm_message);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify8: {

      // Simple Field (alarmMessage)
      _res = plc4c_s7_read_write_alarm_message_push_type_serialize(writeBuffer, _message->s7_payload_notify8_alarm_message);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request: {

      // Simple Field (szlId)
      _res = plc4c_s7_read_write_szl_id_serialize(writeBuffer, _message->s7_payload_user_data_item_cpu_function_read_szl_request_szl_id);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (szlIndex)
      _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_user_data_item_cpu_function_read_szl_request_szl_index);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response: {

      // Simple Field (szlId)
      _res = plc4c_s7_read_write_szl_id_serialize(writeBuffer, _message->s7_payload_user_data_item_cpu_function_read_szl_response_szl_id);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (szlIndex)
      _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_user_data_item_cpu_function_read_szl_response_szl_index);
      if(_res != OK) {
        return _res;
      }

      // Const Field (szlItemLength)
      plc4c_spi_write_unsigned_short(writeBuffer, 16, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_READ_SZL_RESPONSE_SZL_ITEM_LENGTH());

      // Implicit Field (szlItemCount) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
      _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, plc4c_spi_evaluation_helper_count(_message->s7_payload_user_data_item_cpu_function_read_szl_response_items));
      if(_res != OK) {
        return _res;
      }

      // Array field (items)
      {
        uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_read_szl_response_items);
        for(int curItem = 0; curItem < itemCount; curItem++) {
          bool lastItem = curItem == (itemCount - 1);
          plc4c_s7_read_write_szl_data_tree_item* _value = (plc4c_s7_read_write_szl_data_tree_item*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cpu_function_read_szl_response_items, curItem);
          _res = plc4c_s7_read_write_szl_data_tree_item_serialize(writeBuffer, (void*) _value);
          if(_res != OK) {
            return _res;
          }
        }
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription: {

      // Simple Field (Subscription)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_subscription);
      if(_res != OK) {
        return _res;
      }

      // Reserved Field
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x00);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (magicKey)
      _res = plc4c_spi_write_string(writeBuffer, 64, "'UTF-8'", _message->s7_payload_user_data_item_cpu_function_msg_subscription_magic_key);
      if(_res != OK) {
        return _res;
      }

      // Optional Field (Alarmtype)
      if(_message->s7_payload_user_data_item_cpu_function_msg_subscription_alarmtype != NULL) {
        _res = plc4c_s7_read_write_alarm_state_type_serialize(writeBuffer, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarmtype);
        if(_res != OK) {
          return _res;
        }
      }

      // Optional Field (Reserve)
      if(_message->s7_payload_user_data_item_cpu_function_msg_subscription_reserve != NULL) {
        _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, *_message->s7_payload_user_data_item_cpu_function_msg_subscription_reserve);
        if(_res != OK) {
          return _res;
        }
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response: {

      // Simple Field (result)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_result);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (reserved01)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_reserved01);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response: {

      // Simple Field (result)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_result);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (reserved01)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved01);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (alarmType)
      _res = plc4c_s7_read_write_alarm_type_serialize(writeBuffer, &_message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_alarm_type);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (reserved02)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved02);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (reserved03)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved03);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack: {

      // Simple Field (functionId)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_alarm_ack_function_id);
      if(_res != OK) {
        return _res;
      }

      // Implicit Field (numberOfObjects) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, plc4c_spi_evaluation_helper_count(_message->s7_payload_user_data_item_cpu_function_alarm_ack_message_objects));
      if(_res != OK) {
        return _res;
      }

      // Array field (messageObjects)
      {
        uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_ack_message_objects);
        for(int curItem = 0; curItem < itemCount; curItem++) {
          bool lastItem = curItem == (itemCount - 1);
          plc4c_s7_read_write_alarm_message_object_ack_type* _value = (plc4c_s7_read_write_alarm_message_object_ack_type*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cpu_function_alarm_ack_message_objects, curItem);
          _res = plc4c_s7_read_write_alarm_message_object_ack_type_serialize(writeBuffer, (void*) _value);
          if(_res != OK) {
            return _res;
          }
        }
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response: {

      // Simple Field (functionId)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_alarm_ack_response_function_id);
      if(_res != OK) {
        return _res;
      }

      // Implicit Field (numberOfObjects) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, plc4c_spi_evaluation_helper_count(_message->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects));
      if(_res != OK) {
        return _res;
      }

      // Array field (messageObjects)
      {
        uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects);
        for(int curItem = 0; curItem < itemCount; curItem++) {

          uint8_t* _value = (uint8_t*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects, curItem);
          plc4c_spi_write_unsigned_byte(writeBuffer, 8, *_value);
        }
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query: {

      // Const Field (functionId)
      plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_FUNCTION_ID());

      // Const Field (numberMessageObj)
      plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_NUMBER_MESSAGE_OBJ());

      // Const Field (variableSpec)
      plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_VARIABLE_SPEC());

      // Const Field (length)
      plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_LENGTH());

      // Simple Field (syntaxId)
      _res = plc4c_s7_read_write_syntax_id_type_serialize(writeBuffer, &_message->s7_payload_user_data_item_cpu_function_alarm_query_syntax_id);
      if(_res != OK) {
        return _res;
      }

      // Reserved Field
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x00);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (queryType)
      _res = plc4c_s7_read_write_query_type_serialize(writeBuffer, &_message->s7_payload_user_data_item_cpu_function_alarm_query_query_type);
      if(_res != OK) {
        return _res;
      }

      // Reserved Field
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x34);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (alarmType)
      _res = plc4c_s7_read_write_alarm_type_serialize(writeBuffer, &_message->s7_payload_user_data_item_cpu_function_alarm_query_alarm_type);
      if(_res != OK) {
        return _res;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response: {

      // Const Field (functionId)
      plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_FUNCTION_ID());

      // Const Field (numberMessageObj)
      plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_RESPONSE_NUMBER_MESSAGE_OBJ());

      // Simple Field (pudicfReturnCode)
      _res = plc4c_s7_read_write_data_transport_error_code_serialize(writeBuffer, &_message->s7_payload_user_data_item_cpu_function_alarm_query_response_pudicf_return_code);
      if(_res != OK) {
        return _res;
      }

      // Simple Field (pudicftransportSize)
      _res = plc4c_s7_read_write_data_transport_size_serialize(writeBuffer, &_message->s7_payload_user_data_item_cpu_function_alarm_query_response_pudicftransport_size);
      if(_res != OK) {
        return _res;
      }

      // Reserved Field
      _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x00);
      if(_res != OK) {
        return _res;
      }

      break;
    }
  }

  return OK;
}

uint16_t plc4c_s7_read_write_s7_payload_user_data_item_length_in_bytes(plc4c_s7_read_write_s7_payload_user_data_item* _message) {
  return plc4c_s7_read_write_s7_payload_user_data_item_length_in_bits(_message) / 8;
}

uint16_t plc4c_s7_read_write_s7_payload_user_data_item_length_in_bits(plc4c_s7_read_write_s7_payload_user_data_item* _message) {
  uint16_t lengthInBits = 0;

  // Simple field (returnCode)
  lengthInBits += plc4c_s7_read_write_data_transport_error_code_length_in_bits(&_message->return_code);

  // Simple field (transportSize)
  lengthInBits += plc4c_s7_read_write_data_transport_size_length_in_bits(&_message->transport_size);

  // Implicit Field (dataLength)
  lengthInBits += 16;

  // Depending of the current type, add the length of sub-type elements ...
  switch(_message->_type) {
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_diagnostic_message: {

      // Simple field (EventId)
      lengthInBits += 16;


      // Simple field (PriorityClass)
      lengthInBits += 8;


      // Simple field (ObNumber)
      lengthInBits += 8;


      // Simple field (DatId)
      lengthInBits += 16;


      // Simple field (Info1)
      lengthInBits += 16;


      // Simple field (Info2)
      lengthInBits += 32;


      // Simple field (TimeStamp)
      lengthInBits += plc4c_s7_read_write_date_and_time_length_in_bits(_message->s7_payload_diagnostic_message_time_stamp);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm8: {

      // Simple field (alarmMessage)
      lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(_message->s7_payload_alarm8_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify: {

      // Simple field (alarmMessage)
      lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(_message->s7_payload_notify_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_ack_ind: {

      // Simple field (alarmMessage)
      lengthInBits += plc4c_s7_read_write_alarm_message_ack_push_type_length_in_bits(_message->s7_payload_alarm_ack_ind_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sq: {

      // Simple field (alarmMessage)
      lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(_message->s7_payload_alarm_sq_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_s: {

      // Simple field (alarmMessage)
      lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(_message->s7_payload_alarm_s_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sc: {

      // Simple field (alarmMessage)
      lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(_message->s7_payload_alarm_sc_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify8: {

      // Simple field (alarmMessage)
      lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(_message->s7_payload_notify8_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request: {

      // Simple field (szlId)
      lengthInBits += plc4c_s7_read_write_szl_id_length_in_bits(_message->s7_payload_user_data_item_cpu_function_read_szl_request_szl_id);


      // Simple field (szlIndex)
      lengthInBits += 16;

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response: {

      // Simple field (szlId)
      lengthInBits += plc4c_s7_read_write_szl_id_length_in_bits(_message->s7_payload_user_data_item_cpu_function_read_szl_response_szl_id);


      // Simple field (szlIndex)
      lengthInBits += 16;


      // Const Field (szlItemLength)
      lengthInBits += 16;


      // Implicit Field (szlItemCount)
      lengthInBits += 16;


      // Array field
      if(_message->s7_payload_user_data_item_cpu_function_read_szl_response_items != NULL) {
        plc4c_list_element* curElement = _message->s7_payload_user_data_item_cpu_function_read_szl_response_items->tail;
        while (curElement != NULL) {
          lengthInBits += plc4c_s7_read_write_szl_data_tree_item_length_in_bits((plc4c_s7_read_write_szl_data_tree_item*) curElement->value);
          curElement = curElement->next;
        }
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription: {

      // Simple field (Subscription)
      lengthInBits += 8;


      // Reserved Field (reserved)
      lengthInBits += 8;


      // Simple field (magicKey)
      lengthInBits += -1;


      // Optional Field (Alarmtype)
      if(_message->s7_payload_user_data_item_cpu_function_msg_subscription_alarmtype != NULL) {
        lengthInBits += plc4c_s7_read_write_alarm_state_type_length_in_bits(_message->s7_payload_user_data_item_cpu_function_msg_subscription_alarmtype);
      }


      // Optional Field (Reserve)
      if(_message->s7_payload_user_data_item_cpu_function_msg_subscription_reserve != NULL) {
        lengthInBits += 8;
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response: {

      // Simple field (result)
      lengthInBits += 8;


      // Simple field (reserved01)
      lengthInBits += 8;

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response: {

      // Simple field (result)
      lengthInBits += 8;


      // Simple field (reserved01)
      lengthInBits += 8;


      // Simple field (alarmType)
      lengthInBits += plc4c_s7_read_write_alarm_type_length_in_bits(&_message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_alarm_type);


      // Simple field (reserved02)
      lengthInBits += 8;


      // Simple field (reserved03)
      lengthInBits += 8;

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack: {

      // Simple field (functionId)
      lengthInBits += 8;


      // Implicit Field (numberOfObjects)
      lengthInBits += 8;


      // Array field
      if(_message->s7_payload_user_data_item_cpu_function_alarm_ack_message_objects != NULL) {
        plc4c_list_element* curElement = _message->s7_payload_user_data_item_cpu_function_alarm_ack_message_objects->tail;
        while (curElement != NULL) {
          lengthInBits += plc4c_s7_read_write_alarm_message_object_ack_type_length_in_bits((plc4c_s7_read_write_alarm_message_object_ack_type*) curElement->value);
          curElement = curElement->next;
        }
      }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response: {

      // Simple field (functionId)
      lengthInBits += 8;


      // Implicit Field (numberOfObjects)
      lengthInBits += 8;


      // Array field
      lengthInBits += 8 * plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query: {

      // Const Field (functionId)
      lengthInBits += 8;


      // Const Field (numberMessageObj)
      lengthInBits += 8;


      // Const Field (variableSpec)
      lengthInBits += 8;


      // Const Field (length)
      lengthInBits += 8;


      // Simple field (syntaxId)
      lengthInBits += plc4c_s7_read_write_syntax_id_type_length_in_bits(&_message->s7_payload_user_data_item_cpu_function_alarm_query_syntax_id);


      // Reserved Field (reserved)
      lengthInBits += 8;


      // Simple field (queryType)
      lengthInBits += plc4c_s7_read_write_query_type_length_in_bits(&_message->s7_payload_user_data_item_cpu_function_alarm_query_query_type);


      // Reserved Field (reserved)
      lengthInBits += 8;


      // Simple field (alarmType)
      lengthInBits += plc4c_s7_read_write_alarm_type_length_in_bits(&_message->s7_payload_user_data_item_cpu_function_alarm_query_alarm_type);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response: {

      // Const Field (functionId)
      lengthInBits += 8;


      // Const Field (numberMessageObj)
      lengthInBits += 8;


      // Simple field (pudicfReturnCode)
      lengthInBits += plc4c_s7_read_write_data_transport_error_code_length_in_bits(&_message->s7_payload_user_data_item_cpu_function_alarm_query_response_pudicf_return_code);


      // Simple field (pudicftransportSize)
      lengthInBits += plc4c_s7_read_write_data_transport_size_length_in_bits(&_message->s7_payload_user_data_item_cpu_function_alarm_query_response_pudicftransport_size);


      // Reserved Field (reserved)
      lengthInBits += 8;

      break;
    }
  }

  return lengthInBits;
}

