/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TelephonyDataRinging extends TelephonyData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final String number;

  // Reserved Fields
  private Byte reservedField0;

  public TelephonyDataRinging(
      TelephonyCommandTypeContainer commandTypeContainer, byte argument, String number) {
    super(commandTypeContainer, argument);
    this.number = number;
  }

  public String getNumber() {
    return number;
  }

  @Override
  protected void serializeTelephonyDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TelephonyDataRinging");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0x01,
        writeByte(writeBuffer, 8));

    // Simple Field (number)
    writeSimpleField(
        "number",
        number,
        writeString(writeBuffer, (((commandTypeContainer.getNumBytes()) - (2))) * (8)));

    writeBuffer.popContext("TelephonyDataRinging");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TelephonyDataRinging _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (number)
    lengthInBits += (((commandTypeContainer.getNumBytes()) - (2))) * (8);

    return lengthInBits;
  }

  public static TelephonyDataBuilder staticParseTelephonyDataBuilder(
      ReadBuffer readBuffer, TelephonyCommandTypeContainer commandTypeContainer)
      throws ParseException {
    readBuffer.pullContext("TelephonyDataRinging");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Byte reservedField0 = readReservedField("reserved", readByte(readBuffer, 8), (byte) 0x01);

    String number =
        readSimpleField(
            "number", readString(readBuffer, (((commandTypeContainer.getNumBytes()) - (2))) * (8)));

    readBuffer.closeContext("TelephonyDataRinging");
    // Create the instance
    return new TelephonyDataRingingBuilderImpl(number, reservedField0);
  }

  public static class TelephonyDataRingingBuilderImpl
      implements TelephonyData.TelephonyDataBuilder {
    private final String number;
    private final Byte reservedField0;

    public TelephonyDataRingingBuilderImpl(String number, Byte reservedField0) {
      this.number = number;
      this.reservedField0 = reservedField0;
    }

    public TelephonyDataRinging build(
        TelephonyCommandTypeContainer commandTypeContainer, byte argument) {
      TelephonyDataRinging telephonyDataRinging =
          new TelephonyDataRinging(commandTypeContainer, argument, number);
      telephonyDataRinging.reservedField0 = reservedField0;
      return telephonyDataRinging;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TelephonyDataRinging)) {
      return false;
    }
    TelephonyDataRinging that = (TelephonyDataRinging) o;
    return (getNumber() == that.getNumber()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
