/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class LogRecordsDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19747;
  }

  // Properties.
  protected final List<LogRecord> logRecordArray;

  public LogRecordsDataType(List<LogRecord> logRecordArray) {
    super();
    this.logRecordArray = logRecordArray;
  }

  public List<LogRecord> getLogRecordArray() {
    return logRecordArray;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("LogRecordsDataType");

    // Implicit Field (noOfLogRecordArray) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfLogRecordArray =
        (int) ((((getLogRecordArray()) == (null)) ? -(1) : COUNT(getLogRecordArray())));
    writeImplicitField("noOfLogRecordArray", noOfLogRecordArray, writeSignedInt(writeBuffer, 32));

    // Array Field (logRecordArray)
    writeComplexTypeArrayField("logRecordArray", logRecordArray, writeBuffer);

    writeBuffer.popContext("LogRecordsDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    LogRecordsDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (noOfLogRecordArray)
    lengthInBits += 32;

    // Array field
    if (logRecordArray != null) {
      int i = 0;
      for (LogRecord element : logRecordArray) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= logRecordArray.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("LogRecordsDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int noOfLogRecordArray = readImplicitField("noOfLogRecordArray", readSignedInt(readBuffer, 32));

    List<LogRecord> logRecordArray =
        readCountArrayField(
            "logRecordArray",
            readComplex(
                () -> (LogRecord) ExtensionObjectDefinition.staticParse(readBuffer, (int) (19363)),
                readBuffer),
            noOfLogRecordArray);

    readBuffer.closeContext("LogRecordsDataType");
    // Create the instance
    return new LogRecordsDataTypeBuilderImpl(logRecordArray);
  }

  public static class LogRecordsDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final List<LogRecord> logRecordArray;

    public LogRecordsDataTypeBuilderImpl(List<LogRecord> logRecordArray) {
      this.logRecordArray = logRecordArray;
    }

    public LogRecordsDataType build() {
      LogRecordsDataType logRecordsDataType = new LogRecordsDataType(logRecordArray);
      return logRecordsDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LogRecordsDataType)) {
      return false;
    }
    LogRecordsDataType that = (LogRecordsDataType) o;
    return (getLogRecordArray() == that.getLogRecordArray()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getLogRecordArray());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
