/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetPropertyAccessResultAccessResultPropertyValue
    extends BACnetPropertyAccessResultAccessResult implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetConstructedData propertyValue;

  // Arguments.
  protected final BACnetObjectType objectTypeArgument;
  protected final BACnetPropertyIdentifier propertyIdentifierArgument;
  protected final BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument;

  public BACnetPropertyAccessResultAccessResultPropertyValue(
      BACnetTagHeader peekedTagHeader,
      BACnetConstructedData propertyValue,
      BACnetObjectType objectTypeArgument,
      BACnetPropertyIdentifier propertyIdentifierArgument,
      BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument) {
    super(
        peekedTagHeader,
        objectTypeArgument,
        propertyIdentifierArgument,
        propertyArrayIndexArgument);
    this.propertyValue = propertyValue;
    this.objectTypeArgument = objectTypeArgument;
    this.propertyIdentifierArgument = propertyIdentifierArgument;
    this.propertyArrayIndexArgument = propertyArrayIndexArgument;
  }

  public BACnetConstructedData getPropertyValue() {
    return propertyValue;
  }

  @Override
  protected void serializeBACnetPropertyAccessResultAccessResultChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetPropertyAccessResultAccessResultPropertyValue");

    // Simple Field (propertyValue)
    writeSimpleField("propertyValue", propertyValue, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetPropertyAccessResultAccessResultPropertyValue");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetPropertyAccessResultAccessResultPropertyValue _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (propertyValue)
    lengthInBits += propertyValue.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetPropertyAccessResultAccessResultBuilder
      staticParseBACnetPropertyAccessResultAccessResultBuilder(
          ReadBuffer readBuffer,
          BACnetObjectType objectTypeArgument,
          BACnetPropertyIdentifier propertyIdentifierArgument,
          BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument)
          throws ParseException {
    readBuffer.pullContext("BACnetPropertyAccessResultAccessResultPropertyValue");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetConstructedData propertyValue =
        readSimpleField(
            "propertyValue",
            readComplex(
                () ->
                    BACnetConstructedData.staticParse(
                        readBuffer,
                        (short) (4),
                        (BACnetObjectType) (objectTypeArgument),
                        (BACnetPropertyIdentifier) (propertyIdentifierArgument),
                        (BACnetTagPayloadUnsignedInteger) (propertyArrayIndexArgument)),
                readBuffer));

    readBuffer.closeContext("BACnetPropertyAccessResultAccessResultPropertyValue");
    // Create the instance
    return new BACnetPropertyAccessResultAccessResultPropertyValueBuilderImpl(
        propertyValue, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument);
  }

  public static class BACnetPropertyAccessResultAccessResultPropertyValueBuilderImpl
      implements BACnetPropertyAccessResultAccessResult
          .BACnetPropertyAccessResultAccessResultBuilder {
    private final BACnetConstructedData propertyValue;
    private final BACnetObjectType objectTypeArgument;
    private final BACnetPropertyIdentifier propertyIdentifierArgument;
    private final BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument;

    public BACnetPropertyAccessResultAccessResultPropertyValueBuilderImpl(
        BACnetConstructedData propertyValue,
        BACnetObjectType objectTypeArgument,
        BACnetPropertyIdentifier propertyIdentifierArgument,
        BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument) {
      this.propertyValue = propertyValue;
      this.objectTypeArgument = objectTypeArgument;
      this.propertyIdentifierArgument = propertyIdentifierArgument;
      this.propertyArrayIndexArgument = propertyArrayIndexArgument;
    }

    public BACnetPropertyAccessResultAccessResultPropertyValue build(
        BACnetTagHeader peekedTagHeader,
        BACnetObjectType objectTypeArgument,
        BACnetPropertyIdentifier propertyIdentifierArgument,
        BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument) {
      BACnetPropertyAccessResultAccessResultPropertyValue
          bACnetPropertyAccessResultAccessResultPropertyValue =
              new BACnetPropertyAccessResultAccessResultPropertyValue(
                  peekedTagHeader,
                  propertyValue,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  propertyArrayIndexArgument);
      return bACnetPropertyAccessResultAccessResultPropertyValue;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetPropertyAccessResultAccessResultPropertyValue)) {
      return false;
    }
    BACnetPropertyAccessResultAccessResultPropertyValue that =
        (BACnetPropertyAccessResultAccessResultPropertyValue) o;
    return (getPropertyValue() == that.getPropertyValue()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPropertyValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
