/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7PayloadUserDataItemClkRequest is the corresponding interface of S7PayloadUserDataItemClkRequest
type S7PayloadUserDataItemClkRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	S7PayloadUserDataItem
	// IsS7PayloadUserDataItemClkRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7PayloadUserDataItemClkRequest()
	// CreateBuilder creates a S7PayloadUserDataItemClkRequestBuilder
	CreateS7PayloadUserDataItemClkRequestBuilder() S7PayloadUserDataItemClkRequestBuilder
}

// _S7PayloadUserDataItemClkRequest is the data-structure of this message
type _S7PayloadUserDataItemClkRequest struct {
	S7PayloadUserDataItemContract
}

var _ S7PayloadUserDataItemClkRequest = (*_S7PayloadUserDataItemClkRequest)(nil)
var _ S7PayloadUserDataItemRequirements = (*_S7PayloadUserDataItemClkRequest)(nil)

// NewS7PayloadUserDataItemClkRequest factory function for _S7PayloadUserDataItemClkRequest
func NewS7PayloadUserDataItemClkRequest(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16) *_S7PayloadUserDataItemClkRequest {
	_result := &_S7PayloadUserDataItemClkRequest{
		S7PayloadUserDataItemContract: NewS7PayloadUserDataItem(returnCode, transportSize, dataLength),
	}
	_result.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7PayloadUserDataItemClkRequestBuilder is a builder for S7PayloadUserDataItemClkRequest
type S7PayloadUserDataItemClkRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() S7PayloadUserDataItemClkRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() S7PayloadUserDataItemBuilder
	// Build builds the S7PayloadUserDataItemClkRequest or returns an error if something is wrong
	Build() (S7PayloadUserDataItemClkRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7PayloadUserDataItemClkRequest
}

// NewS7PayloadUserDataItemClkRequestBuilder() creates a S7PayloadUserDataItemClkRequestBuilder
func NewS7PayloadUserDataItemClkRequestBuilder() S7PayloadUserDataItemClkRequestBuilder {
	return &_S7PayloadUserDataItemClkRequestBuilder{_S7PayloadUserDataItemClkRequest: new(_S7PayloadUserDataItemClkRequest)}
}

type _S7PayloadUserDataItemClkRequestBuilder struct {
	*_S7PayloadUserDataItemClkRequest

	parentBuilder *_S7PayloadUserDataItemBuilder

	err *utils.MultiError
}

var _ (S7PayloadUserDataItemClkRequestBuilder) = (*_S7PayloadUserDataItemClkRequestBuilder)(nil)

func (b *_S7PayloadUserDataItemClkRequestBuilder) setParent(contract S7PayloadUserDataItemContract) {
	b.S7PayloadUserDataItemContract = contract
	contract.(*_S7PayloadUserDataItem)._SubType = b._S7PayloadUserDataItemClkRequest
}

func (b *_S7PayloadUserDataItemClkRequestBuilder) WithMandatoryFields() S7PayloadUserDataItemClkRequestBuilder {
	return b
}

func (b *_S7PayloadUserDataItemClkRequestBuilder) Build() (S7PayloadUserDataItemClkRequest, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._S7PayloadUserDataItemClkRequest.deepCopy(), nil
}

func (b *_S7PayloadUserDataItemClkRequestBuilder) MustBuild() S7PayloadUserDataItemClkRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7PayloadUserDataItemClkRequestBuilder) Done() S7PayloadUserDataItemBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewS7PayloadUserDataItemBuilder().(*_S7PayloadUserDataItemBuilder)
	}
	return b.parentBuilder
}

func (b *_S7PayloadUserDataItemClkRequestBuilder) buildForS7PayloadUserDataItem() (S7PayloadUserDataItem, error) {
	return b.Build()
}

func (b *_S7PayloadUserDataItemClkRequestBuilder) DeepCopy() any {
	_copy := b.CreateS7PayloadUserDataItemClkRequestBuilder().(*_S7PayloadUserDataItemClkRequestBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateS7PayloadUserDataItemClkRequestBuilder creates a S7PayloadUserDataItemClkRequestBuilder
func (b *_S7PayloadUserDataItemClkRequest) CreateS7PayloadUserDataItemClkRequestBuilder() S7PayloadUserDataItemClkRequestBuilder {
	if b == nil {
		return NewS7PayloadUserDataItemClkRequestBuilder()
	}
	return &_S7PayloadUserDataItemClkRequestBuilder{_S7PayloadUserDataItemClkRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7PayloadUserDataItemClkRequest) GetCpuFunctionGroup() uint8 {
	return 0x07
}

func (m *_S7PayloadUserDataItemClkRequest) GetCpuFunctionType() uint8 {
	return 0x04
}

func (m *_S7PayloadUserDataItemClkRequest) GetCpuSubfunction() uint8 {
	return 0x01
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7PayloadUserDataItemClkRequest) GetParent() S7PayloadUserDataItemContract {
	return m.S7PayloadUserDataItemContract
}

// Deprecated: use the interface for direct cast
func CastS7PayloadUserDataItemClkRequest(structType any) S7PayloadUserDataItemClkRequest {
	if casted, ok := structType.(S7PayloadUserDataItemClkRequest); ok {
		return casted
	}
	if casted, ok := structType.(*S7PayloadUserDataItemClkRequest); ok {
		return *casted
	}
	return nil
}

func (m *_S7PayloadUserDataItemClkRequest) GetTypeName() string {
	return "S7PayloadUserDataItemClkRequest"
}

func (m *_S7PayloadUserDataItemClkRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_S7PayloadUserDataItemClkRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_S7PayloadUserDataItemClkRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_S7PayloadUserDataItem, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (__s7PayloadUserDataItemClkRequest S7PayloadUserDataItemClkRequest, err error) {
	m.S7PayloadUserDataItemContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7PayloadUserDataItemClkRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7PayloadUserDataItemClkRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("S7PayloadUserDataItemClkRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7PayloadUserDataItemClkRequest")
	}

	return m, nil
}

func (m *_S7PayloadUserDataItemClkRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7PayloadUserDataItemClkRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7PayloadUserDataItemClkRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7PayloadUserDataItemClkRequest")
		}

		if popErr := writeBuffer.PopContext("S7PayloadUserDataItemClkRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7PayloadUserDataItemClkRequest")
		}
		return nil
	}
	return m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7PayloadUserDataItemClkRequest) IsS7PayloadUserDataItemClkRequest() {}

func (m *_S7PayloadUserDataItemClkRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7PayloadUserDataItemClkRequest) deepCopy() *_S7PayloadUserDataItemClkRequest {
	if m == nil {
		return nil
	}
	_S7PayloadUserDataItemClkRequestCopy := &_S7PayloadUserDataItemClkRequest{
		m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).deepCopy(),
	}
	_S7PayloadUserDataItemClkRequestCopy.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = m
	return _S7PayloadUserDataItemClkRequestCopy
}

func (m *_S7PayloadUserDataItemClkRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
