/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// WriterGroupTransportDataType is the corresponding interface of WriterGroupTransportDataType
type WriterGroupTransportDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsWriterGroupTransportDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsWriterGroupTransportDataType()
	// CreateBuilder creates a WriterGroupTransportDataTypeBuilder
	CreateWriterGroupTransportDataTypeBuilder() WriterGroupTransportDataTypeBuilder
}

// _WriterGroupTransportDataType is the data-structure of this message
type _WriterGroupTransportDataType struct {
	ExtensionObjectDefinitionContract
}

var _ WriterGroupTransportDataType = (*_WriterGroupTransportDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_WriterGroupTransportDataType)(nil)

// NewWriterGroupTransportDataType factory function for _WriterGroupTransportDataType
func NewWriterGroupTransportDataType() *_WriterGroupTransportDataType {
	_result := &_WriterGroupTransportDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// WriterGroupTransportDataTypeBuilder is a builder for WriterGroupTransportDataType
type WriterGroupTransportDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() WriterGroupTransportDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the WriterGroupTransportDataType or returns an error if something is wrong
	Build() (WriterGroupTransportDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() WriterGroupTransportDataType
}

// NewWriterGroupTransportDataTypeBuilder() creates a WriterGroupTransportDataTypeBuilder
func NewWriterGroupTransportDataTypeBuilder() WriterGroupTransportDataTypeBuilder {
	return &_WriterGroupTransportDataTypeBuilder{_WriterGroupTransportDataType: new(_WriterGroupTransportDataType)}
}

type _WriterGroupTransportDataTypeBuilder struct {
	*_WriterGroupTransportDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (WriterGroupTransportDataTypeBuilder) = (*_WriterGroupTransportDataTypeBuilder)(nil)

func (b *_WriterGroupTransportDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._WriterGroupTransportDataType
}

func (b *_WriterGroupTransportDataTypeBuilder) WithMandatoryFields() WriterGroupTransportDataTypeBuilder {
	return b
}

func (b *_WriterGroupTransportDataTypeBuilder) Build() (WriterGroupTransportDataType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._WriterGroupTransportDataType.deepCopy(), nil
}

func (b *_WriterGroupTransportDataTypeBuilder) MustBuild() WriterGroupTransportDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_WriterGroupTransportDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_WriterGroupTransportDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_WriterGroupTransportDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateWriterGroupTransportDataTypeBuilder().(*_WriterGroupTransportDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateWriterGroupTransportDataTypeBuilder creates a WriterGroupTransportDataTypeBuilder
func (b *_WriterGroupTransportDataType) CreateWriterGroupTransportDataTypeBuilder() WriterGroupTransportDataTypeBuilder {
	if b == nil {
		return NewWriterGroupTransportDataTypeBuilder()
	}
	return &_WriterGroupTransportDataTypeBuilder{_WriterGroupTransportDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_WriterGroupTransportDataType) GetExtensionId() int32 {
	return int32(15613)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_WriterGroupTransportDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastWriterGroupTransportDataType(structType any) WriterGroupTransportDataType {
	if casted, ok := structType.(WriterGroupTransportDataType); ok {
		return casted
	}
	if casted, ok := structType.(*WriterGroupTransportDataType); ok {
		return *casted
	}
	return nil
}

func (m *_WriterGroupTransportDataType) GetTypeName() string {
	return "WriterGroupTransportDataType"
}

func (m *_WriterGroupTransportDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_WriterGroupTransportDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_WriterGroupTransportDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__writerGroupTransportDataType WriterGroupTransportDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("WriterGroupTransportDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for WriterGroupTransportDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("WriterGroupTransportDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for WriterGroupTransportDataType")
	}

	return m, nil
}

func (m *_WriterGroupTransportDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_WriterGroupTransportDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("WriterGroupTransportDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for WriterGroupTransportDataType")
		}

		if popErr := writeBuffer.PopContext("WriterGroupTransportDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for WriterGroupTransportDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_WriterGroupTransportDataType) IsWriterGroupTransportDataType() {}

func (m *_WriterGroupTransportDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_WriterGroupTransportDataType) deepCopy() *_WriterGroupTransportDataType {
	if m == nil {
		return nil
	}
	_WriterGroupTransportDataTypeCopy := &_WriterGroupTransportDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_WriterGroupTransportDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _WriterGroupTransportDataTypeCopy
}

func (m *_WriterGroupTransportDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
