/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// WriterGroupDataType is the corresponding interface of WriterGroupDataType
type WriterGroupDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetEnabled returns Enabled (property field)
	GetEnabled() bool
	// GetSecurityMode returns SecurityMode (property field)
	GetSecurityMode() MessageSecurityMode
	// GetSecurityGroupId returns SecurityGroupId (property field)
	GetSecurityGroupId() PascalString
	// GetSecurityKeyServices returns SecurityKeyServices (property field)
	GetSecurityKeyServices() []EndpointDescription
	// GetMaxNetworkMessageSize returns MaxNetworkMessageSize (property field)
	GetMaxNetworkMessageSize() uint32
	// GetGroupProperties returns GroupProperties (property field)
	GetGroupProperties() []KeyValuePair
	// GetWriterGroupId returns WriterGroupId (property field)
	GetWriterGroupId() uint16
	// GetPublishingInterval returns PublishingInterval (property field)
	GetPublishingInterval() float64
	// GetKeepAliveTime returns KeepAliveTime (property field)
	GetKeepAliveTime() float64
	// GetPriority returns Priority (property field)
	GetPriority() uint8
	// GetLocaleIds returns LocaleIds (property field)
	GetLocaleIds() []PascalString
	// GetHeaderLayoutUri returns HeaderLayoutUri (property field)
	GetHeaderLayoutUri() PascalString
	// GetTransportSettings returns TransportSettings (property field)
	GetTransportSettings() ExtensionObject
	// GetMessageSettings returns MessageSettings (property field)
	GetMessageSettings() ExtensionObject
	// GetDataSetWriters returns DataSetWriters (property field)
	GetDataSetWriters() []DataSetWriterDataType
	// IsWriterGroupDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsWriterGroupDataType()
	// CreateBuilder creates a WriterGroupDataTypeBuilder
	CreateWriterGroupDataTypeBuilder() WriterGroupDataTypeBuilder
}

// _WriterGroupDataType is the data-structure of this message
type _WriterGroupDataType struct {
	ExtensionObjectDefinitionContract
	Name                  PascalString
	Enabled               bool
	SecurityMode          MessageSecurityMode
	SecurityGroupId       PascalString
	SecurityKeyServices   []EndpointDescription
	MaxNetworkMessageSize uint32
	GroupProperties       []KeyValuePair
	WriterGroupId         uint16
	PublishingInterval    float64
	KeepAliveTime         float64
	Priority              uint8
	LocaleIds             []PascalString
	HeaderLayoutUri       PascalString
	TransportSettings     ExtensionObject
	MessageSettings       ExtensionObject
	DataSetWriters        []DataSetWriterDataType
	// Reserved Fields
	reservedField0 *uint8
}

var _ WriterGroupDataType = (*_WriterGroupDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_WriterGroupDataType)(nil)

// NewWriterGroupDataType factory function for _WriterGroupDataType
func NewWriterGroupDataType(name PascalString, enabled bool, securityMode MessageSecurityMode, securityGroupId PascalString, securityKeyServices []EndpointDescription, maxNetworkMessageSize uint32, groupProperties []KeyValuePair, writerGroupId uint16, publishingInterval float64, keepAliveTime float64, priority uint8, localeIds []PascalString, headerLayoutUri PascalString, transportSettings ExtensionObject, messageSettings ExtensionObject, dataSetWriters []DataSetWriterDataType) *_WriterGroupDataType {
	if name == nil {
		panic("name of type PascalString for WriterGroupDataType must not be nil")
	}
	if securityGroupId == nil {
		panic("securityGroupId of type PascalString for WriterGroupDataType must not be nil")
	}
	if headerLayoutUri == nil {
		panic("headerLayoutUri of type PascalString for WriterGroupDataType must not be nil")
	}
	if transportSettings == nil {
		panic("transportSettings of type ExtensionObject for WriterGroupDataType must not be nil")
	}
	if messageSettings == nil {
		panic("messageSettings of type ExtensionObject for WriterGroupDataType must not be nil")
	}
	_result := &_WriterGroupDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		Enabled:                           enabled,
		SecurityMode:                      securityMode,
		SecurityGroupId:                   securityGroupId,
		SecurityKeyServices:               securityKeyServices,
		MaxNetworkMessageSize:             maxNetworkMessageSize,
		GroupProperties:                   groupProperties,
		WriterGroupId:                     writerGroupId,
		PublishingInterval:                publishingInterval,
		KeepAliveTime:                     keepAliveTime,
		Priority:                          priority,
		LocaleIds:                         localeIds,
		HeaderLayoutUri:                   headerLayoutUri,
		TransportSettings:                 transportSettings,
		MessageSettings:                   messageSettings,
		DataSetWriters:                    dataSetWriters,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// WriterGroupDataTypeBuilder is a builder for WriterGroupDataType
type WriterGroupDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, enabled bool, securityMode MessageSecurityMode, securityGroupId PascalString, securityKeyServices []EndpointDescription, maxNetworkMessageSize uint32, groupProperties []KeyValuePair, writerGroupId uint16, publishingInterval float64, keepAliveTime float64, priority uint8, localeIds []PascalString, headerLayoutUri PascalString, transportSettings ExtensionObject, messageSettings ExtensionObject, dataSetWriters []DataSetWriterDataType) WriterGroupDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) WriterGroupDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) WriterGroupDataTypeBuilder
	// WithEnabled adds Enabled (property field)
	WithEnabled(bool) WriterGroupDataTypeBuilder
	// WithSecurityMode adds SecurityMode (property field)
	WithSecurityMode(MessageSecurityMode) WriterGroupDataTypeBuilder
	// WithSecurityGroupId adds SecurityGroupId (property field)
	WithSecurityGroupId(PascalString) WriterGroupDataTypeBuilder
	// WithSecurityGroupIdBuilder adds SecurityGroupId (property field) which is build by the builder
	WithSecurityGroupIdBuilder(func(PascalStringBuilder) PascalStringBuilder) WriterGroupDataTypeBuilder
	// WithSecurityKeyServices adds SecurityKeyServices (property field)
	WithSecurityKeyServices(...EndpointDescription) WriterGroupDataTypeBuilder
	// WithMaxNetworkMessageSize adds MaxNetworkMessageSize (property field)
	WithMaxNetworkMessageSize(uint32) WriterGroupDataTypeBuilder
	// WithGroupProperties adds GroupProperties (property field)
	WithGroupProperties(...KeyValuePair) WriterGroupDataTypeBuilder
	// WithWriterGroupId adds WriterGroupId (property field)
	WithWriterGroupId(uint16) WriterGroupDataTypeBuilder
	// WithPublishingInterval adds PublishingInterval (property field)
	WithPublishingInterval(float64) WriterGroupDataTypeBuilder
	// WithKeepAliveTime adds KeepAliveTime (property field)
	WithKeepAliveTime(float64) WriterGroupDataTypeBuilder
	// WithPriority adds Priority (property field)
	WithPriority(uint8) WriterGroupDataTypeBuilder
	// WithLocaleIds adds LocaleIds (property field)
	WithLocaleIds(...PascalString) WriterGroupDataTypeBuilder
	// WithHeaderLayoutUri adds HeaderLayoutUri (property field)
	WithHeaderLayoutUri(PascalString) WriterGroupDataTypeBuilder
	// WithHeaderLayoutUriBuilder adds HeaderLayoutUri (property field) which is build by the builder
	WithHeaderLayoutUriBuilder(func(PascalStringBuilder) PascalStringBuilder) WriterGroupDataTypeBuilder
	// WithTransportSettings adds TransportSettings (property field)
	WithTransportSettings(ExtensionObject) WriterGroupDataTypeBuilder
	// WithTransportSettingsBuilder adds TransportSettings (property field) which is build by the builder
	WithTransportSettingsBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) WriterGroupDataTypeBuilder
	// WithMessageSettings adds MessageSettings (property field)
	WithMessageSettings(ExtensionObject) WriterGroupDataTypeBuilder
	// WithMessageSettingsBuilder adds MessageSettings (property field) which is build by the builder
	WithMessageSettingsBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) WriterGroupDataTypeBuilder
	// WithDataSetWriters adds DataSetWriters (property field)
	WithDataSetWriters(...DataSetWriterDataType) WriterGroupDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the WriterGroupDataType or returns an error if something is wrong
	Build() (WriterGroupDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() WriterGroupDataType
}

// NewWriterGroupDataTypeBuilder() creates a WriterGroupDataTypeBuilder
func NewWriterGroupDataTypeBuilder() WriterGroupDataTypeBuilder {
	return &_WriterGroupDataTypeBuilder{_WriterGroupDataType: new(_WriterGroupDataType)}
}

type _WriterGroupDataTypeBuilder struct {
	*_WriterGroupDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (WriterGroupDataTypeBuilder) = (*_WriterGroupDataTypeBuilder)(nil)

func (b *_WriterGroupDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._WriterGroupDataType
}

func (b *_WriterGroupDataTypeBuilder) WithMandatoryFields(name PascalString, enabled bool, securityMode MessageSecurityMode, securityGroupId PascalString, securityKeyServices []EndpointDescription, maxNetworkMessageSize uint32, groupProperties []KeyValuePair, writerGroupId uint16, publishingInterval float64, keepAliveTime float64, priority uint8, localeIds []PascalString, headerLayoutUri PascalString, transportSettings ExtensionObject, messageSettings ExtensionObject, dataSetWriters []DataSetWriterDataType) WriterGroupDataTypeBuilder {
	return b.WithName(name).WithEnabled(enabled).WithSecurityMode(securityMode).WithSecurityGroupId(securityGroupId).WithSecurityKeyServices(securityKeyServices...).WithMaxNetworkMessageSize(maxNetworkMessageSize).WithGroupProperties(groupProperties...).WithWriterGroupId(writerGroupId).WithPublishingInterval(publishingInterval).WithKeepAliveTime(keepAliveTime).WithPriority(priority).WithLocaleIds(localeIds...).WithHeaderLayoutUri(headerLayoutUri).WithTransportSettings(transportSettings).WithMessageSettings(messageSettings).WithDataSetWriters(dataSetWriters...)
}

func (b *_WriterGroupDataTypeBuilder) WithName(name PascalString) WriterGroupDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) WriterGroupDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithEnabled(enabled bool) WriterGroupDataTypeBuilder {
	b.Enabled = enabled
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithSecurityMode(securityMode MessageSecurityMode) WriterGroupDataTypeBuilder {
	b.SecurityMode = securityMode
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithSecurityGroupId(securityGroupId PascalString) WriterGroupDataTypeBuilder {
	b.SecurityGroupId = securityGroupId
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithSecurityGroupIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) WriterGroupDataTypeBuilder {
	builder := builderSupplier(b.SecurityGroupId.CreatePascalStringBuilder())
	var err error
	b.SecurityGroupId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithSecurityKeyServices(securityKeyServices ...EndpointDescription) WriterGroupDataTypeBuilder {
	b.SecurityKeyServices = securityKeyServices
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithMaxNetworkMessageSize(maxNetworkMessageSize uint32) WriterGroupDataTypeBuilder {
	b.MaxNetworkMessageSize = maxNetworkMessageSize
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithGroupProperties(groupProperties ...KeyValuePair) WriterGroupDataTypeBuilder {
	b.GroupProperties = groupProperties
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithWriterGroupId(writerGroupId uint16) WriterGroupDataTypeBuilder {
	b.WriterGroupId = writerGroupId
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithPublishingInterval(publishingInterval float64) WriterGroupDataTypeBuilder {
	b.PublishingInterval = publishingInterval
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithKeepAliveTime(keepAliveTime float64) WriterGroupDataTypeBuilder {
	b.KeepAliveTime = keepAliveTime
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithPriority(priority uint8) WriterGroupDataTypeBuilder {
	b.Priority = priority
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithLocaleIds(localeIds ...PascalString) WriterGroupDataTypeBuilder {
	b.LocaleIds = localeIds
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithHeaderLayoutUri(headerLayoutUri PascalString) WriterGroupDataTypeBuilder {
	b.HeaderLayoutUri = headerLayoutUri
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithHeaderLayoutUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) WriterGroupDataTypeBuilder {
	builder := builderSupplier(b.HeaderLayoutUri.CreatePascalStringBuilder())
	var err error
	b.HeaderLayoutUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithTransportSettings(transportSettings ExtensionObject) WriterGroupDataTypeBuilder {
	b.TransportSettings = transportSettings
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithTransportSettingsBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) WriterGroupDataTypeBuilder {
	builder := builderSupplier(b.TransportSettings.CreateExtensionObjectBuilder())
	var err error
	b.TransportSettings, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithMessageSettings(messageSettings ExtensionObject) WriterGroupDataTypeBuilder {
	b.MessageSettings = messageSettings
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithMessageSettingsBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) WriterGroupDataTypeBuilder {
	builder := builderSupplier(b.MessageSettings.CreateExtensionObjectBuilder())
	var err error
	b.MessageSettings, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_WriterGroupDataTypeBuilder) WithDataSetWriters(dataSetWriters ...DataSetWriterDataType) WriterGroupDataTypeBuilder {
	b.DataSetWriters = dataSetWriters
	return b
}

func (b *_WriterGroupDataTypeBuilder) Build() (WriterGroupDataType, error) {
	if b.Name == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'name' not set"))
	}
	if b.SecurityGroupId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'securityGroupId' not set"))
	}
	if b.HeaderLayoutUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'headerLayoutUri' not set"))
	}
	if b.TransportSettings == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'transportSettings' not set"))
	}
	if b.MessageSettings == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageSettings' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._WriterGroupDataType.deepCopy(), nil
}

func (b *_WriterGroupDataTypeBuilder) MustBuild() WriterGroupDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_WriterGroupDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_WriterGroupDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_WriterGroupDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateWriterGroupDataTypeBuilder().(*_WriterGroupDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateWriterGroupDataTypeBuilder creates a WriterGroupDataTypeBuilder
func (b *_WriterGroupDataType) CreateWriterGroupDataTypeBuilder() WriterGroupDataTypeBuilder {
	if b == nil {
		return NewWriterGroupDataTypeBuilder()
	}
	return &_WriterGroupDataTypeBuilder{_WriterGroupDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_WriterGroupDataType) GetExtensionId() int32 {
	return int32(15482)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_WriterGroupDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_WriterGroupDataType) GetName() PascalString {
	return m.Name
}

func (m *_WriterGroupDataType) GetEnabled() bool {
	return m.Enabled
}

func (m *_WriterGroupDataType) GetSecurityMode() MessageSecurityMode {
	return m.SecurityMode
}

func (m *_WriterGroupDataType) GetSecurityGroupId() PascalString {
	return m.SecurityGroupId
}

func (m *_WriterGroupDataType) GetSecurityKeyServices() []EndpointDescription {
	return m.SecurityKeyServices
}

func (m *_WriterGroupDataType) GetMaxNetworkMessageSize() uint32 {
	return m.MaxNetworkMessageSize
}

func (m *_WriterGroupDataType) GetGroupProperties() []KeyValuePair {
	return m.GroupProperties
}

func (m *_WriterGroupDataType) GetWriterGroupId() uint16 {
	return m.WriterGroupId
}

func (m *_WriterGroupDataType) GetPublishingInterval() float64 {
	return m.PublishingInterval
}

func (m *_WriterGroupDataType) GetKeepAliveTime() float64 {
	return m.KeepAliveTime
}

func (m *_WriterGroupDataType) GetPriority() uint8 {
	return m.Priority
}

func (m *_WriterGroupDataType) GetLocaleIds() []PascalString {
	return m.LocaleIds
}

func (m *_WriterGroupDataType) GetHeaderLayoutUri() PascalString {
	return m.HeaderLayoutUri
}

func (m *_WriterGroupDataType) GetTransportSettings() ExtensionObject {
	return m.TransportSettings
}

func (m *_WriterGroupDataType) GetMessageSettings() ExtensionObject {
	return m.MessageSettings
}

func (m *_WriterGroupDataType) GetDataSetWriters() []DataSetWriterDataType {
	return m.DataSetWriters
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastWriterGroupDataType(structType any) WriterGroupDataType {
	if casted, ok := structType.(WriterGroupDataType); ok {
		return casted
	}
	if casted, ok := structType.(*WriterGroupDataType); ok {
		return *casted
	}
	return nil
}

func (m *_WriterGroupDataType) GetTypeName() string {
	return "WriterGroupDataType"
}

func (m *_WriterGroupDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (enabled)
	lengthInBits += 1

	// Simple field (securityMode)
	lengthInBits += 32

	// Simple field (securityGroupId)
	lengthInBits += m.SecurityGroupId.GetLengthInBits(ctx)

	// Implicit Field (noOfSecurityKeyServices)
	lengthInBits += 32

	// Array field
	if len(m.SecurityKeyServices) > 0 {
		for _curItem, element := range m.SecurityKeyServices {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.SecurityKeyServices), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (maxNetworkMessageSize)
	lengthInBits += 32

	// Implicit Field (noOfGroupProperties)
	lengthInBits += 32

	// Array field
	if len(m.GroupProperties) > 0 {
		for _curItem, element := range m.GroupProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GroupProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (writerGroupId)
	lengthInBits += 16

	// Simple field (publishingInterval)
	lengthInBits += 64

	// Simple field (keepAliveTime)
	lengthInBits += 64

	// Simple field (priority)
	lengthInBits += 8

	// Implicit Field (noOfLocaleIds)
	lengthInBits += 32

	// Array field
	if len(m.LocaleIds) > 0 {
		for _curItem, element := range m.LocaleIds {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.LocaleIds), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (headerLayoutUri)
	lengthInBits += m.HeaderLayoutUri.GetLengthInBits(ctx)

	// Simple field (transportSettings)
	lengthInBits += m.TransportSettings.GetLengthInBits(ctx)

	// Simple field (messageSettings)
	lengthInBits += m.MessageSettings.GetLengthInBits(ctx)

	// Implicit Field (noOfDataSetWriters)
	lengthInBits += 32

	// Array field
	if len(m.DataSetWriters) > 0 {
		for _curItem, element := range m.DataSetWriters {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DataSetWriters), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_WriterGroupDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_WriterGroupDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__writerGroupDataType WriterGroupDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("WriterGroupDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for WriterGroupDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	enabled, err := ReadSimpleField(ctx, "enabled", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enabled' field"))
	}
	m.Enabled = enabled

	securityMode, err := ReadEnumField[MessageSecurityMode](ctx, "securityMode", "MessageSecurityMode", ReadEnum(MessageSecurityModeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityMode' field"))
	}
	m.SecurityMode = securityMode

	securityGroupId, err := ReadSimpleField[PascalString](ctx, "securityGroupId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityGroupId' field"))
	}
	m.SecurityGroupId = securityGroupId

	noOfSecurityKeyServices, err := ReadImplicitField[int32](ctx, "noOfSecurityKeyServices", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfSecurityKeyServices' field"))
	}
	_ = noOfSecurityKeyServices

	securityKeyServices, err := ReadCountArrayField[EndpointDescription](ctx, "securityKeyServices", ReadComplex[EndpointDescription](ExtensionObjectDefinitionParseWithBufferProducer[EndpointDescription]((int32)(int32(314))), readBuffer), uint64(noOfSecurityKeyServices))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityKeyServices' field"))
	}
	m.SecurityKeyServices = securityKeyServices

	maxNetworkMessageSize, err := ReadSimpleField(ctx, "maxNetworkMessageSize", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'maxNetworkMessageSize' field"))
	}
	m.MaxNetworkMessageSize = maxNetworkMessageSize

	noOfGroupProperties, err := ReadImplicitField[int32](ctx, "noOfGroupProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfGroupProperties' field"))
	}
	_ = noOfGroupProperties

	groupProperties, err := ReadCountArrayField[KeyValuePair](ctx, "groupProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfGroupProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'groupProperties' field"))
	}
	m.GroupProperties = groupProperties

	writerGroupId, err := ReadSimpleField(ctx, "writerGroupId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writerGroupId' field"))
	}
	m.WriterGroupId = writerGroupId

	publishingInterval, err := ReadSimpleField(ctx, "publishingInterval", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publishingInterval' field"))
	}
	m.PublishingInterval = publishingInterval

	keepAliveTime, err := ReadSimpleField(ctx, "keepAliveTime", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'keepAliveTime' field"))
	}
	m.KeepAliveTime = keepAliveTime

	priority, err := ReadSimpleField(ctx, "priority", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'priority' field"))
	}
	m.Priority = priority

	noOfLocaleIds, err := ReadImplicitField[int32](ctx, "noOfLocaleIds", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfLocaleIds' field"))
	}
	_ = noOfLocaleIds

	localeIds, err := ReadCountArrayField[PascalString](ctx, "localeIds", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfLocaleIds))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'localeIds' field"))
	}
	m.LocaleIds = localeIds

	headerLayoutUri, err := ReadSimpleField[PascalString](ctx, "headerLayoutUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'headerLayoutUri' field"))
	}
	m.HeaderLayoutUri = headerLayoutUri

	transportSettings, err := ReadSimpleField[ExtensionObject](ctx, "transportSettings", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transportSettings' field"))
	}
	m.TransportSettings = transportSettings

	messageSettings, err := ReadSimpleField[ExtensionObject](ctx, "messageSettings", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageSettings' field"))
	}
	m.MessageSettings = messageSettings

	noOfDataSetWriters, err := ReadImplicitField[int32](ctx, "noOfDataSetWriters", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfDataSetWriters' field"))
	}
	_ = noOfDataSetWriters

	dataSetWriters, err := ReadCountArrayField[DataSetWriterDataType](ctx, "dataSetWriters", ReadComplex[DataSetWriterDataType](ExtensionObjectDefinitionParseWithBufferProducer[DataSetWriterDataType]((int32)(int32(15599))), readBuffer), uint64(noOfDataSetWriters))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriters' field"))
	}
	m.DataSetWriters = dataSetWriters

	if closeErr := readBuffer.CloseContext("WriterGroupDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for WriterGroupDataType")
	}

	return m, nil
}

func (m *_WriterGroupDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_WriterGroupDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("WriterGroupDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for WriterGroupDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "enabled", m.GetEnabled(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'enabled' field")
		}

		if err := WriteSimpleEnumField[MessageSecurityMode](ctx, "securityMode", "MessageSecurityMode", m.GetSecurityMode(), WriteEnum[MessageSecurityMode, uint32](MessageSecurityMode.GetValue, MessageSecurityMode.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'securityMode' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "securityGroupId", m.GetSecurityGroupId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'securityGroupId' field")
		}
		noOfSecurityKeyServices := int32(utils.InlineIf(bool((m.GetSecurityKeyServices()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetSecurityKeyServices()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfSecurityKeyServices", noOfSecurityKeyServices, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfSecurityKeyServices' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "securityKeyServices", m.GetSecurityKeyServices(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'securityKeyServices' field")
		}

		if err := WriteSimpleField[uint32](ctx, "maxNetworkMessageSize", m.GetMaxNetworkMessageSize(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'maxNetworkMessageSize' field")
		}
		noOfGroupProperties := int32(utils.InlineIf(bool((m.GetGroupProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetGroupProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfGroupProperties", noOfGroupProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfGroupProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "groupProperties", m.GetGroupProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'groupProperties' field")
		}

		if err := WriteSimpleField[uint16](ctx, "writerGroupId", m.GetWriterGroupId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'writerGroupId' field")
		}

		if err := WriteSimpleField[float64](ctx, "publishingInterval", m.GetPublishingInterval(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'publishingInterval' field")
		}

		if err := WriteSimpleField[float64](ctx, "keepAliveTime", m.GetKeepAliveTime(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'keepAliveTime' field")
		}

		if err := WriteSimpleField[uint8](ctx, "priority", m.GetPriority(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'priority' field")
		}
		noOfLocaleIds := int32(utils.InlineIf(bool((m.GetLocaleIds()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetLocaleIds()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfLocaleIds", noOfLocaleIds, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfLocaleIds' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "localeIds", m.GetLocaleIds(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'localeIds' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "headerLayoutUri", m.GetHeaderLayoutUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'headerLayoutUri' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "transportSettings", m.GetTransportSettings(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'transportSettings' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "messageSettings", m.GetMessageSettings(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageSettings' field")
		}
		noOfDataSetWriters := int32(utils.InlineIf(bool((m.GetDataSetWriters()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetDataSetWriters()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfDataSetWriters", noOfDataSetWriters, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfDataSetWriters' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "dataSetWriters", m.GetDataSetWriters(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriters' field")
		}

		if popErr := writeBuffer.PopContext("WriterGroupDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for WriterGroupDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_WriterGroupDataType) IsWriterGroupDataType() {}

func (m *_WriterGroupDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_WriterGroupDataType) deepCopy() *_WriterGroupDataType {
	if m == nil {
		return nil
	}
	_WriterGroupDataTypeCopy := &_WriterGroupDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		m.Enabled,
		m.SecurityMode,
		utils.DeepCopy[PascalString](m.SecurityGroupId),
		utils.DeepCopySlice[EndpointDescription, EndpointDescription](m.SecurityKeyServices),
		m.MaxNetworkMessageSize,
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.GroupProperties),
		m.WriterGroupId,
		m.PublishingInterval,
		m.KeepAliveTime,
		m.Priority,
		utils.DeepCopySlice[PascalString, PascalString](m.LocaleIds),
		utils.DeepCopy[PascalString](m.HeaderLayoutUri),
		utils.DeepCopy[ExtensionObject](m.TransportSettings),
		utils.DeepCopy[ExtensionObject](m.MessageSettings),
		utils.DeepCopySlice[DataSetWriterDataType, DataSetWriterDataType](m.DataSetWriters),
		m.reservedField0,
	}
	_WriterGroupDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _WriterGroupDataTypeCopy
}

func (m *_WriterGroupDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
