/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariantUInt32 is the corresponding interface of VariantUInt32
type VariantUInt32 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Variant
	// GetArrayLength returns ArrayLength (property field)
	GetArrayLength() *int32
	// GetValue returns Value (property field)
	GetValue() []uint32
	// IsVariantUInt32 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariantUInt32()
	// CreateBuilder creates a VariantUInt32Builder
	CreateVariantUInt32Builder() VariantUInt32Builder
}

// _VariantUInt32 is the data-structure of this message
type _VariantUInt32 struct {
	VariantContract
	ArrayLength *int32
	Value       []uint32
}

var _ VariantUInt32 = (*_VariantUInt32)(nil)
var _ VariantRequirements = (*_VariantUInt32)(nil)

// NewVariantUInt32 factory function for _VariantUInt32
func NewVariantUInt32(arrayLengthSpecified bool, arrayDimensionsSpecified bool, noOfArrayDimensions *int32, arrayDimensions []bool, arrayLength *int32, value []uint32) *_VariantUInt32 {
	_result := &_VariantUInt32{
		VariantContract: NewVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions),
		ArrayLength:     arrayLength,
		Value:           value,
	}
	_result.VariantContract.(*_Variant)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariantUInt32Builder is a builder for VariantUInt32
type VariantUInt32Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []uint32) VariantUInt32Builder
	// WithArrayLength adds ArrayLength (property field)
	WithOptionalArrayLength(int32) VariantUInt32Builder
	// WithValue adds Value (property field)
	WithValue(...uint32) VariantUInt32Builder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() VariantBuilder
	// Build builds the VariantUInt32 or returns an error if something is wrong
	Build() (VariantUInt32, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariantUInt32
}

// NewVariantUInt32Builder() creates a VariantUInt32Builder
func NewVariantUInt32Builder() VariantUInt32Builder {
	return &_VariantUInt32Builder{_VariantUInt32: new(_VariantUInt32)}
}

type _VariantUInt32Builder struct {
	*_VariantUInt32

	parentBuilder *_VariantBuilder

	err *utils.MultiError
}

var _ (VariantUInt32Builder) = (*_VariantUInt32Builder)(nil)

func (b *_VariantUInt32Builder) setParent(contract VariantContract) {
	b.VariantContract = contract
	contract.(*_Variant)._SubType = b._VariantUInt32
}

func (b *_VariantUInt32Builder) WithMandatoryFields(value []uint32) VariantUInt32Builder {
	return b.WithValue(value...)
}

func (b *_VariantUInt32Builder) WithOptionalArrayLength(arrayLength int32) VariantUInt32Builder {
	b.ArrayLength = &arrayLength
	return b
}

func (b *_VariantUInt32Builder) WithValue(value ...uint32) VariantUInt32Builder {
	b.Value = value
	return b
}

func (b *_VariantUInt32Builder) Build() (VariantUInt32, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._VariantUInt32.deepCopy(), nil
}

func (b *_VariantUInt32Builder) MustBuild() VariantUInt32 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariantUInt32Builder) Done() VariantBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewVariantBuilder().(*_VariantBuilder)
	}
	return b.parentBuilder
}

func (b *_VariantUInt32Builder) buildForVariant() (Variant, error) {
	return b.Build()
}

func (b *_VariantUInt32Builder) DeepCopy() any {
	_copy := b.CreateVariantUInt32Builder().(*_VariantUInt32Builder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateVariantUInt32Builder creates a VariantUInt32Builder
func (b *_VariantUInt32) CreateVariantUInt32Builder() VariantUInt32Builder {
	if b == nil {
		return NewVariantUInt32Builder()
	}
	return &_VariantUInt32Builder{_VariantUInt32: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariantUInt32) GetVariantType() uint8 {
	return uint8(7)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariantUInt32) GetParent() VariantContract {
	return m.VariantContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariantUInt32) GetArrayLength() *int32 {
	return m.ArrayLength
}

func (m *_VariantUInt32) GetValue() []uint32 {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariantUInt32(structType any) VariantUInt32 {
	if casted, ok := structType.(VariantUInt32); ok {
		return casted
	}
	if casted, ok := structType.(*VariantUInt32); ok {
		return *casted
	}
	return nil
}

func (m *_VariantUInt32) GetTypeName() string {
	return "VariantUInt32"
}

func (m *_VariantUInt32) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.VariantContract.(*_Variant).getLengthInBits(ctx))

	// Optional Field (arrayLength)
	if m.ArrayLength != nil {
		lengthInBits += 32
	}

	// Array field
	if len(m.Value) > 0 {
		lengthInBits += 32 * uint16(len(m.Value))
	}

	return lengthInBits
}

func (m *_VariantUInt32) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariantUInt32) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Variant, arrayLengthSpecified bool) (__variantUInt32 VariantUInt32, err error) {
	m.VariantContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariantUInt32"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariantUInt32")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var arrayLength *int32
	arrayLength, err = ReadOptionalField[int32](ctx, "arrayLength", ReadSignedInt(readBuffer, uint8(32)), arrayLengthSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayLength' field"))
	}
	m.ArrayLength = arrayLength

	value, err := ReadCountArrayField[uint32](ctx, "value", ReadUnsignedInt(readBuffer, uint8(32)), uint64(utils.InlineIf(bool((arrayLength) == (nil)), func() any { return int32(int32(1)) }, func() any { return int32((*arrayLength)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("VariantUInt32"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariantUInt32")
	}

	return m, nil
}

func (m *_VariantUInt32) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariantUInt32) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariantUInt32"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariantUInt32")
		}

		if err := WriteOptionalField[int32](ctx, "arrayLength", m.GetArrayLength(), WriteSignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayLength' field")
		}

		if err := WriteSimpleTypeArrayField(ctx, "value", m.GetValue(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("VariantUInt32"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariantUInt32")
		}
		return nil
	}
	return m.VariantContract.(*_Variant).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariantUInt32) IsVariantUInt32() {}

func (m *_VariantUInt32) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariantUInt32) deepCopy() *_VariantUInt32 {
	if m == nil {
		return nil
	}
	_VariantUInt32Copy := &_VariantUInt32{
		m.VariantContract.(*_Variant).deepCopy(),
		utils.CopyPtr[int32](m.ArrayLength),
		utils.DeepCopySlice[uint32, uint32](m.Value),
	}
	_VariantUInt32Copy.VariantContract.(*_Variant)._SubType = m
	return _VariantUInt32Copy
}

func (m *_VariantUInt32) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
