/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariantInt16 is the corresponding interface of VariantInt16
type VariantInt16 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Variant
	// GetArrayLength returns ArrayLength (property field)
	GetArrayLength() *int32
	// GetValue returns Value (property field)
	GetValue() []int16
	// IsVariantInt16 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariantInt16()
	// CreateBuilder creates a VariantInt16Builder
	CreateVariantInt16Builder() VariantInt16Builder
}

// _VariantInt16 is the data-structure of this message
type _VariantInt16 struct {
	VariantContract
	ArrayLength *int32
	Value       []int16
}

var _ VariantInt16 = (*_VariantInt16)(nil)
var _ VariantRequirements = (*_VariantInt16)(nil)

// NewVariantInt16 factory function for _VariantInt16
func NewVariantInt16(arrayLengthSpecified bool, arrayDimensionsSpecified bool, noOfArrayDimensions *int32, arrayDimensions []bool, arrayLength *int32, value []int16) *_VariantInt16 {
	_result := &_VariantInt16{
		VariantContract: NewVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions),
		ArrayLength:     arrayLength,
		Value:           value,
	}
	_result.VariantContract.(*_Variant)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariantInt16Builder is a builder for VariantInt16
type VariantInt16Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []int16) VariantInt16Builder
	// WithArrayLength adds ArrayLength (property field)
	WithOptionalArrayLength(int32) VariantInt16Builder
	// WithValue adds Value (property field)
	WithValue(...int16) VariantInt16Builder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() VariantBuilder
	// Build builds the VariantInt16 or returns an error if something is wrong
	Build() (VariantInt16, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariantInt16
}

// NewVariantInt16Builder() creates a VariantInt16Builder
func NewVariantInt16Builder() VariantInt16Builder {
	return &_VariantInt16Builder{_VariantInt16: new(_VariantInt16)}
}

type _VariantInt16Builder struct {
	*_VariantInt16

	parentBuilder *_VariantBuilder

	err *utils.MultiError
}

var _ (VariantInt16Builder) = (*_VariantInt16Builder)(nil)

func (b *_VariantInt16Builder) setParent(contract VariantContract) {
	b.VariantContract = contract
	contract.(*_Variant)._SubType = b._VariantInt16
}

func (b *_VariantInt16Builder) WithMandatoryFields(value []int16) VariantInt16Builder {
	return b.WithValue(value...)
}

func (b *_VariantInt16Builder) WithOptionalArrayLength(arrayLength int32) VariantInt16Builder {
	b.ArrayLength = &arrayLength
	return b
}

func (b *_VariantInt16Builder) WithValue(value ...int16) VariantInt16Builder {
	b.Value = value
	return b
}

func (b *_VariantInt16Builder) Build() (VariantInt16, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._VariantInt16.deepCopy(), nil
}

func (b *_VariantInt16Builder) MustBuild() VariantInt16 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariantInt16Builder) Done() VariantBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewVariantBuilder().(*_VariantBuilder)
	}
	return b.parentBuilder
}

func (b *_VariantInt16Builder) buildForVariant() (Variant, error) {
	return b.Build()
}

func (b *_VariantInt16Builder) DeepCopy() any {
	_copy := b.CreateVariantInt16Builder().(*_VariantInt16Builder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateVariantInt16Builder creates a VariantInt16Builder
func (b *_VariantInt16) CreateVariantInt16Builder() VariantInt16Builder {
	if b == nil {
		return NewVariantInt16Builder()
	}
	return &_VariantInt16Builder{_VariantInt16: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariantInt16) GetVariantType() uint8 {
	return uint8(4)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariantInt16) GetParent() VariantContract {
	return m.VariantContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariantInt16) GetArrayLength() *int32 {
	return m.ArrayLength
}

func (m *_VariantInt16) GetValue() []int16 {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariantInt16(structType any) VariantInt16 {
	if casted, ok := structType.(VariantInt16); ok {
		return casted
	}
	if casted, ok := structType.(*VariantInt16); ok {
		return *casted
	}
	return nil
}

func (m *_VariantInt16) GetTypeName() string {
	return "VariantInt16"
}

func (m *_VariantInt16) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.VariantContract.(*_Variant).getLengthInBits(ctx))

	// Optional Field (arrayLength)
	if m.ArrayLength != nil {
		lengthInBits += 32
	}

	// Array field
	if len(m.Value) > 0 {
		lengthInBits += 16 * uint16(len(m.Value))
	}

	return lengthInBits
}

func (m *_VariantInt16) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariantInt16) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Variant, arrayLengthSpecified bool) (__variantInt16 VariantInt16, err error) {
	m.VariantContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariantInt16"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariantInt16")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var arrayLength *int32
	arrayLength, err = ReadOptionalField[int32](ctx, "arrayLength", ReadSignedInt(readBuffer, uint8(32)), arrayLengthSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayLength' field"))
	}
	m.ArrayLength = arrayLength

	value, err := ReadCountArrayField[int16](ctx, "value", ReadSignedShort(readBuffer, uint8(16)), uint64(utils.InlineIf(bool((arrayLength) == (nil)), func() any { return int32(int32(1)) }, func() any { return int32((*arrayLength)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("VariantInt16"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariantInt16")
	}

	return m, nil
}

func (m *_VariantInt16) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariantInt16) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariantInt16"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariantInt16")
		}

		if err := WriteOptionalField[int32](ctx, "arrayLength", m.GetArrayLength(), WriteSignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayLength' field")
		}

		if err := WriteSimpleTypeArrayField(ctx, "value", m.GetValue(), WriteSignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("VariantInt16"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariantInt16")
		}
		return nil
	}
	return m.VariantContract.(*_Variant).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariantInt16) IsVariantInt16() {}

func (m *_VariantInt16) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariantInt16) deepCopy() *_VariantInt16 {
	if m == nil {
		return nil
	}
	_VariantInt16Copy := &_VariantInt16{
		m.VariantContract.(*_Variant).deepCopy(),
		utils.CopyPtr[int32](m.ArrayLength),
		utils.DeepCopySlice[int16, int16](m.Value),
	}
	_VariantInt16Copy.VariantContract.(*_Variant)._SubType = m
	return _VariantInt16Copy
}

func (m *_VariantInt16) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
