/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariantGuid is the corresponding interface of VariantGuid
type VariantGuid interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Variant
	// GetArrayLength returns ArrayLength (property field)
	GetArrayLength() *int32
	// GetValue returns Value (property field)
	GetValue() []GuidValue
	// IsVariantGuid is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariantGuid()
	// CreateBuilder creates a VariantGuidBuilder
	CreateVariantGuidBuilder() VariantGuidBuilder
}

// _VariantGuid is the data-structure of this message
type _VariantGuid struct {
	VariantContract
	ArrayLength *int32
	Value       []GuidValue
}

var _ VariantGuid = (*_VariantGuid)(nil)
var _ VariantRequirements = (*_VariantGuid)(nil)

// NewVariantGuid factory function for _VariantGuid
func NewVariantGuid(arrayLengthSpecified bool, arrayDimensionsSpecified bool, noOfArrayDimensions *int32, arrayDimensions []bool, arrayLength *int32, value []GuidValue) *_VariantGuid {
	_result := &_VariantGuid{
		VariantContract: NewVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions),
		ArrayLength:     arrayLength,
		Value:           value,
	}
	_result.VariantContract.(*_Variant)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariantGuidBuilder is a builder for VariantGuid
type VariantGuidBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []GuidValue) VariantGuidBuilder
	// WithArrayLength adds ArrayLength (property field)
	WithOptionalArrayLength(int32) VariantGuidBuilder
	// WithValue adds Value (property field)
	WithValue(...GuidValue) VariantGuidBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() VariantBuilder
	// Build builds the VariantGuid or returns an error if something is wrong
	Build() (VariantGuid, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariantGuid
}

// NewVariantGuidBuilder() creates a VariantGuidBuilder
func NewVariantGuidBuilder() VariantGuidBuilder {
	return &_VariantGuidBuilder{_VariantGuid: new(_VariantGuid)}
}

type _VariantGuidBuilder struct {
	*_VariantGuid

	parentBuilder *_VariantBuilder

	err *utils.MultiError
}

var _ (VariantGuidBuilder) = (*_VariantGuidBuilder)(nil)

func (b *_VariantGuidBuilder) setParent(contract VariantContract) {
	b.VariantContract = contract
	contract.(*_Variant)._SubType = b._VariantGuid
}

func (b *_VariantGuidBuilder) WithMandatoryFields(value []GuidValue) VariantGuidBuilder {
	return b.WithValue(value...)
}

func (b *_VariantGuidBuilder) WithOptionalArrayLength(arrayLength int32) VariantGuidBuilder {
	b.ArrayLength = &arrayLength
	return b
}

func (b *_VariantGuidBuilder) WithValue(value ...GuidValue) VariantGuidBuilder {
	b.Value = value
	return b
}

func (b *_VariantGuidBuilder) Build() (VariantGuid, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._VariantGuid.deepCopy(), nil
}

func (b *_VariantGuidBuilder) MustBuild() VariantGuid {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariantGuidBuilder) Done() VariantBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewVariantBuilder().(*_VariantBuilder)
	}
	return b.parentBuilder
}

func (b *_VariantGuidBuilder) buildForVariant() (Variant, error) {
	return b.Build()
}

func (b *_VariantGuidBuilder) DeepCopy() any {
	_copy := b.CreateVariantGuidBuilder().(*_VariantGuidBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateVariantGuidBuilder creates a VariantGuidBuilder
func (b *_VariantGuid) CreateVariantGuidBuilder() VariantGuidBuilder {
	if b == nil {
		return NewVariantGuidBuilder()
	}
	return &_VariantGuidBuilder{_VariantGuid: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariantGuid) GetVariantType() uint8 {
	return uint8(14)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariantGuid) GetParent() VariantContract {
	return m.VariantContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariantGuid) GetArrayLength() *int32 {
	return m.ArrayLength
}

func (m *_VariantGuid) GetValue() []GuidValue {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariantGuid(structType any) VariantGuid {
	if casted, ok := structType.(VariantGuid); ok {
		return casted
	}
	if casted, ok := structType.(*VariantGuid); ok {
		return *casted
	}
	return nil
}

func (m *_VariantGuid) GetTypeName() string {
	return "VariantGuid"
}

func (m *_VariantGuid) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.VariantContract.(*_Variant).getLengthInBits(ctx))

	// Optional Field (arrayLength)
	if m.ArrayLength != nil {
		lengthInBits += 32
	}

	// Array field
	if len(m.Value) > 0 {
		for _curItem, element := range m.Value {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Value), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_VariantGuid) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariantGuid) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Variant, arrayLengthSpecified bool) (__variantGuid VariantGuid, err error) {
	m.VariantContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariantGuid"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariantGuid")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var arrayLength *int32
	arrayLength, err = ReadOptionalField[int32](ctx, "arrayLength", ReadSignedInt(readBuffer, uint8(32)), arrayLengthSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayLength' field"))
	}
	m.ArrayLength = arrayLength

	value, err := ReadCountArrayField[GuidValue](ctx, "value", ReadComplex[GuidValue](GuidValueParseWithBuffer, readBuffer), uint64(utils.InlineIf(bool((arrayLength) == (nil)), func() any { return int32(int32(1)) }, func() any { return int32((*arrayLength)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("VariantGuid"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariantGuid")
	}

	return m, nil
}

func (m *_VariantGuid) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariantGuid) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariantGuid"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariantGuid")
		}

		if err := WriteOptionalField[int32](ctx, "arrayLength", m.GetArrayLength(), WriteSignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayLength' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "value", m.GetValue(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("VariantGuid"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariantGuid")
		}
		return nil
	}
	return m.VariantContract.(*_Variant).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariantGuid) IsVariantGuid() {}

func (m *_VariantGuid) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariantGuid) deepCopy() *_VariantGuid {
	if m == nil {
		return nil
	}
	_VariantGuidCopy := &_VariantGuid{
		m.VariantContract.(*_Variant).deepCopy(),
		utils.CopyPtr[int32](m.ArrayLength),
		utils.DeepCopySlice[GuidValue, GuidValue](m.Value),
	}
	_VariantGuidCopy.VariantContract.(*_Variant)._SubType = m
	return _VariantGuidCopy
}

func (m *_VariantGuid) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
