/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariantByteString is the corresponding interface of VariantByteString
type VariantByteString interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Variant
	// GetArrayLength returns ArrayLength (property field)
	GetArrayLength() *int32
	// GetValue returns Value (property field)
	GetValue() []ByteStringArray
	// IsVariantByteString is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariantByteString()
	// CreateBuilder creates a VariantByteStringBuilder
	CreateVariantByteStringBuilder() VariantByteStringBuilder
}

// _VariantByteString is the data-structure of this message
type _VariantByteString struct {
	VariantContract
	ArrayLength *int32
	Value       []ByteStringArray
}

var _ VariantByteString = (*_VariantByteString)(nil)
var _ VariantRequirements = (*_VariantByteString)(nil)

// NewVariantByteString factory function for _VariantByteString
func NewVariantByteString(arrayLengthSpecified bool, arrayDimensionsSpecified bool, noOfArrayDimensions *int32, arrayDimensions []bool, arrayLength *int32, value []ByteStringArray) *_VariantByteString {
	_result := &_VariantByteString{
		VariantContract: NewVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions),
		ArrayLength:     arrayLength,
		Value:           value,
	}
	_result.VariantContract.(*_Variant)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariantByteStringBuilder is a builder for VariantByteString
type VariantByteStringBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []ByteStringArray) VariantByteStringBuilder
	// WithArrayLength adds ArrayLength (property field)
	WithOptionalArrayLength(int32) VariantByteStringBuilder
	// WithValue adds Value (property field)
	WithValue(...ByteStringArray) VariantByteStringBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() VariantBuilder
	// Build builds the VariantByteString or returns an error if something is wrong
	Build() (VariantByteString, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariantByteString
}

// NewVariantByteStringBuilder() creates a VariantByteStringBuilder
func NewVariantByteStringBuilder() VariantByteStringBuilder {
	return &_VariantByteStringBuilder{_VariantByteString: new(_VariantByteString)}
}

type _VariantByteStringBuilder struct {
	*_VariantByteString

	parentBuilder *_VariantBuilder

	err *utils.MultiError
}

var _ (VariantByteStringBuilder) = (*_VariantByteStringBuilder)(nil)

func (b *_VariantByteStringBuilder) setParent(contract VariantContract) {
	b.VariantContract = contract
	contract.(*_Variant)._SubType = b._VariantByteString
}

func (b *_VariantByteStringBuilder) WithMandatoryFields(value []ByteStringArray) VariantByteStringBuilder {
	return b.WithValue(value...)
}

func (b *_VariantByteStringBuilder) WithOptionalArrayLength(arrayLength int32) VariantByteStringBuilder {
	b.ArrayLength = &arrayLength
	return b
}

func (b *_VariantByteStringBuilder) WithValue(value ...ByteStringArray) VariantByteStringBuilder {
	b.Value = value
	return b
}

func (b *_VariantByteStringBuilder) Build() (VariantByteString, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._VariantByteString.deepCopy(), nil
}

func (b *_VariantByteStringBuilder) MustBuild() VariantByteString {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariantByteStringBuilder) Done() VariantBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewVariantBuilder().(*_VariantBuilder)
	}
	return b.parentBuilder
}

func (b *_VariantByteStringBuilder) buildForVariant() (Variant, error) {
	return b.Build()
}

func (b *_VariantByteStringBuilder) DeepCopy() any {
	_copy := b.CreateVariantByteStringBuilder().(*_VariantByteStringBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateVariantByteStringBuilder creates a VariantByteStringBuilder
func (b *_VariantByteString) CreateVariantByteStringBuilder() VariantByteStringBuilder {
	if b == nil {
		return NewVariantByteStringBuilder()
	}
	return &_VariantByteStringBuilder{_VariantByteString: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariantByteString) GetVariantType() uint8 {
	return uint8(15)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariantByteString) GetParent() VariantContract {
	return m.VariantContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariantByteString) GetArrayLength() *int32 {
	return m.ArrayLength
}

func (m *_VariantByteString) GetValue() []ByteStringArray {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariantByteString(structType any) VariantByteString {
	if casted, ok := structType.(VariantByteString); ok {
		return casted
	}
	if casted, ok := structType.(*VariantByteString); ok {
		return *casted
	}
	return nil
}

func (m *_VariantByteString) GetTypeName() string {
	return "VariantByteString"
}

func (m *_VariantByteString) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.VariantContract.(*_Variant).getLengthInBits(ctx))

	// Optional Field (arrayLength)
	if m.ArrayLength != nil {
		lengthInBits += 32
	}

	// Array field
	if len(m.Value) > 0 {
		for _curItem, element := range m.Value {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Value), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_VariantByteString) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariantByteString) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Variant, arrayLengthSpecified bool) (__variantByteString VariantByteString, err error) {
	m.VariantContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariantByteString"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariantByteString")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var arrayLength *int32
	arrayLength, err = ReadOptionalField[int32](ctx, "arrayLength", ReadSignedInt(readBuffer, uint8(32)), arrayLengthSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayLength' field"))
	}
	m.ArrayLength = arrayLength

	value, err := ReadCountArrayField[ByteStringArray](ctx, "value", ReadComplex[ByteStringArray](ByteStringArrayParseWithBuffer, readBuffer), uint64(utils.InlineIf(bool((arrayLength) == (nil)), func() any { return int32(int32(1)) }, func() any { return int32((*arrayLength)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("VariantByteString"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariantByteString")
	}

	return m, nil
}

func (m *_VariantByteString) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariantByteString) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariantByteString"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariantByteString")
		}

		if err := WriteOptionalField[int32](ctx, "arrayLength", m.GetArrayLength(), WriteSignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayLength' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "value", m.GetValue(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("VariantByteString"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariantByteString")
		}
		return nil
	}
	return m.VariantContract.(*_Variant).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariantByteString) IsVariantByteString() {}

func (m *_VariantByteString) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariantByteString) deepCopy() *_VariantByteString {
	if m == nil {
		return nil
	}
	_VariantByteStringCopy := &_VariantByteString{
		m.VariantContract.(*_Variant).deepCopy(),
		utils.CopyPtr[int32](m.ArrayLength),
		utils.DeepCopySlice[ByteStringArray, ByteStringArray](m.Value),
	}
	_VariantByteStringCopy.VariantContract.(*_Variant)._SubType = m
	return _VariantByteStringCopy
}

func (m *_VariantByteString) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
