/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// UriString is the corresponding interface of UriString
type UriString interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsUriString is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsUriString()
	// CreateBuilder creates a UriStringBuilder
	CreateUriStringBuilder() UriStringBuilder
}

// _UriString is the data-structure of this message
type _UriString struct {
}

var _ UriString = (*_UriString)(nil)

// NewUriString factory function for _UriString
func NewUriString() *_UriString {
	return &_UriString{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// UriStringBuilder is a builder for UriString
type UriStringBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() UriStringBuilder
	// Build builds the UriString or returns an error if something is wrong
	Build() (UriString, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() UriString
}

// NewUriStringBuilder() creates a UriStringBuilder
func NewUriStringBuilder() UriStringBuilder {
	return &_UriStringBuilder{_UriString: new(_UriString)}
}

type _UriStringBuilder struct {
	*_UriString

	err *utils.MultiError
}

var _ (UriStringBuilder) = (*_UriStringBuilder)(nil)

func (b *_UriStringBuilder) WithMandatoryFields() UriStringBuilder {
	return b
}

func (b *_UriStringBuilder) Build() (UriString, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._UriString.deepCopy(), nil
}

func (b *_UriStringBuilder) MustBuild() UriString {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_UriStringBuilder) DeepCopy() any {
	_copy := b.CreateUriStringBuilder().(*_UriStringBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateUriStringBuilder creates a UriStringBuilder
func (b *_UriString) CreateUriStringBuilder() UriStringBuilder {
	if b == nil {
		return NewUriStringBuilder()
	}
	return &_UriStringBuilder{_UriString: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastUriString(structType any) UriString {
	if casted, ok := structType.(UriString); ok {
		return casted
	}
	if casted, ok := structType.(*UriString); ok {
		return *casted
	}
	return nil
}

func (m *_UriString) GetTypeName() string {
	return "UriString"
}

func (m *_UriString) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_UriString) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func UriStringParse(ctx context.Context, theBytes []byte) (UriString, error) {
	return UriStringParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func UriStringParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (UriString, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (UriString, error) {
		return UriStringParseWithBuffer(ctx, readBuffer)
	}
}

func UriStringParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (UriString, error) {
	v, err := (&_UriString{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_UriString) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__uriString UriString, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("UriString"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UriString")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("UriString"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UriString")
	}

	return m, nil
}

func (m *_UriString) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UriString) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("UriString"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for UriString")
	}

	if popErr := writeBuffer.PopContext("UriString"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for UriString")
	}
	return nil
}

func (m *_UriString) IsUriString() {}

func (m *_UriString) DeepCopy() any {
	return m.deepCopy()
}

func (m *_UriString) deepCopy() *_UriString {
	if m == nil {
		return nil
	}
	_UriStringCopy := &_UriString{}
	return _UriStringCopy
}

func (m *_UriString) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
