/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// UadpWriterGroupMessageDataType is the corresponding interface of UadpWriterGroupMessageDataType
type UadpWriterGroupMessageDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetGroupVersion returns GroupVersion (property field)
	GetGroupVersion() uint32
	// GetDataSetOrdering returns DataSetOrdering (property field)
	GetDataSetOrdering() DataSetOrderingType
	// GetNetworkMessageContentMask returns NetworkMessageContentMask (property field)
	GetNetworkMessageContentMask() UadpNetworkMessageContentMask
	// GetSamplingOffset returns SamplingOffset (property field)
	GetSamplingOffset() float64
	// GetPublishingOffset returns PublishingOffset (property field)
	GetPublishingOffset() []float64
	// IsUadpWriterGroupMessageDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsUadpWriterGroupMessageDataType()
	// CreateBuilder creates a UadpWriterGroupMessageDataTypeBuilder
	CreateUadpWriterGroupMessageDataTypeBuilder() UadpWriterGroupMessageDataTypeBuilder
}

// _UadpWriterGroupMessageDataType is the data-structure of this message
type _UadpWriterGroupMessageDataType struct {
	ExtensionObjectDefinitionContract
	GroupVersion              uint32
	DataSetOrdering           DataSetOrderingType
	NetworkMessageContentMask UadpNetworkMessageContentMask
	SamplingOffset            float64
	PublishingOffset          []float64
}

var _ UadpWriterGroupMessageDataType = (*_UadpWriterGroupMessageDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_UadpWriterGroupMessageDataType)(nil)

// NewUadpWriterGroupMessageDataType factory function for _UadpWriterGroupMessageDataType
func NewUadpWriterGroupMessageDataType(groupVersion uint32, dataSetOrdering DataSetOrderingType, networkMessageContentMask UadpNetworkMessageContentMask, samplingOffset float64, publishingOffset []float64) *_UadpWriterGroupMessageDataType {
	_result := &_UadpWriterGroupMessageDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		GroupVersion:                      groupVersion,
		DataSetOrdering:                   dataSetOrdering,
		NetworkMessageContentMask:         networkMessageContentMask,
		SamplingOffset:                    samplingOffset,
		PublishingOffset:                  publishingOffset,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// UadpWriterGroupMessageDataTypeBuilder is a builder for UadpWriterGroupMessageDataType
type UadpWriterGroupMessageDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(groupVersion uint32, dataSetOrdering DataSetOrderingType, networkMessageContentMask UadpNetworkMessageContentMask, samplingOffset float64, publishingOffset []float64) UadpWriterGroupMessageDataTypeBuilder
	// WithGroupVersion adds GroupVersion (property field)
	WithGroupVersion(uint32) UadpWriterGroupMessageDataTypeBuilder
	// WithDataSetOrdering adds DataSetOrdering (property field)
	WithDataSetOrdering(DataSetOrderingType) UadpWriterGroupMessageDataTypeBuilder
	// WithNetworkMessageContentMask adds NetworkMessageContentMask (property field)
	WithNetworkMessageContentMask(UadpNetworkMessageContentMask) UadpWriterGroupMessageDataTypeBuilder
	// WithSamplingOffset adds SamplingOffset (property field)
	WithSamplingOffset(float64) UadpWriterGroupMessageDataTypeBuilder
	// WithPublishingOffset adds PublishingOffset (property field)
	WithPublishingOffset(...float64) UadpWriterGroupMessageDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the UadpWriterGroupMessageDataType or returns an error if something is wrong
	Build() (UadpWriterGroupMessageDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() UadpWriterGroupMessageDataType
}

// NewUadpWriterGroupMessageDataTypeBuilder() creates a UadpWriterGroupMessageDataTypeBuilder
func NewUadpWriterGroupMessageDataTypeBuilder() UadpWriterGroupMessageDataTypeBuilder {
	return &_UadpWriterGroupMessageDataTypeBuilder{_UadpWriterGroupMessageDataType: new(_UadpWriterGroupMessageDataType)}
}

type _UadpWriterGroupMessageDataTypeBuilder struct {
	*_UadpWriterGroupMessageDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (UadpWriterGroupMessageDataTypeBuilder) = (*_UadpWriterGroupMessageDataTypeBuilder)(nil)

func (b *_UadpWriterGroupMessageDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._UadpWriterGroupMessageDataType
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) WithMandatoryFields(groupVersion uint32, dataSetOrdering DataSetOrderingType, networkMessageContentMask UadpNetworkMessageContentMask, samplingOffset float64, publishingOffset []float64) UadpWriterGroupMessageDataTypeBuilder {
	return b.WithGroupVersion(groupVersion).WithDataSetOrdering(dataSetOrdering).WithNetworkMessageContentMask(networkMessageContentMask).WithSamplingOffset(samplingOffset).WithPublishingOffset(publishingOffset...)
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) WithGroupVersion(groupVersion uint32) UadpWriterGroupMessageDataTypeBuilder {
	b.GroupVersion = groupVersion
	return b
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) WithDataSetOrdering(dataSetOrdering DataSetOrderingType) UadpWriterGroupMessageDataTypeBuilder {
	b.DataSetOrdering = dataSetOrdering
	return b
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) WithNetworkMessageContentMask(networkMessageContentMask UadpNetworkMessageContentMask) UadpWriterGroupMessageDataTypeBuilder {
	b.NetworkMessageContentMask = networkMessageContentMask
	return b
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) WithSamplingOffset(samplingOffset float64) UadpWriterGroupMessageDataTypeBuilder {
	b.SamplingOffset = samplingOffset
	return b
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) WithPublishingOffset(publishingOffset ...float64) UadpWriterGroupMessageDataTypeBuilder {
	b.PublishingOffset = publishingOffset
	return b
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) Build() (UadpWriterGroupMessageDataType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._UadpWriterGroupMessageDataType.deepCopy(), nil
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) MustBuild() UadpWriterGroupMessageDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_UadpWriterGroupMessageDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateUadpWriterGroupMessageDataTypeBuilder().(*_UadpWriterGroupMessageDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateUadpWriterGroupMessageDataTypeBuilder creates a UadpWriterGroupMessageDataTypeBuilder
func (b *_UadpWriterGroupMessageDataType) CreateUadpWriterGroupMessageDataTypeBuilder() UadpWriterGroupMessageDataTypeBuilder {
	if b == nil {
		return NewUadpWriterGroupMessageDataTypeBuilder()
	}
	return &_UadpWriterGroupMessageDataTypeBuilder{_UadpWriterGroupMessageDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_UadpWriterGroupMessageDataType) GetExtensionId() int32 {
	return int32(15647)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_UadpWriterGroupMessageDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_UadpWriterGroupMessageDataType) GetGroupVersion() uint32 {
	return m.GroupVersion
}

func (m *_UadpWriterGroupMessageDataType) GetDataSetOrdering() DataSetOrderingType {
	return m.DataSetOrdering
}

func (m *_UadpWriterGroupMessageDataType) GetNetworkMessageContentMask() UadpNetworkMessageContentMask {
	return m.NetworkMessageContentMask
}

func (m *_UadpWriterGroupMessageDataType) GetSamplingOffset() float64 {
	return m.SamplingOffset
}

func (m *_UadpWriterGroupMessageDataType) GetPublishingOffset() []float64 {
	return m.PublishingOffset
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastUadpWriterGroupMessageDataType(structType any) UadpWriterGroupMessageDataType {
	if casted, ok := structType.(UadpWriterGroupMessageDataType); ok {
		return casted
	}
	if casted, ok := structType.(*UadpWriterGroupMessageDataType); ok {
		return *casted
	}
	return nil
}

func (m *_UadpWriterGroupMessageDataType) GetTypeName() string {
	return "UadpWriterGroupMessageDataType"
}

func (m *_UadpWriterGroupMessageDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (groupVersion)
	lengthInBits += 32

	// Simple field (dataSetOrdering)
	lengthInBits += 32

	// Simple field (networkMessageContentMask)
	lengthInBits += 32

	// Simple field (samplingOffset)
	lengthInBits += 64

	// Implicit Field (noOfPublishingOffset)
	lengthInBits += 32

	// Array field
	if len(m.PublishingOffset) > 0 {
		lengthInBits += 64 * uint16(len(m.PublishingOffset))
	}

	return lengthInBits
}

func (m *_UadpWriterGroupMessageDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_UadpWriterGroupMessageDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__uadpWriterGroupMessageDataType UadpWriterGroupMessageDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("UadpWriterGroupMessageDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UadpWriterGroupMessageDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	groupVersion, err := ReadSimpleField(ctx, "groupVersion", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'groupVersion' field"))
	}
	m.GroupVersion = groupVersion

	dataSetOrdering, err := ReadEnumField[DataSetOrderingType](ctx, "dataSetOrdering", "DataSetOrderingType", ReadEnum(DataSetOrderingTypeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetOrdering' field"))
	}
	m.DataSetOrdering = dataSetOrdering

	networkMessageContentMask, err := ReadEnumField[UadpNetworkMessageContentMask](ctx, "networkMessageContentMask", "UadpNetworkMessageContentMask", ReadEnum(UadpNetworkMessageContentMaskByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkMessageContentMask' field"))
	}
	m.NetworkMessageContentMask = networkMessageContentMask

	samplingOffset, err := ReadSimpleField(ctx, "samplingOffset", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'samplingOffset' field"))
	}
	m.SamplingOffset = samplingOffset

	noOfPublishingOffset, err := ReadImplicitField[int32](ctx, "noOfPublishingOffset", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfPublishingOffset' field"))
	}
	_ = noOfPublishingOffset

	publishingOffset, err := ReadCountArrayField[float64](ctx, "publishingOffset", ReadDouble(readBuffer, uint8(64)), uint64(noOfPublishingOffset))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publishingOffset' field"))
	}
	m.PublishingOffset = publishingOffset

	if closeErr := readBuffer.CloseContext("UadpWriterGroupMessageDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UadpWriterGroupMessageDataType")
	}

	return m, nil
}

func (m *_UadpWriterGroupMessageDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UadpWriterGroupMessageDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("UadpWriterGroupMessageDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for UadpWriterGroupMessageDataType")
		}

		if err := WriteSimpleField[uint32](ctx, "groupVersion", m.GetGroupVersion(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'groupVersion' field")
		}

		if err := WriteSimpleEnumField[DataSetOrderingType](ctx, "dataSetOrdering", "DataSetOrderingType", m.GetDataSetOrdering(), WriteEnum[DataSetOrderingType, uint32](DataSetOrderingType.GetValue, DataSetOrderingType.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetOrdering' field")
		}

		if err := WriteSimpleEnumField[UadpNetworkMessageContentMask](ctx, "networkMessageContentMask", "UadpNetworkMessageContentMask", m.GetNetworkMessageContentMask(), WriteEnum[UadpNetworkMessageContentMask, uint32](UadpNetworkMessageContentMask.GetValue, UadpNetworkMessageContentMask.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'networkMessageContentMask' field")
		}

		if err := WriteSimpleField[float64](ctx, "samplingOffset", m.GetSamplingOffset(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'samplingOffset' field")
		}
		noOfPublishingOffset := int32(utils.InlineIf(bool((m.GetPublishingOffset()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetPublishingOffset()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfPublishingOffset", noOfPublishingOffset, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfPublishingOffset' field")
		}

		if err := WriteSimpleTypeArrayField(ctx, "publishingOffset", m.GetPublishingOffset(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'publishingOffset' field")
		}

		if popErr := writeBuffer.PopContext("UadpWriterGroupMessageDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for UadpWriterGroupMessageDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_UadpWriterGroupMessageDataType) IsUadpWriterGroupMessageDataType() {}

func (m *_UadpWriterGroupMessageDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_UadpWriterGroupMessageDataType) deepCopy() *_UadpWriterGroupMessageDataType {
	if m == nil {
		return nil
	}
	_UadpWriterGroupMessageDataTypeCopy := &_UadpWriterGroupMessageDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.GroupVersion,
		m.DataSetOrdering,
		m.NetworkMessageContentMask,
		m.SamplingOffset,
		utils.DeepCopySlice[float64, float64](m.PublishingOffset),
	}
	_UadpWriterGroupMessageDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _UadpWriterGroupMessageDataTypeCopy
}

func (m *_UadpWriterGroupMessageDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
