/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// UABinaryFileDataType is the corresponding interface of UABinaryFileDataType
type UABinaryFileDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetNamespaces returns Namespaces (property field)
	GetNamespaces() []PascalString
	// GetStructureDataTypes returns StructureDataTypes (property field)
	GetStructureDataTypes() []StructureDescription
	// GetEnumDataTypes returns EnumDataTypes (property field)
	GetEnumDataTypes() []EnumDescription
	// GetSimpleDataTypes returns SimpleDataTypes (property field)
	GetSimpleDataTypes() []SimpleTypeDescription
	// GetSchemaLocation returns SchemaLocation (property field)
	GetSchemaLocation() PascalString
	// GetFileHeader returns FileHeader (property field)
	GetFileHeader() []KeyValuePair
	// GetBody returns Body (property field)
	GetBody() Variant
	// IsUABinaryFileDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsUABinaryFileDataType()
	// CreateBuilder creates a UABinaryFileDataTypeBuilder
	CreateUABinaryFileDataTypeBuilder() UABinaryFileDataTypeBuilder
}

// _UABinaryFileDataType is the data-structure of this message
type _UABinaryFileDataType struct {
	ExtensionObjectDefinitionContract
	Namespaces         []PascalString
	StructureDataTypes []StructureDescription
	EnumDataTypes      []EnumDescription
	SimpleDataTypes    []SimpleTypeDescription
	SchemaLocation     PascalString
	FileHeader         []KeyValuePair
	Body               Variant
}

var _ UABinaryFileDataType = (*_UABinaryFileDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_UABinaryFileDataType)(nil)

// NewUABinaryFileDataType factory function for _UABinaryFileDataType
func NewUABinaryFileDataType(namespaces []PascalString, structureDataTypes []StructureDescription, enumDataTypes []EnumDescription, simpleDataTypes []SimpleTypeDescription, schemaLocation PascalString, fileHeader []KeyValuePair, body Variant) *_UABinaryFileDataType {
	if schemaLocation == nil {
		panic("schemaLocation of type PascalString for UABinaryFileDataType must not be nil")
	}
	if body == nil {
		panic("body of type Variant for UABinaryFileDataType must not be nil")
	}
	_result := &_UABinaryFileDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Namespaces:                        namespaces,
		StructureDataTypes:                structureDataTypes,
		EnumDataTypes:                     enumDataTypes,
		SimpleDataTypes:                   simpleDataTypes,
		SchemaLocation:                    schemaLocation,
		FileHeader:                        fileHeader,
		Body:                              body,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// UABinaryFileDataTypeBuilder is a builder for UABinaryFileDataType
type UABinaryFileDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(namespaces []PascalString, structureDataTypes []StructureDescription, enumDataTypes []EnumDescription, simpleDataTypes []SimpleTypeDescription, schemaLocation PascalString, fileHeader []KeyValuePair, body Variant) UABinaryFileDataTypeBuilder
	// WithNamespaces adds Namespaces (property field)
	WithNamespaces(...PascalString) UABinaryFileDataTypeBuilder
	// WithStructureDataTypes adds StructureDataTypes (property field)
	WithStructureDataTypes(...StructureDescription) UABinaryFileDataTypeBuilder
	// WithEnumDataTypes adds EnumDataTypes (property field)
	WithEnumDataTypes(...EnumDescription) UABinaryFileDataTypeBuilder
	// WithSimpleDataTypes adds SimpleDataTypes (property field)
	WithSimpleDataTypes(...SimpleTypeDescription) UABinaryFileDataTypeBuilder
	// WithSchemaLocation adds SchemaLocation (property field)
	WithSchemaLocation(PascalString) UABinaryFileDataTypeBuilder
	// WithSchemaLocationBuilder adds SchemaLocation (property field) which is build by the builder
	WithSchemaLocationBuilder(func(PascalStringBuilder) PascalStringBuilder) UABinaryFileDataTypeBuilder
	// WithFileHeader adds FileHeader (property field)
	WithFileHeader(...KeyValuePair) UABinaryFileDataTypeBuilder
	// WithBody adds Body (property field)
	WithBody(Variant) UABinaryFileDataTypeBuilder
	// WithBodyBuilder adds Body (property field) which is build by the builder
	WithBodyBuilder(func(VariantBuilder) VariantBuilder) UABinaryFileDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the UABinaryFileDataType or returns an error if something is wrong
	Build() (UABinaryFileDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() UABinaryFileDataType
}

// NewUABinaryFileDataTypeBuilder() creates a UABinaryFileDataTypeBuilder
func NewUABinaryFileDataTypeBuilder() UABinaryFileDataTypeBuilder {
	return &_UABinaryFileDataTypeBuilder{_UABinaryFileDataType: new(_UABinaryFileDataType)}
}

type _UABinaryFileDataTypeBuilder struct {
	*_UABinaryFileDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (UABinaryFileDataTypeBuilder) = (*_UABinaryFileDataTypeBuilder)(nil)

func (b *_UABinaryFileDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._UABinaryFileDataType
}

func (b *_UABinaryFileDataTypeBuilder) WithMandatoryFields(namespaces []PascalString, structureDataTypes []StructureDescription, enumDataTypes []EnumDescription, simpleDataTypes []SimpleTypeDescription, schemaLocation PascalString, fileHeader []KeyValuePair, body Variant) UABinaryFileDataTypeBuilder {
	return b.WithNamespaces(namespaces...).WithStructureDataTypes(structureDataTypes...).WithEnumDataTypes(enumDataTypes...).WithSimpleDataTypes(simpleDataTypes...).WithSchemaLocation(schemaLocation).WithFileHeader(fileHeader...).WithBody(body)
}

func (b *_UABinaryFileDataTypeBuilder) WithNamespaces(namespaces ...PascalString) UABinaryFileDataTypeBuilder {
	b.Namespaces = namespaces
	return b
}

func (b *_UABinaryFileDataTypeBuilder) WithStructureDataTypes(structureDataTypes ...StructureDescription) UABinaryFileDataTypeBuilder {
	b.StructureDataTypes = structureDataTypes
	return b
}

func (b *_UABinaryFileDataTypeBuilder) WithEnumDataTypes(enumDataTypes ...EnumDescription) UABinaryFileDataTypeBuilder {
	b.EnumDataTypes = enumDataTypes
	return b
}

func (b *_UABinaryFileDataTypeBuilder) WithSimpleDataTypes(simpleDataTypes ...SimpleTypeDescription) UABinaryFileDataTypeBuilder {
	b.SimpleDataTypes = simpleDataTypes
	return b
}

func (b *_UABinaryFileDataTypeBuilder) WithSchemaLocation(schemaLocation PascalString) UABinaryFileDataTypeBuilder {
	b.SchemaLocation = schemaLocation
	return b
}

func (b *_UABinaryFileDataTypeBuilder) WithSchemaLocationBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) UABinaryFileDataTypeBuilder {
	builder := builderSupplier(b.SchemaLocation.CreatePascalStringBuilder())
	var err error
	b.SchemaLocation, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_UABinaryFileDataTypeBuilder) WithFileHeader(fileHeader ...KeyValuePair) UABinaryFileDataTypeBuilder {
	b.FileHeader = fileHeader
	return b
}

func (b *_UABinaryFileDataTypeBuilder) WithBody(body Variant) UABinaryFileDataTypeBuilder {
	b.Body = body
	return b
}

func (b *_UABinaryFileDataTypeBuilder) WithBodyBuilder(builderSupplier func(VariantBuilder) VariantBuilder) UABinaryFileDataTypeBuilder {
	builder := builderSupplier(b.Body.CreateVariantBuilder())
	var err error
	b.Body, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_UABinaryFileDataTypeBuilder) Build() (UABinaryFileDataType, error) {
	if b.SchemaLocation == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'schemaLocation' not set"))
	}
	if b.Body == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'body' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._UABinaryFileDataType.deepCopy(), nil
}

func (b *_UABinaryFileDataTypeBuilder) MustBuild() UABinaryFileDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_UABinaryFileDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_UABinaryFileDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_UABinaryFileDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateUABinaryFileDataTypeBuilder().(*_UABinaryFileDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateUABinaryFileDataTypeBuilder creates a UABinaryFileDataTypeBuilder
func (b *_UABinaryFileDataType) CreateUABinaryFileDataTypeBuilder() UABinaryFileDataTypeBuilder {
	if b == nil {
		return NewUABinaryFileDataTypeBuilder()
	}
	return &_UABinaryFileDataTypeBuilder{_UABinaryFileDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_UABinaryFileDataType) GetExtensionId() int32 {
	return int32(15008)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_UABinaryFileDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_UABinaryFileDataType) GetNamespaces() []PascalString {
	return m.Namespaces
}

func (m *_UABinaryFileDataType) GetStructureDataTypes() []StructureDescription {
	return m.StructureDataTypes
}

func (m *_UABinaryFileDataType) GetEnumDataTypes() []EnumDescription {
	return m.EnumDataTypes
}

func (m *_UABinaryFileDataType) GetSimpleDataTypes() []SimpleTypeDescription {
	return m.SimpleDataTypes
}

func (m *_UABinaryFileDataType) GetSchemaLocation() PascalString {
	return m.SchemaLocation
}

func (m *_UABinaryFileDataType) GetFileHeader() []KeyValuePair {
	return m.FileHeader
}

func (m *_UABinaryFileDataType) GetBody() Variant {
	return m.Body
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastUABinaryFileDataType(structType any) UABinaryFileDataType {
	if casted, ok := structType.(UABinaryFileDataType); ok {
		return casted
	}
	if casted, ok := structType.(*UABinaryFileDataType); ok {
		return *casted
	}
	return nil
}

func (m *_UABinaryFileDataType) GetTypeName() string {
	return "UABinaryFileDataType"
}

func (m *_UABinaryFileDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Implicit Field (noOfNamespaces)
	lengthInBits += 32

	// Array field
	if len(m.Namespaces) > 0 {
		for _curItem, element := range m.Namespaces {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Namespaces), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfStructureDataTypes)
	lengthInBits += 32

	// Array field
	if len(m.StructureDataTypes) > 0 {
		for _curItem, element := range m.StructureDataTypes {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.StructureDataTypes), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfEnumDataTypes)
	lengthInBits += 32

	// Array field
	if len(m.EnumDataTypes) > 0 {
		for _curItem, element := range m.EnumDataTypes {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.EnumDataTypes), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfSimpleDataTypes)
	lengthInBits += 32

	// Array field
	if len(m.SimpleDataTypes) > 0 {
		for _curItem, element := range m.SimpleDataTypes {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.SimpleDataTypes), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (schemaLocation)
	lengthInBits += m.SchemaLocation.GetLengthInBits(ctx)

	// Implicit Field (noOfFileHeader)
	lengthInBits += 32

	// Array field
	if len(m.FileHeader) > 0 {
		for _curItem, element := range m.FileHeader {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.FileHeader), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (body)
	lengthInBits += m.Body.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_UABinaryFileDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_UABinaryFileDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__uABinaryFileDataType UABinaryFileDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("UABinaryFileDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UABinaryFileDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	noOfNamespaces, err := ReadImplicitField[int32](ctx, "noOfNamespaces", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfNamespaces' field"))
	}
	_ = noOfNamespaces

	namespaces, err := ReadCountArrayField[PascalString](ctx, "namespaces", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfNamespaces))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'namespaces' field"))
	}
	m.Namespaces = namespaces

	noOfStructureDataTypes, err := ReadImplicitField[int32](ctx, "noOfStructureDataTypes", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfStructureDataTypes' field"))
	}
	_ = noOfStructureDataTypes

	structureDataTypes, err := ReadCountArrayField[StructureDescription](ctx, "structureDataTypes", ReadComplex[StructureDescription](ExtensionObjectDefinitionParseWithBufferProducer[StructureDescription]((int32)(int32(15489))), readBuffer), uint64(noOfStructureDataTypes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'structureDataTypes' field"))
	}
	m.StructureDataTypes = structureDataTypes

	noOfEnumDataTypes, err := ReadImplicitField[int32](ctx, "noOfEnumDataTypes", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfEnumDataTypes' field"))
	}
	_ = noOfEnumDataTypes

	enumDataTypes, err := ReadCountArrayField[EnumDescription](ctx, "enumDataTypes", ReadComplex[EnumDescription](ExtensionObjectDefinitionParseWithBufferProducer[EnumDescription]((int32)(int32(15490))), readBuffer), uint64(noOfEnumDataTypes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enumDataTypes' field"))
	}
	m.EnumDataTypes = enumDataTypes

	noOfSimpleDataTypes, err := ReadImplicitField[int32](ctx, "noOfSimpleDataTypes", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfSimpleDataTypes' field"))
	}
	_ = noOfSimpleDataTypes

	simpleDataTypes, err := ReadCountArrayField[SimpleTypeDescription](ctx, "simpleDataTypes", ReadComplex[SimpleTypeDescription](ExtensionObjectDefinitionParseWithBufferProducer[SimpleTypeDescription]((int32)(int32(15007))), readBuffer), uint64(noOfSimpleDataTypes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'simpleDataTypes' field"))
	}
	m.SimpleDataTypes = simpleDataTypes

	schemaLocation, err := ReadSimpleField[PascalString](ctx, "schemaLocation", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'schemaLocation' field"))
	}
	m.SchemaLocation = schemaLocation

	noOfFileHeader, err := ReadImplicitField[int32](ctx, "noOfFileHeader", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfFileHeader' field"))
	}
	_ = noOfFileHeader

	fileHeader, err := ReadCountArrayField[KeyValuePair](ctx, "fileHeader", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfFileHeader))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'fileHeader' field"))
	}
	m.FileHeader = fileHeader

	body, err := ReadSimpleField[Variant](ctx, "body", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'body' field"))
	}
	m.Body = body

	if closeErr := readBuffer.CloseContext("UABinaryFileDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UABinaryFileDataType")
	}

	return m, nil
}

func (m *_UABinaryFileDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UABinaryFileDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("UABinaryFileDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for UABinaryFileDataType")
		}
		noOfNamespaces := int32(utils.InlineIf(bool((m.GetNamespaces()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetNamespaces()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfNamespaces", noOfNamespaces, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfNamespaces' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "namespaces", m.GetNamespaces(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'namespaces' field")
		}
		noOfStructureDataTypes := int32(utils.InlineIf(bool((m.GetStructureDataTypes()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetStructureDataTypes()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfStructureDataTypes", noOfStructureDataTypes, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfStructureDataTypes' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "structureDataTypes", m.GetStructureDataTypes(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'structureDataTypes' field")
		}
		noOfEnumDataTypes := int32(utils.InlineIf(bool((m.GetEnumDataTypes()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetEnumDataTypes()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfEnumDataTypes", noOfEnumDataTypes, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfEnumDataTypes' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "enumDataTypes", m.GetEnumDataTypes(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'enumDataTypes' field")
		}
		noOfSimpleDataTypes := int32(utils.InlineIf(bool((m.GetSimpleDataTypes()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetSimpleDataTypes()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfSimpleDataTypes", noOfSimpleDataTypes, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfSimpleDataTypes' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "simpleDataTypes", m.GetSimpleDataTypes(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'simpleDataTypes' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "schemaLocation", m.GetSchemaLocation(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'schemaLocation' field")
		}
		noOfFileHeader := int32(utils.InlineIf(bool((m.GetFileHeader()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetFileHeader()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfFileHeader", noOfFileHeader, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfFileHeader' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "fileHeader", m.GetFileHeader(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'fileHeader' field")
		}

		if err := WriteSimpleField[Variant](ctx, "body", m.GetBody(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'body' field")
		}

		if popErr := writeBuffer.PopContext("UABinaryFileDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for UABinaryFileDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_UABinaryFileDataType) IsUABinaryFileDataType() {}

func (m *_UABinaryFileDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_UABinaryFileDataType) deepCopy() *_UABinaryFileDataType {
	if m == nil {
		return nil
	}
	_UABinaryFileDataTypeCopy := &_UABinaryFileDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopySlice[PascalString, PascalString](m.Namespaces),
		utils.DeepCopySlice[StructureDescription, StructureDescription](m.StructureDataTypes),
		utils.DeepCopySlice[EnumDescription, EnumDescription](m.EnumDataTypes),
		utils.DeepCopySlice[SimpleTypeDescription, SimpleTypeDescription](m.SimpleDataTypes),
		utils.DeepCopy[PascalString](m.SchemaLocation),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.FileHeader),
		utils.DeepCopy[Variant](m.Body),
	}
	_UABinaryFileDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _UABinaryFileDataTypeCopy
}

func (m *_UABinaryFileDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
